package tno.geoenergy.doubletcalc.io.screen;

/*
 * InputWindow.fx
*
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 * 
 */

import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.Group;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.FontPosture;
import javafx.scene.layout.VBox;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.Cursor;
import javafx.scene.image.Image;
import javafx.geometry.HPos;
import javafx.ext.swing.SwingHorizontalAlignment;
import javafx.ext.swing.SwingLabel;
import javafx.ext.swing.SwingTextField;
import javafx.ext.swing.SwingButton;
import javafx.scene.control.ScrollView;

import javax.swing.JOptionPane;

import java.lang.Float;
import java.lang.Math;
import java.lang.System;
import java.lang.String;
import java.io.File;
import java.awt.Frame;

import tno.geoenergy.doubletcalc.TnoGeoThermalProject;
import tno.geoenergy.doubletcalc.TnoUnits;
import tno.geoenergy.doubletcalc.TnoInputWindowData;
import tno.geoenergy.doubletcalc.ResultSet;
import tno.geoenergy.doubletcalc.stochastic.TnoDistributionVarTriangular;
import tno.geoenergy.doubletcalc.stochastic.TnoMyStochasticObjects;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerVar;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;
import tno.geoenergy.doubletcalc.io.file.FileDialog;
import tno.geoenergy.doubletcalc.io.file.CreateXML;


public def NORM_VERSION: String = "1.4.3";
public def NORM_TITLE: String = "Doublet Calculator {NORM_VERSION}";
protected def MC_TITLE: String = "{NORM_TITLE}: simulation running ...";

var error: Boolean = false;
public var file: String = "";
public var filecol: Color = Color.BLACK;
var cursor: Cursor = Cursor.DEFAULT;
public var scr: InputWindow = InputWindow{};


public class InputWindow {

    public var permeabilityMin: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_PERMEABILITY).getDistribution().getMin().toString();
    public var permeabilityLikely: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_PERMEABILITY).getDistribution().getMedian().toString();
    public var permeabilityMax: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_PERMEABILITY).getDistribution().getMax().toString();
    public var thicknessMin: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_THICKNESS).getDistribution().getMin().toString();
    public var thicknessLikely: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_THICKNESS).getDistribution().getMedian().toString();
    public var thicknessMax: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_THICKNESS).getDistribution().getMax().toString();
    public var pressInjTop: String = TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_PRESSURE_INJECTION).getValue().toString();
    public var pressProdTop: String = TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_PRESSURE_PRODUCTION).getValue().toString();;
    public var tempTop: String = TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_TEMPERATURE).getValue().toString();
    public var salinityMin: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_SALINITY).getDistribution().getMin().toString();
    public var salinityLikely: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_SALINITY).getDistribution().getMedian().toString();
    public var salinityMax: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_SALINITY).getDistribution().getMax().toString();
    public var geothermGradient: String = TnoSingularContainer.find(TnoMyStochasticObjects.GEOTHERMAL_GRADIENT).getValue().toString();
    public var surfaceTemp: String = TnoSingularContainer.find(TnoMyStochasticObjects.TEMPERATURE_SURFACE).getValue().toString();
    public var injectTopReservoirDepthLikely: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_TOPINJECTION).getDistribution().getMedian().toString();
    public var prodTopReservoirDepthLikely: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_TOPPRODUCTION).getDistribution().getMedian().toString();;
    public var wellDistance: String = TnoSingularContainer.find(TnoMyStochasticObjects.WELL_DISTANCE).getValue().toString();
    public var pumpEfficiency: String = TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_EFFICIENCY).getValue().toString();
    public var netToGrossMin: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_NG).getDistribution().getMin().toString();
    public var netToGrossLikely: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_NG).getDistribution().getMedian().toString();
    public var netToGrossMax: String = TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_NG).getDistribution().getMax().toString();
    public var runs: String = (TnoSingularContainer.find(TnoMyStochasticObjects.SIMULATION_RUNS).getValue() as Integer).toString();
    public var segmentlength: String = (TnoSingularContainer.find(TnoMyStochasticObjects.SEGMENT_LENGTH).getValue() as Integer).toString();
    public var maxDifference: String = TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_PRESSUREDIFFERENCE).getValue().toString();
    public var skinProduct: String = TnoSingularContainer.find(TnoMyStochasticObjects.SKIN_PRODUCTION).getValue().toString();
    public var skinInject: String = TnoSingularContainer.find(TnoMyStochasticObjects.SKIN_INJECTION).getValue().toString();
    public var tempInjectWater: String = TnoSingularContainer.find(TnoMyStochasticObjects.TEMPERATURE_INJECTION).getValue().toString();
    public var outerDiameterProduct: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_OUTERDIAMETER).getValue().toString();
    public var outerDiameterInject: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_OUTERDIAMETER).getValue().toString();
    public var pumpDepth: String = TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_PRODUCTIONDEPTH).getValue().toString();
    public var khkv: String = TnoSingularContainer.find(TnoMyStochasticObjects.KH_KV).getValue().toString();
    public var injAngle: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_AQUIFER_ANGLE).getValue().toString();
    public var prdAngle: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_AQUIFER_ANGLE).getValue().toString();

   // the injector segments
    var is1: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(0);
    var is2: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(1);
    var is3: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(2);
    var is4: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(3);
    var is5: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(4);
    var is6: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(5);
    var is7: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(6);
    var is8: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getStrValue(7);
    var isd1: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(0);
    var isd2: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(1);
    var isd3: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(2);
    var isd4: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(3);
    var isd5: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(4);
    var isd6: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(5);
    var isd7: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(6);
    var isd8: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getStrValue(7);
    var id1: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(0);
    var id2: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(1);
    var id3: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(2);
    var id4: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(3);
    var id5: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(4);
    var id6: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(5);
    var id7: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(6);
    var id8: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getStrValue(7);
    var ir1: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(0);
    var ir2: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(1);
    var ir3: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(2);
    var ir4: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(3);
    var ir5: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(4);
    var ir6: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(5);
    var ir7: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(6);
    var ir8: String = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getStrValue(7);
    public var is: String[] = bind [is1, is2, is3, is4, is5, is6, is7, is8]; //length AH
    public var isd: String[] = bind [isd1, isd2, isd3, isd4, isd5, isd6, isd7, isd8]; //length TVD
    public var id: String[] = bind [id1, id2, id3, id4, id5, id6, id7, id8]; // diameter
    public var ir: String[] = bind [ir1, ir2, ir3, ir4, ir5, ir6, ir7, ir8]; // roughness

    // the producer segments
    var ps1: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(0);
    var ps2: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(1);
    var ps3: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(2);
    var ps4: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(3);
    var ps5: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(4);
    var ps6: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(5);
    var ps7: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(6);
    var ps8: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getStrValue(7);
    var psd1: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(0);
    var psd2: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(1);
    var psd3: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(2);
    var psd4: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(3);
    var psd5: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(4);
    var psd6: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(5);
     var psd7: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(6);
    var psd8: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getStrValue(7);
    var pd1: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(0);
    var pd2: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(1);
    var pd3: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(2);
    var pd4: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(3);
    var pd5: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(4);
    var pd6: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(5);
    var pd7: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(6);
    var pd8: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getStrValue(7);
    var pr1: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(0);
    var pr2: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(1);
    var pr3: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(2);
    var pr4: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(3);
    var pr5: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(4);
    var pr6: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(5);
    var pr7: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(6);
    var pr8: String = TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getStrValue(7);
    public var ps: String[] = bind [ps1, ps2, ps3, ps4, ps5, ps6, ps7, ps8]; //lenght AH
    public var psd: String[] = bind [psd1, psd2, psd3, psd4, psd5, psd6, psd7, psd8]; //lenght TVD
    public var pd: String[] = bind [pd1, pd2, pd3, pd4, pd5, pd6, pd7, pd8]; //diameter
    public var pr: String[] = bind [pr1, pr2, pr3, pr4, pr5, pr6, pr7, pr8]; //roughness

    protected var title = NORM_TITLE;
    
    public var msg: String[] = ["Unknown", "Zero not allowed (A)", "Zero not allowed (B)", "Zero not allowed (C)",
                "Min > Median (A)", "Max < Median (A)", "Max 1 allowed (A)", "Max 1 allowed (B)",
                "Number of sections not consistent (C)", "Segment depth must increase (C)",
                "Outerdiameter < innerdiameter", "Segment length TVD > segment length AH (C)", "Well segments must reach top aquifer"];
    public var errorcode: Integer = 0;

protected function clearAll(): Void{
    permeabilityMin = "";
    permeabilityLikely = "";
    permeabilityMax = "";
    thicknessMin = "";
    thicknessLikely = "";
    thicknessMax = "";
    pressInjTop = "";
    pressProdTop = "";
    tempTop = "";
    salinityMin = "";
    salinityLikely = "";
    salinityMax = "";
    geothermGradient = "";
    surfaceTemp = "";
    injectTopReservoirDepthLikely = "";
    prodTopReservoirDepthLikely = "";
    wellDistance = "";
    pumpEfficiency = "";
    netToGrossMin = "";
    netToGrossLikely = "";
    netToGrossMax = "";
    runs = "";
    segmentlength = "";
    maxDifference = "";
    skinProduct = "";
    skinInject = "";
    tempInjectWater = "";
    outerDiameterProduct = "";
    outerDiameterInject = "";
    pumpDepth = "";
    khkv = "";
    injAngle = "";
    prdAngle = "";
    pushXMLimportIS("");
    pushXMLimportISD("");
    pushXMLimportID("");
    pushXMLimportIR("");
    pushXMLimportPS("");
    pushXMLimportPSD("");
    pushXMLimportPD("");
    pushXMLimportPR("");
}

protected function clearAtStart(): Void{
    permeabilityMin = "";
    permeabilityLikely = "";
    permeabilityMax = "";
    thicknessMin = "";
    thicknessLikely = "";
    thicknessMax = "";
    //pressInjTop = "";
    //pressProdTop = "";
    //tempTop = "";
    salinityMin = "";
    salinityLikely = "";
    salinityMax = "";
    //geothermGradient = "";
    //surfaceTemp = "";
    injectTopReservoirDepthLikely = "";
    prodTopReservoirDepthLikely = "";
    wellDistance = "";
    pumpEfficiency = "";
    netToGrossMin = "";
    netToGrossLikely = "";
    netToGrossMax = "";
    //runs = "";
    //segmentlength = "";
    maxDifference = "";
    skinProduct = "";
    skinInject = "";
    tempInjectWater = "";
    outerDiameterProduct = "";
    outerDiameterInject = "";
    pumpDepth = "";
    khkv = "";
    injAngle = "";
    prdAngle = "";
    pushXMLimportIS("");
    pushXMLimportISD("");
    pushXMLimportID("");
    pushXMLimportIR("");
    pushXMLimportPS("");
    pushXMLimportPSD("");
    pushXMLimportPD("");
    pushXMLimportPR("");
}

public function pushXMLimportIS(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");
    try { is1 = arr[0]; } catch (any) { is1 = "" };
    try { is2 = arr[1]; } catch (any) { is2 = "" };
    try { is3 = arr[2]; } catch (any) { is3 = "" };
    try { is4 = arr[3]; } catch (any) { is4 = "" };
    try { is5 = arr[4]; } catch (any) { is5 = "" };
    try { is6 = arr[5]; } catch (any) { is6 = "" };
    try { is7 = arr[6]; } catch (any) { is7 = "" };
    try { is8 = arr[7]; } catch (any) { is8 = "" };
}


public function pushXMLimportISD(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");
        try { isd1= arr[0]; } catch(any){ isd1=""} ;
        try { isd2= arr[1]; } catch(any){ isd2=""} ;
        try { isd3= arr[2]; } catch(any){ isd3=""} ;
        try { isd4= arr[3]; } catch(any){ isd4=""} ;
        try { isd5= arr[4]; } catch(any){ isd5=""} ;
        try { isd6= arr[5]; } catch(any){ isd6=""} ;
        try { isd7= arr[6]; } catch(any){ isd7=""} ;
        try { isd8= arr[7]; } catch(any){ isd8=""} ;
        }

public function pushXMLimportID(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");

        try { id1= arr[0]; } catch(any){ id1=""} ;
        try { id2= arr[1]; } catch(any){ id2=""} ;
        try { id3= arr[2]; } catch(any){ id3=""} ;
        try { id4= arr[3]; } catch(any){ id4=""} ;
        try { id5= arr[4]; } catch(any){ id5=""} ;
        try { id6= arr[5]; } catch(any){ id6=""} ;
        try { id7= arr[6]; } catch(any){ id7=""} ;
        try { id8= arr[7]; } catch(any){ id8=""} ;
    }

public function pushXMLimportIR(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");
 
        try { ir1= arr[0]; } catch(any){ ir1=""} ;
        try { ir2= arr[1]; } catch(any){ ir2=""} ;
        try { ir3= arr[2]; } catch(any){ ir3=""} ;
        try { ir4= arr[3]; } catch(any){ ir4=""} ;
        try { ir5= arr[4]; } catch(any){ ir5=""} ;
        try { ir6= arr[5]; } catch(any){ ir6=""} ;
        try { ir7= arr[6]; } catch(any){ ir7=""} ;
        try { ir8= arr[7]; } catch(any){ ir8=""} ;
  
    }

public function pushXMLimportPS(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");
   
        try { ps1= arr[0]; } catch(any){ ps1=""} ;
        try { ps2= arr[1]; } catch(any){ ps2=""} ;
        try { ps3= arr[2]; } catch(any){ ps3=""} ;
        try { ps4= arr[3]; } catch(any){ ps4=""} ;
        try { ps5= arr[4]; } catch(any){ ps5=""} ;
        try { ps6= arr[5]; } catch(any){ ps6=""} ;
        try { ps7= arr[6]; } catch(any){ ps7=""} ;
        try { ps8= arr[7]; } catch(any){ ps8=""} ;
    }

public function pushXMLimportPSD(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");
        try { psd1= arr[0]; } catch(any){ psd1=""} ;
        try { psd2= arr[1]; } catch(any){ psd2=""} ;
        try { psd3= arr[2]; } catch(any){ psd3=""} ;
        try { psd4= arr[3]; } catch(any){ psd4=""} ;
        try { psd5= arr[4]; } catch(any){ psd5=""} ;
        try { psd6= arr[5]; } catch(any){ psd6=""} ;
        try { psd7= arr[6]; } catch(any){ psd7=""} ;
        try { psd8= arr[7]; } catch(any){ psd8=""} ;
        }

 public function pushXMLimportPD(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");
        try { pd1= arr[0]; } catch(any){ pd1=""} ;
        try { pd2= arr[1]; } catch(any){ pd2=""} ;
        try { pd3= arr[2]; } catch(any){ pd3=""} ;
        try { pd4= arr[3]; } catch(any){ pd4=""} ;
        try { pd5= arr[4]; } catch(any){ pd5=""} ;
        try { pd6= arr[5]; } catch(any){ pd6=""} ;
        try { pd7= arr[6]; } catch(any){ pd7=""} ;
        try { pd8= arr[7]; } catch(any){ pd8=""} ;
       }
public function pushXMLimportPR(xmlvar: String): Void {
    var arr: String[] = xmlvar.split(",");
        try { pr1= arr[0]; } catch(any){ pr1=""} ;
        try { pr2= arr[1]; } catch(any){ pr2=""} ;
        try { pr3= arr[2]; } catch(any){ pr3=""} ;
        try { pr4= arr[3]; } catch(any){ pr4=""} ;
        try { pr5= arr[4]; } catch(any){ pr5=""} ;
        try { pr6= arr[5]; } catch(any){ pr6=""} ;
        try { pr7= arr[6]; } catch(any){ pr7=""} ;
        try { pr8= arr[7]; } catch(any){ pr8=""} ;
    }
    



public function getBaseGroup(): Group{
    return baseGroup;
}

public function getGeotechnicalGroup(): Group{
    return geotechnical;
}

protected function checkFilename(str: String): String{

     var fileStr: String;

     def MAXLENGTH: Integer = 90;

       if( str.length() > MAXLENGTH)
       fileStr = " ... {str.substring(str.length() - MAXLENGTH)}"
       else fileStr = str;

    return fileStr;
};


protected function saveScenario(): Void {

    var fd: FileDialog = FileDialog.getInstance();
    fd.setTitle("Save Scenario");
    fd.setExtension(".xml");
    var cxml = new CreateXML();

    var filedata: File = fd.saveDialog();

    var filename: String = filedata.toString();

    var fileStr = checkFilename( filename );
    if(filename != null){
        filecol = Color.BLACK;
        file = "  file: {fileStr}";
        cxml.createXML(filedata, this);
    }
}


protected function loadScenario(): Void {

    clearAll();
    
    var fd: FileDialog = FileDialog.getInstance();
    fd.setTitle("Open Scenario");
    fd.setExtension(".xml");
    var cxml = new CreateXML();

    var filedata: File = fd.openDialog();

    var filename: String = filedata.toString();

    var fileStr = checkFilename(filename);
    if(filename != null){
        filecol = Color.BLACK;
        file = "  file: {fileStr}";
        cxml.loadXML(filedata, this);
    }
}

protected function numRound(num: Number, dec: Integer): Number {

    def p:Number= Math.pow(10, dec);
    return Math.round(num*p)/p;
}

protected function toNumber(str: String): Number{

    var num:Number;

    try{
    	num = Float.parseFloat(str);
    }
    catch(any){
    	num = 0;
    }

    return num;
}

protected function toArray(arr: String[] ): Double[] {
    //println("new array");
    var num:Number;
    var cleanArr: Double[];
    for (str in arr){
        try{
            num = Float.parseFloat(str);
            insert num into cleanArr;
            //println(num);
            }
        catch(any){   
        }
    }
    return cleanArr;
}

protected function toArray(arr: String[], scale:Number ): Double[] {
    //println("new array");
    var num:Number;
    var cleanArr: Double[];
    for (str in arr){
        try{
            num = Float.parseFloat(str)*scale;
            insert num into cleanArr;
            //println(num);
            }
        catch(any){   
        }
    }
    return cleanArr;
}

function proveInput(input: TnoInputWindowData): Boolean{
    
    var err: Boolean = false;
    errorcode = 0;

    // non zero cases
    if ( input.getAquiferK().getDistribution().getMin() == 0) {err = true; errorcode = 1;}
    if ( input.getAquiferThickness().getDistribution().getMin() == 0 ) {err = true; errorcode = 1;}
    if ( input.getAquiferNtG().getDistribution().getMin() == 0 ) {err = true; errorcode = 1;}
    if ( input.getAquiferTopDepthAtInj().getDistribution().getMin() == 0 ) {err = true; errorcode = 1;}
    if ( input.getAquiferTopDepthAtProd().getDistribution().getMin() == 0 ) {err = true; errorcode = 1;}
    if ( input.getAquiferSalinity().getDistribution().getMin() == 0 ) {err = true; errorcode = 1;}
    
    if ( input.getAquiferKhKv() == 0 ) {err = true; errorcode = 1;}
    if ( input.getOuterDiameterPrd() == 0 ) {err = true; errorcode = 3;}
    if ( input.getOuterDiameterInj() == 0 ) {err = true; errorcode = 3;}
    if ( input.getDistanceWellsAtAquifer() == 0 ) {err = true; errorcode = 2;}
    if ( input.getPumpPressureDrawDown() == 0 ) {err = true; errorcode = 2;}
    if ( input.getPumpEfficiency() == 0 ) {err = true; errorcode = 2;}
    
    if ( input.getGeoThermalGradient() == 0 and input.getTempTopProductionAquifer() == 0  ) {err = true; errorcode = 1;}
    if ( input.getSegmentLength() == 0) {err = true; errorcode = 3;}
    
    
    //Well design injector
    if ( sizeof input.getSegmentsInj() == 0) {err = true; errorcode = 8; }
    if ( sizeof input.getSegmentsInj() != sizeof input.getSegmentsInjTVD()) {err = true; errorcode = 8; }
    if ( sizeof input.getSegmentsInj() != sizeof input.getRoughnessInj() ) {err = true; errorcode = 8; }
    if ( sizeof input.getSegmentsInj() != sizeof input.getInnerDiameterInj() ) {err = true; errorcode = 8; }
    
    if (input.getSegmentsInj()[0] == 0) {err = true; errorcode = 3;  }
    for (segI in [1 .. sizeof input.getSegmentsInj()-1]){
        if (input.getSegmentsInj()[segI] <= input.getSegmentsInj()[segI-1]) {err = true; errorcode = 9;}
        if (input.getSegmentsInjTVD()[segI] <= input.getSegmentsInjTVD()[segI-1]) {err = true; errorcode = 9;}
        if ((input.getSegmentsInj()[segI] - input.getSegmentsInj()[segI-1]) < (input.getSegmentsInjTVD()[segI] - input.getSegmentsInjTVD()[segI-1]) ) {err = true; errorcode = 11;}
    }
    if (input.getSegmentsInj()[0] < input.getSegmentsInjTVD()[0]) {err = true; errorcode = 11;}

    for (seg in input.getRoughnessInj()){
        if (seg == 0) {err = true; errorcode = 3;}
    }
    for (seg in input.getInnerDiameterInj()){
            if (seg == 0) {err = true; errorcode = 3;}
        }
    //if (input.getInnerDiameterInj()[sizeof input.getInnerDiameterInj()-1] >= input.getOuterDiameterInj() ) {err = true; errorcode = 10;}
    if (input.getSegmentsInjTVD()[sizeof input.getSegmentsInjTVD()-1] < input.getAquiferTopDepthAtInj().getDistribution().getMedian() ) {err = true; errorcode = 12;}
 
    //Well design poducer
    if ( sizeof input.getSegmentsPrd() == 0) {err = true; errorcode = 8; }
    if ( sizeof input.getSegmentsPrd() != sizeof input.getSegmentsPrdTVD()) {err = true; errorcode = 8;}
    if ( sizeof input.getSegmentsPrd() != sizeof input.getRoughnessPrd()) {err = true; errorcode = 8;}
    if ( sizeof input.getSegmentsPrd() != sizeof input.getInnerDiameterPrd() ) {err = true; errorcode = 8; }
    
    if (input.getSegmentsPrd()[0] == 0) {err = true; errorcode = 3;}
    for (segI in [1 .. input.getSegmentsPrd().length-1]){
        if (input.getSegmentsPrd()[segI] <= input.getSegmentsPrd()[segI-1]) {err = true; errorcode = 9;}
        if (input.getSegmentsPrdTVD()[segI] <= input.getSegmentsPrdTVD()[segI-1]) {err = true; errorcode = 9;}
        if ((input.getSegmentsPrd()[segI] - input.getSegmentsPrd()[segI-1]) < (input.getSegmentsPrdTVD()[segI] - input.getSegmentsPrdTVD()[segI-1]) ) {err = true; errorcode = 11;}
    }
    if (input.getSegmentsPrd()[0] < input.getSegmentsPrdTVD()[0]) {err = true; errorcode = 11;}

    for (seg in input.getRoughnessPrd()){
        if (seg == 0) {err = true; errorcode = 3;}
    }
    for (seg in input.getInnerDiameterPrd()){
            if (seg == 0) {err = true; errorcode = 3;}
        }
    //if (input.getInnerDiameterPrd()[sizeof input.getInnerDiameterPrd()-1] >= input.getOuterDiameterPrd() ) {err = true; errorcode = 10;}
    if (input.getSegmentsPrdTVD()[sizeof input.getSegmentsPrdTVD()-1] < input.getAquiferTopDepthAtProd().getDistribution().getMedian() ) {err = true; errorcode = 12;}

    // permeability
    if ( input.getAquiferK().getDistribution().getMin() >= input.getAquiferK().getDistribution().getMedian() ) {err = true; errorcode = 4;}
    if ( input.getAquiferK().getDistribution().getMedian() >= input.getAquiferK().getDistribution().getMax() ) {err = true; errorcode = 5;}

    // thickness
    if (input.getAquiferThickness().getDistribution().getMin() >= input.getAquiferThickness().getDistribution().getMedian()) {err = true; errorcode = 4;}
    if (input.getAquiferThickness().getDistribution().getMedian() >= input.getAquiferThickness().getDistribution().getMax()) {err = true; errorcode = 5;}

    // given reservoir pressures
    if (input.getAquiferInjectTopPressure() != 0 and input.getAquiferProductTopPressure() == 0 ) err = true;
    if (input.getAquiferInjectTopPressure() == 0 and input.getAquiferProductTopPressure() != 0 ) err = true;

    // N/G
    if (input.getAquiferNtG().getDistribution().getMin() >= input.getAquiferNtG().getDistribution().getMedian()) {err = true; errorcode = 4;}
    if (input.getAquiferNtG().getDistribution().getMedian() >= input.getAquiferNtG().getDistribution().getMax()) {err = true; errorcode = 5;}
    if (input.getAquiferNtG().getDistribution().getMax() > 1.010) { err = true; errorcode = 6;}

	// salinity
	if (input.getAquiferSalinity().getDistribution().getMin() >= input.getAquiferSalinity().getDistribution().getMedian()){ err = true; errorcode = 4;}
	if (input.getAquiferSalinity().getDistribution().getMedian() >= input.getAquiferSalinity().getDistribution().getMax()){ err = true; errorcode = 5;}
	
	// other
    if (  ( input.getOuterDiameterPrd() * 2.54e-2 )  >= input.getDistanceWellsAtAquifer() ) err = true;
    if ( input.getPumpEfficiency() > 1.0 ) { err = true; errorcode = 7;}
    if ( input.getPumpDepth() > input.getAquiferTopDepthAtProd().getDistribution().getMin() ) err = true;
    if ( input.getNumberOfSimulations() < 1 ) err = true;
    
    return err;
    }

protected function createInputObject(): Void{
    
    error = false;

	if (geothermGradient == "" and tempTop != "" ) geothermGradient = "0";
	if (tempTop == "") tempTop = "0";
	if (pressInjTop == "") pressInjTop = "0";
	if (pressProdTop == "") pressProdTop = "0";
	
	try{
	    var numSim: Number = Math.round( Math.abs( Float.parseFloat( runs ) ) );
	    TnoSingularContainer.find(TnoMyStochasticObjects.SIMULATION_RUNS).setValue( numSim );
	
	    var aquiferTopDepthProdDist = new TnoDistributionVarTriangular(Math.abs( getMinProdResDepth() ),
	           Math.abs( Float.parseFloat(prodTopReservoirDepthLikely) ),
	           Math.abs( getMaxProdResDepth() ) );
	    TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_TOPPRODUCTION).setSamplesAndDist(numSim, aquiferTopDepthProdDist);
	 	
		var aquiferTopDepthInjectDist = new TnoDistributionVarTriangular( Math.abs( getMinInjResDepth() ),
		       Math.abs( Float.parseFloat(injectTopReservoirDepthLikely) ),
		       Math.abs( getMaxInjResDepth() ) );
		TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_TOPINJECTION).setSamplesAndDist(numSim, aquiferTopDepthInjectDist);
		
		var aquiferThicknessDist = new TnoDistributionVarTriangular( Math.abs( Float.parseFloat(thicknessMin) ),
			    Math.abs( Float.parseFloat(thicknessLikely) ), Math.abs( Float.parseFloat(thicknessMax) ) );
		TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_THICKNESS).setSamplesAndDist(numSim, aquiferThicknessDist);
		 
		var permDist = new TnoDistributionVarTriangular( Math.abs( Float.parseFloat(permeabilityMin) * TnoUnits.mDarcy_SI ),
		    Math.abs( Float.parseFloat(permeabilityLikely) * TnoUnits.mDarcy_SI ),
		    Math.abs( Float.parseFloat(permeabilityMax) * TnoUnits.mDarcy_SI ) );
		TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_PERMEABILITY).setSamplesAndDist(numSim, permDist);
		 
		var ntgDist: TnoDistributionVarTriangular =  new TnoDistributionVarTriangular( Math.abs( Float.parseFloat( netToGrossMin ) ),
		    Math.abs( Float.parseFloat( netToGrossLikely ) ),
		    Math.abs( Float.parseFloat(netToGrossMax) ) );
		TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_NG).setSamplesAndDist(numSim, ntgDist);
		
		var salinityDist: TnoDistributionVarTriangular =  new TnoDistributionVarTriangular( Math.abs( Float.parseFloat(salinityMin)/1e6 ),
			Math.abs( Float.parseFloat(salinityLikely)/1e6 ),
			Math.abs( Float.parseFloat(salinityMax)/1e6 ) );
		TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_SALINITY).setSamplesAndDist(numSim, salinityDist);
		
		var pressure: Number;
		if ( pressProdTop == "")  pressure = 0.0
		else pressure = Math.abs(Float.parseFloat(pressProdTop) * TnoUnits.Bar_SI);
		TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_PRESSURE_PRODUCTION).setValue( pressure );
		
		if ( pressInjTop == "") pressure = 0.0
		else pressure = Math.abs(Float.parseFloat(pressInjTop)* TnoUnits.Bar_SI );
		TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_PRESSURE_INJECTION).setValue( pressure );
		
		var temperature: Number;
		if ( surfaceTemp=="") temperature = 0.0
		else temperature = Math.abs(Float.parseFloat(surfaceTemp));
		TnoSingularContainer.find(TnoMyStochasticObjects.TEMPERATURE_SURFACE).setValue( temperature );
		 
		var tGradient: Number;
		var tempTopNum: Number = Math.abs( Float.parseFloat(tempTop) );
		if (tempTopNum == 0) tGradient = Math.abs(Float.parseFloat(geothermGradient))
		else tGradient = ( tempTopNum - TnoSingularContainer.find(TnoMyStochasticObjects.TEMPERATURE_SURFACE).getValue() ) / 
                                    (TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_TOPPRODUCTION).getDistribution().getMedian() +
                                    TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_THICKNESS).getDistribution().getMedian()*0.5);
		TnoSingularContainer.find(TnoMyStochasticObjects.GEOTHERMAL_GRADIENT).setValue( tGradient );
                TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_TEMPERATURE).setValue( tempTopNum );
		
		TnoSingularContainer.find(TnoMyStochasticObjects.KH_KV).setValue( Math.abs(Float.parseFloat( khkv )) );
		
		TnoSingularContainer.find(TnoMyStochasticObjects.TEMPERATURE_INJECTION).setValue( Math.abs(Float.parseFloat( tempInjectWater )) );
		TnoSingularContainer.find(TnoMyStochasticObjects.WELL_DISTANCE).setValue( Math.abs(Float.parseFloat( wellDistance )) );
		TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_EFFICIENCY).setValue( Math.abs(Float.parseFloat( pumpEfficiency ) ) );
		TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_PRODUCTIONDEPTH).setValue( Math.abs(Float.parseFloat( pumpDepth ) ) );
		TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_PRESSUREDIFFERENCE).setValue( Math.abs(Float.parseFloat( maxDifference )* TnoUnits.Bar_SI ) );
		
                TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).setArray(toArray(is));
		TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).setArray(toArray(ps));
		TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).setArray(toArray(psd));
		TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).setArray(toArray(isd));
		TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).setArray(toArray(id, TnoUnits.Inch_SI ));
		TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).setArray(toArray(pd, TnoUnits.Inch_SI ));
		TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).setArray(toArray(ir, TnoUnits.Inch_SI* 1e-3 ));
		TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).setArray(toArray(pr, TnoUnits.Inch_SI* 1e-3 ));
		 		  				 
		TnoSingularContainer.find(TnoMyStochasticObjects.INJ_OUTERDIAMETER).setValue( Math.abs(Float.parseFloat( outerDiameterInject ) * TnoUnits.Inch_SI ) );
		TnoSingularContainer.find(TnoMyStochasticObjects.PRD_OUTERDIAMETER).setValue( Math.abs(Float.parseFloat( outerDiameterProduct ) * TnoUnits.Inch_SI ) );

                TnoSingularContainer.find(TnoMyStochasticObjects.PRD_ANGLE_SKIN).setValue( 0 + getSkinProductInc() );
		TnoSingularContainer.find(TnoMyStochasticObjects.INJ_ANGLE_SKIN).setValue( 0 + getSkinInjectInc() );
		TnoSingularContainer.find(TnoMyStochasticObjects.SKIN_PRODUCTION).setValue( Float.parseFloat( skinProduct ) );
		TnoSingularContainer.find(TnoMyStochasticObjects.SKIN_INJECTION).setValue( Float.parseFloat( skinInject ) );
                TnoSingularContainer.find(TnoMyStochasticObjects.TOTAL_SKIN_PRODUCTION).setValue( Float.parseFloat( skinProduct )+ getSkinProductInc() );
		TnoSingularContainer.find(TnoMyStochasticObjects.TOTAL_SKIN_INJECTION).setValue( Float.parseFloat( skinInject )+ getSkinInjectInc() );
			
		TnoSingularContainer.find(TnoMyStochasticObjects.SEGMENT_LENGTH).setValue( Math.abs(Float.parseFloat( segmentlength ) ) );
	
		//var debug = TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS).getArray();
		//for (i in debug) println(i);
		
	} //try
	catch (any){
	    error = true;
	    any.printStackTrace();
	}

	var input: TnoInputWindowData = new TnoInputWindowData();
	if (not error) error = proveInput(input);
}

protected bound function getMinInjResDepth(): Number{
    var minInjDepth = bind injectTopReservoirDepthLikely;

    var minInjNum: Number = toNumber(minInjDepth);

   return Math.abs(numRound(minInjNum - (0.1 * minInjNum), 0));
};

 protected bound function getMaxInjResDepth(): Number{
    var maxInjDepth = bind injectTopReservoirDepthLikely;

    def maxInjNum: Number = toNumber(maxInjDepth);

   return Math.abs(numRound(maxInjNum + (0.1 * maxInjNum), 0));
};

protected bound function getMaxInjResDepth2(): Number{
    var maxInjDepth = bind thicknessLikely;

    def maxInjNum: Number = toNumber(maxInjDepth);

   return Math.abs(numRound(maxInjNum + (0.1 * maxInjNum), 0));
};

protected bound function getMinProdResDepth(): Number{
    var minProdDepth = bind prodTopReservoirDepthLikely;

    def minProdNum: Number = toNumber(minProdDepth);

   return Math.abs(numRound(minProdNum - (0.1 * minProdNum), 0));
    };

protected bound function getMaxProdResDepth(): Number{
    var maxProdDepth = bind prodTopReservoirDepthLikely;

    def maxProdNum: Number = toNumber(maxProdDepth);

   return Math.abs(numRound(maxProdNum + (0.1 * maxProdNum), 0));
};

protected bound function getSkinInjectInc(): Number{
    var injAngle = bind this.injAngle;
    var khkv = bind this.khkv;
    var thickness = bind thicknessLikely;
    var outerDiameter = outerDiameterInject;
    
    def hd = Math.pow(toNumber(thickness)/(toNumber(outerDiameter)* TnoUnits.Inch_SI/2),0.152);
    def I = Math.pow(Math.sqrt(toNumber(khkv)), 0.964);
    def sin_angle = Math.pow(Math.sin(Math.toRadians(toNumber(injAngle))), 5.87);
    
    def S_angle = -2.48 * sin_angle * hd / I;

   return numRound(S_angle, 2);
};

protected bound function getSkinProductInc(): Number{
   var prdAngle = bind this.prdAngle;
   var khkv = bind this.khkv;
   var thickness = bind thicknessLikely;
   var outherDiameter = bind outerDiameterProduct;
   
   def hd = Math.pow(toNumber(thickness)/(toNumber(outherDiameter)* TnoUnits.Inch_SI/2),0.152);
   def I = Math.pow(Math.sqrt(toNumber(khkv)), 0.964);
   def sin_angle = Math.pow(Math.sin(Math.toRadians(toNumber(prdAngle))), 5.87);
   
   def S_angle = -2.48 * sin_angle * hd / I;
   
  return numRound(S_angle, 2);
};

var scene:Scene;
var contentarea: VBox;

public function inputWindow():Void{

 clearAtStart();
	
 Stage {
    title: bind title
    visible: true
    icons: Image{
    	url: "{__DIR__}TNO.png"
    	}
    onClose: function() { 
           exitScreen();
            }
    scene: scene = Scene {
        	width: 825
                height: 850
                content:[
                    ScrollView {
                        width: bind scene.width
                        height: bind scene.height

                        node:
                        Group {
                            content: [
                                Rectangle {
                                    width: bind contentarea.width +24
                                    height: bind contentarea.height +10
                                    fill: Color.WHITE
                                    stroke: null
                                },

                               contentarea = VBox {
                                    content: [
                                        baseGroup,
                                        geotechnical,
                                    ]
                                } //VBox
                              ]
                        }
         		} //ScrollView
	        ]
	}// scene
  }// Stage
} // mainWindow


protected function getOutputObject(numSamples: Double, numYears2: Integer): AquiferOutput{
    return new AquiferOutput;
}


protected function getResultSet(): ResultSet{
    var project: TnoGeoThermalProject = new TnoGeoThermalProject();
    var rs: ResultSet = project.calculate();
    return rs;	
}


protected function calculate(numYears: Integer): Void{
    cursor = Cursor.WAIT;
      createInputObject();

    if(not error) {
            error = false;
            title = MC_TITLE;
            var result: ResultSet = getResultSet();
            if ( result != null){
                var numSamples: Double = TnoSingularContainer.find(TnoMyStochasticObjects.SIMULATION_RUNS).getValue();
                var output: AquiferOutput  = getOutputObject(numSamples, numYears);
                output.getResultTable(result);
                output.getOutPutwarningsWarning();
            }


            title = NORM_TITLE;
           
            }
            else{
              var frame: Frame = new Frame();
              JOptionPane.showMessageDialog(frame,
              "Erratic input. Please check! \n{msg[errorcode]}",
              "Warning",
              JOptionPane.WARNING_MESSAGE);
           }
            cursor= cursor.DEFAULT;
}


protected function exitScreen(): Void{
 var frame: Frame = new Frame();
    	var i:Integer  = JOptionPane.showConfirmDialog(frame,
    	                    "Save scenario before exit?",
    	                    "Exit program",
    	                    JOptionPane.YES_NO_OPTION,
    	                    JOptionPane.WARNING_MESSAGE
    	                    );
    	         
    	if (i == JOptionPane.YES_OPTION) saveScenario();
    	
    	System.exit(0);
}
                                           


// definition of upper group
protected def columns: Integer=4;
protected def HEAD2: Integer = 14;
 protected def HEAD1: Integer = 16;
 protected def ROW_SPACING: Integer = 4;
 protected def GROUP_SPACING: Integer = 25;
 protected def COLUMN_SPACING: Integer = 4;

protected def baseGroup:Group = Group{
              content: [

               VBox{
               spacing: ROW_SPACING*2
               content: [

                   HBox {
                       spacing: COLUMN_SPACING
                       height: 25
                 content: [
                           SwingLabel{
                            text: TnoSingularContainer.find(TnoMyStochasticObjects.SIMULATION_RUNS).getTitle()
                            height: 25
                            font: Font.font("Arial", FontWeight.REGULAR, FontPosture.ITALIC, 14)
                            foreground: Color.BLUE
                            },
                            SwingTextField {
                               columns: columns
                               text: bind runs with inverse
                               font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                               },

                           SwingButton {
                                 width: 100
                                 text: "Calculate !"
                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                 action: function() {
                                 calculate(1);
                               }
                           },
                           Rectangle {
                              x: 0, y:10
                              width: 50, height: 10
                              stroke: Color.WHITE
                              fill: null
                           },

                            SwingButton {
                                 text: "Open Scenario"
                                 width: 100
                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                action: function() {
                                loadScenario();
                               }
                           },

                           SwingButton {
                                 text: "Save Scenario"
                                 width: 100
                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                action: function() {
                                saveScenario();

                               }
                           },
                           Rectangle {
                              x: 0, y:10
                              width: 50, height: 10
                              stroke: Color.WHITE
                              fill: null
                           },

                           SwingButton {
                                 text: "Exit Program"
                                 width: 100
                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                action: function() {
                                 exitScreen();

                               }
                           },

                   ]
                  },   // Button HBox
                  SwingLabel{
                               text: bind file
                               foreground: bind filecol
                               font: Font.font("Arial", FontWeight.REGULAR, FontPosture.REGULAR, 13)
                               visible:true
                               width: 600
                           },
                      
                          // error
                 
                   ]
               }, // VBox
               ]
               }; //upper group

 //definition of lower group
 protected def geotechnical: Group =  Group{
               		visible: true
                        
                    content: [
                    	VBox{
                       	spacing: ROW_SPACING
                        content: [
                        	SwingLabel{
                               text: " Geotechnical input"

                               foreground: Color.BROWN
                               font: Font.font("Arial", FontWeight.BOLD, 26  )
                               visible:true
                           	},
                            SwingLabel {
                               text: " A) Aquifer properties "
                               font: Font.font("Arial", FontWeight.BOLD, HEAD1  )
                               foreground: Color.DARKRED
                           	},
                           // R1
                           HBox{
                            spacing: GROUP_SPACING
                            content:[
                               OutputRow{
                                isBold: true
                                title: "Property"
                                min: "min"
                                median: "median"
                                max: "max"
                               }.getRow(),
                               
                               OutputRow{
                                isBold: true 
                                title: "Property"
                                min: "value"
                               }.getSmallRow()
                               ]
                           }, //HBox

							// R2
  							HBox{
                             spacing: GROUP_SPACING
                             content:[
	                             HBox{
	                             	spacing: COLUMN_SPACING
	                             	content: [
	                             		OutputRow{title: TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_PERMEABILITY).getTitle()
	                             			}.getHeader(),
	                             		SwingTextField{
	                             			text: bind permeabilityMin with inverse
	                             			editable: true
	                             			disable: false
	                             			columns: 6
	                             			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	                             			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	                             		 },
	                             		 SwingTextField{
	                             			text: bind permeabilityLikely with inverse
	                             			editable: true
	                             			disable: false
	                             			columns: 6
	                             			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	                             			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	                             		 },
	                             		 SwingTextField{
	                             			text: bind permeabilityMax with inverse
	                             			editable: true
	                             			disable: false
	                             			columns: 6
	                             			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	                             			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	                             		 },
	                             	]
	                             },
                              	HBox{
                              		spacing: COLUMN_SPACING
                                    content: [
                               			OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.KH_KV).getTitle()
                               				}.getHeader(),
                               			SwingTextField{
                                            text: bind khkv with inverse
                                            editable: true
                                            disable: false
                                            columns: 6
                                            horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                            font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                            },
                               			]
                              		}
                               ]
                            }, //HBox
  							
						// R3
                           HBox{
                            spacing: GROUP_SPACING
                            content:[
                            	HBox{
                            		spacing: COLUMN_SPACING
                            		content: [
                            			OutputRow{title: TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_NG).getTitle()
                            				}.getHeader(),
                            			SwingTextField{
                            				text: bind netToGrossMin with inverse
                            				editable: true
                            				disable: false
                            				columns: 6
                            				horizontalAlignment: SwingHorizontalAlignment.RIGHT
                            				font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                            			 },
                            			 SwingTextField{
                            				text: bind netToGrossLikely with inverse
                            				editable: true
                            				disable: false
                            				columns: 6
                            				horizontalAlignment: SwingHorizontalAlignment.RIGHT
                            				font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                            			 },
                            			 SwingTextField{
                            				text: bind netToGrossMax with inverse
                            				editable: true
                            				disable: false
                            				columns: 6
                            				horizontalAlignment: SwingHorizontalAlignment.RIGHT
                            				font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                            			 },
                            		]
                            	},
	                              HBox{
	                              	spacing: COLUMN_SPACING
	                              	content: [
	                              		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.TEMPERATURE_SURFACE).getTitle()
	                              			}.getHeader(),
	                              		SwingTextField{
	                              			text: bind surfaceTemp with inverse
	                              			editable: true
	                              			disable: false
	                              			columns: 6
	                              			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	                              			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	                              			},
	                              		]
	                              	}
                                   ]
                           }, //HBox
                           
                           // R4
                            HBox{
                                spacing: GROUP_SPACING
                                content:[
                                 	HBox{
                                 		spacing: COLUMN_SPACING
                                        content: [
                                        	OutputRow{title: TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_THICKNESS).getTitle()
                                            	}.getHeader(),
                                            SwingTextField{
                                             	text: bind thicknessMin with inverse
                                             	editable: true
                                             	disable: false
                                             	columns: 6
                                             	horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             	font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                             },
                                             SwingTextField{
                                             	text: bind thicknessLikely with inverse
                                             	editable: true
                                             	disable: false
                                             	columns: 6
                                             	horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             	font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                             },
                                             SwingTextField{
                                             	text: bind thicknessMax with inverse
                                             	editable: true
                                             	disable: false
                                             	columns: 6
                                             	horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             	font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                             },
                                      	]
                                 	},
                                 	HBox{
                                 		spacing: COLUMN_SPACING
                                 		content: [
                                 			OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.GEOTHERMAL_GRADIENT).getTitle()
                                 				}.getHeader(),
                                 			SwingTextField{
                                 				text: bind geothermGradient with inverse
                                 				editable: true
                                 				disable: false
                                 				columns: 6
                                 				horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                 				font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                 				},
                                 			]
                                 		}
                                       ]
                               }, //HBox
                               
                           // R5
                           HBox{
                               spacing: GROUP_SPACING
                               content:[
                                 HBox{
                                spacing: COLUMN_SPACING
                               content: [
                                               SwingTextField{
                                                text: TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_TOPPRODUCTION).getTitle()
                                                editable: false
                                                disable: true
                                                columns: 20
                                                horizontalAlignment: SwingHorizontalAlignment.LEFT
                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                                },
                                               SwingTextField{
                                                text: bind getMinProdResDepth().toString()
                                                editable: false
                                                disable: true
                                                columns: 6
                                                horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                                },
                                                SwingTextField{
                                                text: bind prodTopReservoirDepthLikely with inverse
                                                editable: true
                                                disable: false
                                                columns: 6
                                                horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                                },
                                                SwingTextField{
                                                text: bind getMaxProdResDepth().toString()
                                                editable: false
                                                disable: true
                                                columns: 6
                                                horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                                },
                                               ]
                                 },
                                 HBox{
                                 	spacing: COLUMN_SPACING
                                 	content: [
                                 		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_TEMPERATURE).getTitle()
                                 			}.getHeader(),
                                 		SwingTextField{
                                 			text: bind tempTop with inverse
                                 			editable: true
                                 			disable: false
                                 			columns: 6
                                 			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                 			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                 			},
                                 		]
                                 	}
                                 ]
                              }, //HBox
    
                                    // R6
                                    HBox{
                                        spacing: GROUP_SPACING
                                        content: [
                                        HBox{
                                           spacing: COLUMN_SPACING
                                           content: [
                                    SwingTextField{
                                     text: TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_TOPINJECTION).getTitle()
                                     editable: false
                                     disable: true
                                     columns: 20
                                     horizontalAlignment: SwingHorizontalAlignment.LEFT
                                     font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                     },
                                    SwingTextField{
                                     text: bind getMinInjResDepth().toString()
                                     editable: false
                                     disable: true
                                     columns: 6
                                     horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                     font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                     },
                                     SwingTextField{
                                     text: bind injectTopReservoirDepthLikely with inverse
                                     editable: true
                                     disable: false
                                     columns: 6
                                     horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                     font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                     },
                                     SwingTextField{
                                     text: bind getMaxInjResDepth().toString()
                                     editable: false
                                     disable: true
                                     columns: 6
                                     horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                     font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                     },
                                    ]
                                           
                                            },
                                        HBox{
                                            	spacing: COLUMN_SPACING
                                            		content: [
	        	                               		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_PRESSURE_PRODUCTION).getTitle()
	        	                               			}.getHeader(),
	        	                               		SwingTextField{
	        	                               			text: bind pressProdTop with inverse
	        	                               			editable: true
	        	                               			disable: false
	        	                               			columns: 6
	        	                               			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	        	                               			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	        	                               			},
	        	                               		]
                                            	}   
                                            ]
                                    },
                                    
                                    // R7
                                     HBox{
        	                               spacing: GROUP_SPACING
        	                               content:[
	        	                               HBox{
	        	                               	spacing: COLUMN_SPACING
	        	                               	content: [
	        	                               		OutputRow{title: TnoStochasticContainerVar.find(TnoMyStochasticObjects.AQUIFER_SALINITY).getTitle()
	        	                               			}.getHeader(),
	        	                               		SwingTextField{
	        	                               			text: bind salinityMin with inverse
	        	                               			editable: true
	        	                               			disable: false
	        	                               			columns: 6
	        	                               			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	        	                               			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	        	                               		 },
	        	                               		 SwingTextField{
	        	                               			text: bind salinityLikely with inverse
	        	                               			editable: true
	        	                               			disable: false
	        	                               			columns: 6
	        	                               			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	        	                               			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	        	                               		 },
	        	                               		 SwingTextField{
	        	                               			text: bind salinityMax with inverse
	        	                               			editable: true
	        	                               			disable: false
	        	                               			columns: 6
	        	                               			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	        	                               			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	        	                               		 },
	        	                               	]
	        	                               },
	        	                               HBox{
	        	                               	spacing: COLUMN_SPACING
                                                        content: [
                                            		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.AQUIFER_PRESSURE_INJECTION).getTitle()
                                            			}.getHeader(),
                                            		SwingTextField{
                                            			text: bind pressInjTop with inverse
                                            			editable: true
                                            			disable: false
                                            			columns: 6
                                            			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                            			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                            			},
                                            		]
	        	                               
	        	                               	}
        	                                  ]      
        							 },
                                    
                                    
                                     SwingLabel {
                                           text: " B) Doublet and pump properties "
                                           font: Font.font("Arial", FontWeight.BOLD, HEAD1  )
                                           foreground: Color.DARKRED
                                     },
                                            OutputRow{
                                                isBold: true
                                                title: "Property"
                                                min: "value"
                                               }.getSmallRow(),
                                        
                                    //R2
                                    HBox{
                                    	spacing: COLUMN_SPACING
                                    	content: [
                                    		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.TEMPERATURE_INJECTION).getTitle()
                                    			}.getHeader(),
                                    		SwingTextField{
                                    			text: bind tempInjectWater with inverse
                                    			editable: true
                                    			disable: false
                                    			columns: 6
                                    			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                    			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                    			},
                                    		]
                                    	},
                                                                                 
                                     //R3
                                     HBox{
                                     	spacing: COLUMN_SPACING
                                     	content: [
                                     		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.WELL_DISTANCE).getTitle()
                                     			}.getHeader(),
                                     		SwingTextField{
                                     			text: bind wellDistance with inverse
                                     			editable: true
                                     			disable: false
                                     			columns: 6
                                     			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                     			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                     			},
                                     		]
                                     	},
                                         
                                      //R4
                                      HBox{
                                      	spacing: COLUMN_SPACING
                                      	content: [
                                      		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_EFFICIENCY).getTitle()
                                      			}.getHeader(),
                                      		SwingTextField{
                                      			text: bind pumpEfficiency with inverse
                                      			editable: true
                                      			disable: false
                                      			columns: 6
                                      			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                      			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                      			},
                                      		]
                                      	},
                                      	                                       
                                      //R5 
                                      HBox{
                                             	spacing: COLUMN_SPACING
                                             	content: [
                                             		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_PRODUCTIONDEPTH).getTitle()
                                             			}.getHeader(),
                                             		SwingTextField{
                                             			text: bind pumpDepth with inverse
                                             			editable: true
                                             			disable: false
                                             			columns: 6
                                             			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                             			},
                                             		]
                                             	},
                                                                            
                                      //R6
                                      HBox{
                                      	spacing: COLUMN_SPACING
                                      	content: [
                                      		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_PRESSUREDIFFERENCE).getTitle()
                                      			}.getHeader(),
                                      		SwingTextField{
                                      			text: bind maxDifference with inverse
                                      			editable: true
                                      			disable: false
                                      			columns: 6
                                      			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                      			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                      			},
                                      		]
                                      	},
                                                                                      
                                     SwingLabel {text: " C) Well properties "
                                                 font: Font.font("Arial", FontWeight.BOLD, HEAD1  )
                                                 foreground: Color.DARKRED
                                                },
                                     HBox{
                                          spacing: COLUMN_SPACING
                                          content: [          
                                     			SwingLabel{ text: TnoSingularContainer.find(TnoMyStochasticObjects.SEGMENT_LENGTH).getTitle()
                                                 			height: 25
                                                 			font: Font.font("Arial", FontWeight.REGULAR, FontPosture.ITALIC, 14)
                                                 			foreground: Color.BLUE
                                                                       
                                     						},
                                     			SwingTextField {columns: columns
                                                     		text: bind segmentlength with inverse
                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                               				}
                                               ]
                                     
                                     }
									//R1
							HBox{
								spacing: GROUP_SPACING
								content: [
             VBox{
										spacing: ROW_SPACING
										content: [

	                                    SwingTextField{
	                                              text: "Producer"
	                                              editable: false
	                                              disable: true
	                                              columns: 27
	                                              horizontalAlignment: SwingHorizontalAlignment.LEFT
	                                              font: Font.font("Arial", FontWeight.BOLD, 12.0);
	                                          },
                                                  HBox{
                                         		spacing: COLUMN_SPACING
                                               		content: [
                                          				OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.PRD_OUTERDIAMETER).getTitle()
                                          					}.getHeader(),
                                          				SwingTextField{
                                                       		text: bind outerDiameterProduct with inverse
                                                       		editable: true
                                                       		disable: false
                                                       		columns: 6
                                                       		horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                       		font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                                       		},
                                          			]
                                             },
	                                    //R4
	                                    HBox{
	                                    	spacing: COLUMN_SPACING
	                                    	content: [
	                                    		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.SKIN_PRODUCTION).getTitle()
	                                    			}.getHeader(),
	                                    		SwingTextField{
	                                    			text: bind skinProduct with inverse
	                                    			editable: true
	                                    			disable: false
	                                    			columns: 6
	                                    			horizontalAlignment: SwingHorizontalAlignment.RIGHT
	                                    			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	                                    			},
	                                    		]
	                                    	}

	                                        HBox{
	                                        	spacing: COLUMN_SPACING
	                                            content: [
	                                            	OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.PRD_AQUIFER_ANGLE).getTitle()
	                                            		}.getHeader(),
	                                            	SwingTextField{
	                                                      text: bind prdAngle with inverse
	                                                      editable: true
	                                                      disable: false
	                                                      columns: 6
	                                                      horizontalAlignment: SwingHorizontalAlignment.RIGHT
	                                                      font: Font.font("Arial", FontWeight.REGULAR, 12.0);
	                                                 },
	                                            ]
	                                          } ,

                                           HBox{
                                               spacing: COLUMN_SPACING
                                               content: [
                                               		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.PRD_ANGLE_SKIN).getTitle()
                                                       }.getHeader(),
                                                 SwingTextField{
                                                  text: bind getSkinProductInc().toString()
                                                  editable: false
                                                  disable: true
                                                  columns: 6
                                                  horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                  font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                                  },
                                                  ]
                                         },
										//R2
										HBox{
	                                        spacing: COLUMN_SPACING
	                                        content: [

	                                        	OutputRow{ title: "Segment"
											        isEditable: false
											        v1:"1"
											        v2:"2"
											        v3:"3"
											        v4:"4"
											        v5:"5"
											        v6:"6"
                                                                                                v7:"7"
                                                                                                v8:"8"
										        }.getWellColumn(),
										        VBox{
							                		spacing: ROW_SPACING
							                		nodeHPos: HPos.RIGHT
							                	    content: [
												        OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getTitle()
												        }.getWellColumnHeader(),
											        	SwingTextField{
											        		 text: bind ps1 with inverse;
											        		 editable: true
											        		 disable: false
											        		 columns: 6
											        		 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
											        	SwingTextField{
											        		 text: bind ps2 with inverse;
											        		 editable: true
											        		 disable: false
											        		 columns: 6
											        		 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
											        	SwingTextField{
											        		 text: bind ps3 with inverse;
											        		 editable: true
											        		 disable: false
											        		 columns: 6
											        		 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
											        	SwingTextField{
											        		 text: bind ps4 with inverse;
											        		 editable: true
											        		 disable: false
											        		 columns: 6
											        		 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
											        	SwingTextField{
											        		text: bind ps5 with inverse;
											        		editable: true
											        		disable: false
											        		columns: 6
											        		horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
											        	SwingTextField{
											        		text: bind ps6 with inverse;
											        		editable: true
											        		disable: false
											        		columns: 6
											        		horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
                                                                                                        											        	SwingTextField{
											        		text: bind ps7 with inverse;
											        		editable: true
											        		disable: false
											        		columns: 6
											        		horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
											        	SwingTextField{
											        		text: bind ps8 with inverse;
											        		editable: true
											        		disable: false
											        		columns: 6
											        		horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
											        	},
											        ]
											     },

										        VBox{
										        	spacing: ROW_SPACING
										        	nodeHPos: HPos.RIGHT
										        	content: [
										        		OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getTitle()
										        		}.getWellColumnHeader(),
										        		SwingTextField{
										        			 text: bind psd1 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind psd2 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind psd3 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind psd4 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind psd5 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind psd6 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind psd7 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind psd8 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        	]
										         },

										        VBox{
										        	spacing: ROW_SPACING
										        	nodeHPos: HPos.RIGHT
										        	content: [
										        		OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getTitle()
										        		}.getWellColumnHeader(),
										        		SwingTextField{
										        			 text: bind pd1 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind pd2 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind pd3 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind pd4 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind pd5 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind pd6 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind pd7 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind pd8 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        	]
										         },
										        VBox{
										        	spacing: ROW_SPACING
										        	nodeHPos: HPos.RIGHT
										        	content: [
										        		OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getTitle()
										        		}.getWellColumnHeader(),
										        		SwingTextField{
										        			 text: bind pr1 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind pr2 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind pr3 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			 text: bind pr4 with inverse;
										        			 editable: true
										        			 disable: false
										        			 columns: 6
										        			 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                 font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind pr5 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind pr6 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
                                                                                                        SwingTextField{
										        			text: bind pr7 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},
										        		SwingTextField{
										        			text: bind pr8 with inverse;
										        			editable: true
										        			disable: false
										        			columns: 6
										        			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                                font: Font.font("Arial", FontWeight.REGULAR, 12.0);
										        		},

										        	]
										         },

										    ]
										    },

	                                    //R3


										]},//vbox	

								VBox{
									spacing: ROW_SPACING
									content: [
									
                                    SwingTextField{
                                              text: "Injector"
                                              editable: false
                                              disable: true
                                              columns: 27
                                              horizontalAlignment: SwingHorizontalAlignment.LEFT
                                              font: Font.font("Arial", FontWeight.BOLD, 12.0);
                                          },
                                          HBox{
                                     		spacing: COLUMN_SPACING
                                           		content: [
                                      				OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.INJ_OUTERDIAMETER).getTitle()
                                      					}.getHeader(),
                                      				SwingTextField{
                                                   		text: bind outerDiameterInject with inverse
                                                   		editable: true
                                                   		disable: false
                                                   		columns: 6
                                                   		horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                   		font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                                   		},
                                      			]
                                     		},

                                    //R4
                                    HBox{
                                    	spacing: COLUMN_SPACING
                                    	content: [
                                    		OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.SKIN_INJECTION).getTitle()
                                    			}.getHeader(),
                                    		SwingTextField{
                                    			text: bind skinInject with inverse
                                    			editable: true
                                    			disable: false
                                    			columns: 6
                                    			horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                    			font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                    			},
                                    		]
                                    	},

                                       HBox{
   	                                        	spacing: COLUMN_SPACING
   	                                            content: [
   	                                            	OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.INJ_AQUIFER_ANGLE).getTitle()
   	                                            		}.getHeader(),
   	                                            	SwingTextField{
   	                                                      text: bind injAngle with inverse
   	                                                      editable: true
   	                                                      disable: false
   	                                                      columns: 6
   	                                                      horizontalAlignment: SwingHorizontalAlignment.RIGHT
   	                                                      font: Font.font("Arial", FontWeight.REGULAR, 12.0);
   	                                                 },
   	                                            ]
   	                                          } ,
                                     HBox{
                                         spacing: COLUMN_SPACING
                                         content: [
                                             OutputRow{title: TnoSingularContainer.find(TnoMyStochasticObjects.INJ_ANGLE_SKIN).getTitle()
                                                  }.getHeader(),
                                             SwingTextField{
                                              text: bind getSkinInjectInc().toString()
                                              editable: false
                                              disable: true
                                              columns: 6
                                              horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                              font: Font.font("Arial", FontWeight.REGULAR, 12.0);
                                              },
                                              ]
                                     },
									//R2
									HBox{
									spacing: COLUMN_SPACING
									content: [
									
										OutputRow{ title: "Segment"
											isEditable: false
											v1:"1"
											v2:"2"									     
											v3:"3"
											v4:"4"
											v5:"5"
											v6:"6"
                                                                                        v7:"7"
											v8:"8"

										}.getWellColumn(),
										VBox{
											spacing: ROW_SPACING  
											nodeHPos: HPos.RIGHT
											content: [										        
												OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getTitle()
												}.getWellColumnHeader(),
												SwingTextField{
													 text: bind is1 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind is2 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind is3 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind is4 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},  
												SwingTextField{
													text: bind is5 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind is6 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},    
                                                                                                SwingTextField{
													text: bind is7 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind is8 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
											]
										 },
													
										VBox{
											spacing: ROW_SPACING  
											nodeHPos: HPos.RIGHT
											content: [										        
												OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getTitle()
												}.getWellColumnHeader(),
												SwingTextField{
													 text: bind isd1 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind isd2 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind isd3 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind isd4 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},  
												SwingTextField{
													text: bind isd5 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind isd6 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},  
												SwingTextField{
													text: bind isd7 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind isd8 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
											]
										 },
										
										VBox{
											spacing: ROW_SPACING  
											nodeHPos: HPos.RIGHT
											content: [										        
												OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getTitle()
												}.getWellColumnHeader(),
												SwingTextField{
													 text: bind id1 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind id2 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind id3 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind id4 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},  
												SwingTextField{
													text: bind id5 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind id6 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												}, 
												SwingTextField{
													text: bind id7 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind id8 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
											]
										 },
										VBox{
											spacing: ROW_SPACING  
											nodeHPos: HPos.RIGHT
											content: [										        
												OutputRow{ title: TnoSingularContainer.find(TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getTitle()
												}.getWellColumnHeader(),
												SwingTextField{
													 text: bind ir1 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind ir2 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind ir3 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													 text: bind ir4 with inverse;
													 editable: true
													 disable: false
													 columns: 6
													 horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                         font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},  
												SwingTextField{
													text: bind ir5 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind ir6 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												}, 
												SwingTextField{
													text: bind ir7 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
												SwingTextField{
													text: bind ir8 with inverse;
													editable: true
													disable: false
													columns: 6
													horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                                                                        font: Font.font("Arial", FontWeight.REGULAR, 12.0);
												},
											]
										 },
																														
									]
									},
																		                                 
                                    //R3
	                                   	
                                    	
									]},//vbox
																
									
									]}, //hbox
                                             
                                    	SwingLabel{
                                    	    text: " [ ] optional"
                                    	    font: Font.font("Arial", FontWeight.REGULAR, 13.0);
                                    	    foreground: Color.DARKGREEN;
                                    	}

                          ]
                        }

               ]
               } // lower group



} // class

