package tno.geoenergy.doubletcalc.io.screen;

/*
 * OutputRow.fx
*
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 * 
 */

import javafx.scene.Group;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.ext.swing.SwingTextField;
import javafx.ext.swing.SwingHorizontalAlignment;
import javafx.scene.text.*;
import javafx.scene.paint.*;
import javafx.scene.shape.*;
import javafx.geometry.HPos;

public class OutputRow {

		protected def ROW_SPACING: Integer = 4;
		protected def COLUMN_SPACING: Integer = 4;
		
        public var titleColumnSize: Integer = 20;
        public var vTitleColumnSize: Integer = 10;
        public var dataColumnSize: Integer = 6;
        public var title: String = "";
        public var min: String = "";
        public var median: String = "";
        public var max: String = "";
        public var isBold: Boolean = false;
        public var isSmall: Boolean = false;
        public var isEditable: Boolean = false;
        public var minmaxEditable: Boolean = true;
        public var spacing: Number = COLUMN_SPACING;
        public var vspacing: Number = ROW_SPACING;

		public var v1: String = "";
		public var v2: String = "";
		public var v3: String = "";
		public var v4: String = "";
		public var v5: String = "";
		public var v6: String = "";
                public var v7: String = "";
		public var v8: String = "";
		//public var vArr = [v1, v2, v3, v4, v5, v6];			

		public var arr = [min, median, max];
        
        public function getWellColumnHeader(): Group{
           var t: Text;
           var header = Group{
        	        		content: [
        	        			Rectangle{
                                                        stroke: Color.DARKGRAY
        	        				fill: Color.rgb(245, 245, 245)
        	        				width: 72
        	        				height:60
        	        				},
        	        			t = Text{
		        	        		content: title;
		                            wrappingWidth: 68
		                            disable: true
		                            textAlignment: TextAlignment.JUSTIFY
		                            font: Font.font("Arial", FontWeight.REGULAR, 12.0)
		                            y:15
		                            x:2
        	        			}
        	        		]
        				}
            return header;
        }
        
        public function getWellColumn(): VBox{
        
        	var weight: FontWeight;
                  
        	if (isBold) weight = FontWeight.BOLD
                else weight = FontWeight.REGULAR;
            var font: Font = Font.font("Arial", weight, 12.0);
            var t: Text;
                
        	var column = VBox{
        		spacing: this.vspacing   
        		nodeHPos: HPos.RIGHT
        	    	content: [
        	        	Group{
        	        		content: [
        	        			Rectangle{
                                                        stroke: Color.DARKGRAY
        	        				fill:Color.rgb(245, 245, 245)
        	        				width: 72
        	        				height:60
        	        				},
        	        			t = Text{
		        	        		content: title;
		                            wrappingWidth: 68
		                            disable: true
		                            textAlignment: TextAlignment.JUSTIFY
		                            font: Font.font("Arial", FontWeight.REGULAR, 12.0)
		                            y:15
		                            x:2
        	        			}
        	        		]
        				},
        	
        				SwingTextField{
        				     text: bind v1 with inverse;
        				     editable: isEditable
        				     disable: not isEditable
        				     columns: dataColumnSize
                                             background: Color.LIGHTGRAY
        				     horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             font:font
        				},
        				SwingTextField{
        				     text: bind v2 with inverse;
        				     editable: isEditable
        				     disable: not isEditable
        				     columns: dataColumnSize
        				     horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             font:font
        				},
        				SwingTextField{
        				     text: bind v3 with inverse;
        				     editable: isEditable
        				     disable: not isEditable
        				     columns: dataColumnSize
        				     horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             font:font
        				},
        				SwingTextField{
        				     text: bind v4 with inverse;
        				     editable: isEditable
        				     disable: not isEditable
        				     columns: dataColumnSize
        				     horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                             font:font
        				},  
        				SwingTextField{
  				        	text: bind v5 with inverse;
  				        	editable: isEditable
  				        	disable: not isEditable
  				        	columns: dataColumnSize
  				        	horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                font:font
  				        },
  				        SwingTextField{
  				        	text: bind v6 with inverse;
  				        	editable: isEditable
  				        	disable: not isEditable
  				        	columns: dataColumnSize
  				        	horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                font:font
  				        },  
                                        SwingTextField{
  				        	text: bind v7 with inverse;
  				        	editable: isEditable
  				        	disable: not isEditable
  				        	columns: dataColumnSize
  				        	horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                font:font
  				        },
  				        SwingTextField{
  				        	text: bind v8 with inverse;
  				        	editable: isEditable
  				        	disable: not isEditable
  				        	columns: dataColumnSize
  				        	horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                font:font
  				        },
                     ]
        	}
           return column;
	}
        
        public function getRow(): HBox{
        
                  var weight: FontWeight;
                  
                  if (isBold) weight = FontWeight.BOLD
                    else weight = FontWeight.REGULAR;
        
                 var font: Font = Font.font("Arial", weight, 12.0);
        
                 var row =  HBox{
                                  spacing: this.spacing
                                             content: [
                                                     SwingTextField{
                                                         text: title;
                                                         editable: false
                                                         disable: true
                                                         columns: titleColumnSize
                                                         horizontalAlignment: SwingHorizontalAlignment.LEFT
                                                         font: font
                                                     },
                                                     SwingTextField{
                                                         text: bind min with inverse
                                                         editable: isEditable
                                                         disable: not isEditable
                                                         columns: dataColumnSize
                                                         horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                          font: font
                                                     },
                                                     SwingTextField{
                                                         text: bind median with inverse
                                                         editable: isEditable
                                                         disable: not isEditable
                                                         columns: dataColumnSize
                                                         horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                          font: font
                                                          visible: not isSmall
                                                     },
                                                     SwingTextField{
                                                         text: bind max with inverse
                                                         editable: isEditable
                                                         disable: not isEditable
                                                         columns: dataColumnSize 
                                                         horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                          font: font
                                                          visible: not isSmall
                                                     }
                                                     ]
                                             }
                 
                 
                 
                             return row;
                }
public function getSmallRow(): HBox{
        
                  var weight: FontWeight;
                  
                  if (isBold) weight = FontWeight.BOLD
                    else weight = FontWeight.REGULAR;
        
                 var font: Font = Font.font("Arial", weight, 12.0);
        
                 var row =  HBox{
                                  spacing: this.spacing
                                             content: [
                                                     SwingTextField{
                                                         text: title;
                                                         editable: false
                                                         disable: true
                                                         columns: titleColumnSize
                                                         horizontalAlignment: SwingHorizontalAlignment.LEFT
                                                         font: font
                                                     },
                                                     SwingTextField{
                                                         text: bind min with inverse
                                                         editable: isEditable
                                                         disable: not isEditable
                                                         columns: dataColumnSize
                                                         horizontalAlignment: SwingHorizontalAlignment.RIGHT
                                                          font: font
                                                     }
                                                     ]
                                             }
                 
                 
                 
                             return row;
                }
        
        public function getHeader(): SwingTextField{
                        
                                  var weight: FontWeight;
                                  
                                  if (isBold) weight = FontWeight.BOLD
                                    else weight = FontWeight.REGULAR;
                        
                                 var font: Font = Font.font("Arial", weight, 12.0);
                        
                                 var header =  SwingTextField{
                                                    text: title;
                                                    editable: false
                                                    disable: true
                                                    columns: titleColumnSize
                                                    horizontalAlignment: SwingHorizontalAlignment.LEFT
                                                    font: font
                                                }
                                  return header;
                                }        
                
                
        public function getEmptyRow(): HBox{
                            var row=   HBox{
                                             spacing: this.spacing
                                                        content: [
                                                                SwingTextField{
                                                                    visible: false
                                                                    columns: titleColumnSize
                                                                },
                                                                SwingTextField{
                                                                    columns: dataColumnSize
                                                                    visible: false
                                                                }
                                                                ]
                                                        }
                            
                                        return row;
                        }

	public function getEmptyDistRow(): HBox{
                                    var row=   HBox{
                                                     spacing: this.spacing
                                                                content: [
                                                                        SwingTextField{
                                                                            visible: false
                                                                            columns: titleColumnSize
                                                                        },
                                                                        SwingTextField{
                                                                            columns: dataColumnSize
                                                                            visible: false
                                                                        },
                                                                        SwingTextField{
                                                                            columns: dataColumnSize
                                                                           	visible: false
                                                                        },
                                                                        SwingTextField{
                                                                           columns: dataColumnSize
                                                                           visible: false
                                                                       	}
                                                                        ]
                                                                }
                                    
                                                return row;
                                }
}
