package tno.geoenergy.doubletcalc.io.screen;

/*
 * Plot.fx
*
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 * 
 */


import java.lang.Math;
import javafx.scene.shape.Line;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.Node;
import javafx.scene.Group;
import javafx.scene.shape.Circle;
import tno.geoenergy.doubletcalc.io.screen.AquiferOutput;
import javafx.scene.Cursor;
import javax.swing.JOptionPane;
import javafx.scene.image.Image;



public class Plot {

    public var x: Number;
    public var y: Number;
    public def width: Number=600.0;
    public def height: Number=350.0;
    public var dataX: Number[]; //array containing x-values
    public var dataY: Number[]; //array containing y-values
    public var maxValue: Number; // highest x-value
    public var minValue: Number;
    public var scriptSize: Integer;
    public var stroke: Number;
    public var xTitle: String;
    public var yTitle: String;
    public var wTitle: String;
    public var shortTitle: String;
    public var performance: Boolean;
    public var flow: Boolean;
    public var minimalPerformance: Number;
    public var desiredPerformance: Number;
    public var p10: Number;
    public var p50: Number;
    public var p90: Number;
    public var maxPumpCapacity: Number;
    public var maxX: Number;
    public var minX: Number;
    public var dimDif: Integer;
    public var intervals: Number; //number of intervals on x-axis


 



public function setBorders(): Void{

// left border


var dif = this.maxValue - this.minValue;

var difdim = getDimension(dif);

var q: Number = this.minValue/Math.pow(10, difdim-1 );

var roundVal: Number = Math.floor(q);

var roundDim: Number = roundVal * Math.pow(10, difdim-1 );

var min: Number;

if ( difdim == 0 and dif >= 5 ) min = floorToFive(roundDim)
    else min = roundDim;

this.minX = min;

// right border

maxX = this.maxValue; // mmaX will be recalculated in function displayXAxis()

}

package function setIntervals():Void{
 var n: Number;
 var z: Integer;
 def dif = this.maxX - this.minX;

 this.dimDif= getDimension(dif);
 n= dif/Math.pow(10, this.dimDif);
if(n >6.5) this.intervals = 1.0;
if(n <= 6.5) this.intervals = 0.5;
if(n <= 3.25) this.intervals = 0.25;
if(n <= 2.4) this.intervals = 0.2;
if(n <= 1.3) this.intervals = 0.1;
}



function displayYAxis(): Node{
     
    var gr: Group;
    var offset: Integer;

    gr=Group{
    content:[
        Line {
            startX: this.x
            startY: this.y
            endX: this.x
            endY: this.y + this.height
            strokeWidth: 1
            stroke: Color.BLACK
        },
        Text {
            font: Font.font("Arial", FontWeight.BOLD, this.scriptSize + 2)
            fill: Color.BROWN
            x: this.x -100
            y: this.y + this.height/2 + this.yTitle.length()
            content: this.yTitle
            rotate: -90
        }
    ]
    } //Group

    for(i in [0..100 step 10]){
       if(i==100) offset=0;
       if(i<=90) offset=7;
       if(i==0) offset=14;
       insert[
        Text {
            font: Font {
                size: this.scriptSize
            }
            x: this.x - 43 + offset
            y: this.y + this.height - (this.height / 100)*i  + 5
            content: "{i}%"
        },
        Line {
            startX: this.x - 7
            startY: this.y + (this.height / 100) * i
            endX: this.x
            endY: this.y + (this.height / 100) * i
            strokeWidth: 1
            stroke: Color.BLACK
        },
        Line {
            startX: this.x
            startY: this.y + (this.height / 100) * i
            endX: this.x + this.width
            endY: this.y + (this.height / 100) * i
            strokeWidth: 0.75
            stroke: Color.GREY
        }
    ] into gr.content;
    } //loop
    return gr;
} // function displayYAxis(): Void{

package function displayXAxis(): Node{
    var gr: Group;
    var ln: Line;
    var offset: Integer;
    def ticks: Integer= (Math.floor((this.maxX-this.minX)/(this.intervals*Math.pow(10, this.dimDif))) as Integer) + 1 ;

    // recalculation of maxX considering the intervals
    maxX = minX + ticks * (this.intervals*Math.pow(10, this.dimDif));
    

    gr=Group{
        content:[
    Line {
        startX: this.x,
        startY: this.y + this.height
        endX:  this.x + this.width
        endY: this.y + this.height
        strokeWidth: 1
        stroke: Color.BLACK
        },
        Text {
            font: Font.font("Arial", FontWeight.BOLD, this.scriptSize + 2)
            fill: Color.BROWN
            x: this.x + this.width/2 - this.xTitle.length()*4
            y: this.y + this.height + 50
            content: this.xTitle
        }
        ]
        }//Group
    for(i in [0..ticks]){
        offset=8+this.dimDif;
        insert [
           Line {
               startX: this.x + (this.width / ticks) * i
               startY: this.y + this.height
               endX: this.x + this.width / ticks * i
               endY: this.y + this.height + 8
               strokeWidth: 1
               stroke: Color.BLACK
           },
           Text {
               font: Font {
                   size: this.scriptSize
               }
               x: this.x + this.width / ticks * i - offset
               y: this.y + this.height + 22
               content: numRound(this.minX + i*this.intervals * Math.pow(10, this.dimDif),2).toString()
           }
       ] into gr.content;
    };//loop

for(i in [1..ticks]){
                insert
               Line {
               startX: this.x + this.width / ticks * i
               startY: this.y
               endX: this.x + this.width / ticks * i
               endY: this.y + this.height
               strokeWidth: 0.75
               stroke: Color.GREY
                } into gr.content
}

  return gr;
}//function displayXAxis()

function getCross(lx: Number, ly: Number, tx: String):Node{
    return Group{
    content: [
        Circle {
            centerX: lx
            centerY: ly
            radius: 6
            fill: Color.RED
        },
        Text {
            font: Font.font("Arial", FontWeight.REGULAR, 12)
            x: lx + 8
            y: ly - 2
            content: tx
        }
       ]
    }
}

function displayCrosses():Node{
    var n10: Number;
    var n50: Number;
    var n90: Number;
    def pixPerUnit: Number = this.width/(this.maxX - this.minX);


     n10 = this.x + (this.p10 - this.minX)* pixPerUnit;
     n50 = this.x + (this.p50 - this.minX)* pixPerUnit;
     n90 = this.x + (this.p90 - this.minX)* pixPerUnit;

     

    return Group{
    content: [
    //p10
    getCross(n10 ,this.y + this.height - 10 * this.height/100, "P10: {numRound(this.p10,2)}"),
    getCross(n50 ,this.y + this.height - 50 * this.height/100, "P50: {numRound(this.p50,2)}"),
    getCross(n90 ,this.y + this.height - 90 * this.height/100, "P90: {numRound(this.p90,2)}")
    ]
    }
}

function displayMinPerformance(): Node{
def pixPerUnit: Number = this.width/(this.maxX - this.minX);

if (this.minimalPerformance >= this.minX and this.minimalPerformance <= this.maxX)
return
    Group{
    visible: this.performance
    content:[
        Line {
            startX: this.x + (this.minimalPerformance - this.minX) / (this.maxX - this.minX) * this.width
            startY: this.y
            endX: this.x + (this.minimalPerformance - this.minX) / (this.maxX - this.minX) * this.width
            endY: this.y + this.height
            strokeWidth: 1.5
            strokeDashArray: [4]
            stroke: Color.RED
        },
        Text {
            font: Font.font("Arial", FontWeight.REGULAR, 13)
            x: this.x + (this.minimalPerformance - this.minX) * pixPerUnit - 11
            y: this.y - 10
            fill: Color.RED
            rotate: 270
            content: "min"
        }
    ]
        } //Group
        else
        return Group{
            visible: this.performance
            content:[
        Text {
            font: Font.font("Arial", FontWeight.BOLD, 13)
            x: this.x
            y: this.y - 35
            fill: Color.RED
            content: "minimum performance out of range"
        }
        ]
        }
}

function displayMaxPumpFlow(): Node{


    def pixPerUnit: Number = this.width/(this.maxX - this.minX);

if (this.maxPumpCapacity >= this.minX and this.maxPumpCapacity <= this.maxX)
return
    Group{
    visible: this.flow
    content:[
        Line {
            startX: this.x + (this.maxPumpCapacity - this.minX) / (this.maxX - this.minX) * this.width
            startY: this.y
            endX: this.x + (this.maxPumpCapacity - this.minX) / (this.maxX - this.minX) * this.width
            endY: this.y + this.height
            strokeWidth: 1.5
            strokeDashArray: [4]
            stroke: Color.GREEN
        },
        Text {
            font: Font.font("Arial", FontWeight.REGULAR, 13)
            x: this.x + (this.maxPumpCapacity - this.minX) * pixPerUnit - 45
            y: this.y - 15
            fill: Color.GREEN
            content: "max. pump capacity"
        }
    ]
        } //Group
        else
        return Group{
            visible: this.flow
            content:[
        Text {
            font: Font.font("Arial", FontWeight.BOLD, 13)
            x: this.x
            y: this.y - 20
            fill: Color.GREEN
            content: "maximum pump capacity out of range"
        }
        ]
        }
}

function displayDesiredPerformance(): Node{
    def pixPerUnit: Number = this.width / (this.maxX - this.minX);

    

    if (this.desiredPerformance >= this.minX and this.desiredPerformance <= this.maxX)
    return
    Group{
    visible: this.performance
    content:[
    Line {
        startX:  this.x + (this.desiredPerformance - this.minX) / (this.maxX - this.minX) *this.width
        startY: this.y
        endX:  this.x + (this.desiredPerformance - this.minX) / (this.maxX - this.minX) *this.width
        endY: this.y + this.height
        strokeWidth: 1.5
        strokeDashArray: [4]
        stroke: Color.RED
    },
    Text {
        font: Font.font("Arial", FontWeight.REGULAR, 12)
        x: this.x + (this.desiredPerformance - this.minX) * pixPerUnit - 21
        y: this.y - 20
        fill: Color.RED
        rotate: 270
        content: "desired"
        }
     ]
     }
        else
        return Group{
            visible: this.performance
            content:[
        Text {
            font: Font.font("Arial", FontWeight.BOLD, 13)
            x: this.x 
            y: this.y - 20
            fill: Color.RED
            content: "desired performance out of range"
        }
        ]
        }
}

function displayFunction():Node{
var gr: Group;
def pixPerUnit: Number = this.width/(this.maxX - this.minX);
def maxIndex = sizeof this.dataX -1;



gr=Group{
    content:[
     for(i in [1..maxIndex]){

         Line {
             startX: this.x + (this.dataX[i  -  1] - this.minX ) * pixPerUnit
             startY: (this.y + this.height) - this.dataY[i - 1] * (this.height / 100)
             endX: this.x + (this.dataX[i] - this.minX ) * pixPerUnit
             endY: (this.y + this.height) - this.dataY[i] * (this.height / 100)
             strokeWidth: this.stroke
             stroke: Color.BLUE
         }
        

},//loop

    ]
}


return gr;
}



package function getGraph(): Group{
    
var graph: Group;
   
this.setBorders();
this.setIntervals();

//AquiferOutput.cursor= Cursor.WAIT;
graph = Group{
    
content:[
    this.displayXAxis(),
    this.displayYAxis(),
    //this.displayMinPerformance(),
    //this.displayDesiredPerformance(),
    //this.displayMaxPumpFlow(),
    this.displayCrosses(),
    this.displayFunction()
    ]
    };

return graph;

};

}//class Plot

public function getDimension(input: Number): Integer{
    var i: Integer=0;
    if(input<1) return 0
    else{
        while(input/Math.pow(10, i) >=10){
        i= i+1;
        }
        return i;
    }//else
}

public function numRound(num: Number, dec: Integer): Number {
    def p:Number= Math.pow(10, dec);
    return Math.round(num*p)/p;
}

public function floorToFive(input: Number): Number{

    var dif = input - Math.floor(input);

    if (dif < 0.5) return Math.floor(input)
    else return Math.floor(input) + 0.5;
}




