package tno.geoenergy.doubletcalc.io.screen;

/*
 * PlotManager.fx
*
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 * 
 */

 import javafx.scene.Group;
 import javafx.ext.swing.SwingComboBox;
 import tno.geoenergy.doubletcalc.io.file.StringToFile;
 import java.io.File;
 import tno.geoenergy.doubletcalc.io.file.FileDialog;

 
public abstract class PlotManager {

    protected var graph: Group;
    public var title: String;
    public var width: Integer;
    public var height: Integer;
    public var xTitle: String;
    public var selectorItems: String[];
    protected var seriesSelector: SwingComboBox ;
    protected var csvScript: String[];


    protected var selectListener: Integer = bind seriesSelector.selectedIndex
        on replace oldValue{
            var selection: String = selectorItems[ seriesSelector.selectedIndex ];
         graph = Group{ content: null };
        setPlot(selection);
    }


    public abstract function getPlotWindow(): Void;

    protected abstract function setPlot(s: String): Void;

    protected abstract function exportCSV(): Void;




    protected function writeToFile(txt: String){

        var fd: FileDialog = FileDialog.getInstance();
           fd.setTitle(txt);
           fd.setExtension(".csv");

           var filename: File = fd.saveDialog();

           var toFile: StringToFile = new StringToFile(filename, this.csvScript);
           if (filename != null) toFile.writeFile();
    }


}

public function removeSeparator(s: String):String{
    var l: Integer = s.length();
    return s.substring(0, l-2);
}

protected def ALL: String = "All curves";

