package tno.geoenergy.doubletcalc.io.screen;

/*
 * StochasticPlotManager.fx
*
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 * 
 */

 import javafx.scene.Group;
 import javafx.stage.Stage;
 import javafx.scene.Scene;
 import javafx.scene.layout.VBox;
 import javafx.scene.layout.HBox;
 import javafx.ext.swing.SwingComboBox;
 import javafx.ext.swing.SwingComboBoxItem;
 import javafx.ext.swing.SwingButton;
 import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerVar;
 import tno.geoenergy.doubletcalc.stochastic.TnoStochasticVariable;
 import tno.geoenergy.doubletcalc.stochastic.TnoMyStochasticObjects;
 import tno.geoenergy.doubletcalc.TnoUnits;
 import javafx.scene.shape.Rectangle;
 import javafx.scene.paint.Color;
 import javafx.scene.image.Image;
 



public class StochasticPlotManager extends PlotManager{

    var probabilities: Number[];
    var numSamples: Integer;


     public override function getPlotWindow(): Void{

         graph = null;
         seriesSelector = null;
         stochWinExec = true;

         stochWin =Stage {
                    title : this.title
                    resizable: false
                    onClose: function() { stochWinExec = false; }
                    icons: [Image{
                                   url: "{__DIR__}TNO.png"}]
                    scene: Scene {
                            width: this.width
                            height: this.height
                            content: [

                                VBox{
                                    spacing: 50
                                    content:[
                                            HBox{
                                                spacing: 10
                                                content:[
                                       seriesSelector = SwingComboBox {
                                                    
                                                    items: [
                                                         for( series in selectorItems){
                                                            SwingComboBoxItem {
                                                                    text: TnoStochasticContainerVar.find(series).getTitle()

                                                            }
                                                            } //loop
                                                            ]
                                                    selectedIndex: 1
                                                        },
                                       
                                                         SwingButton {
                                                          text: "export CSV file"
                                                          action: function() {
                                                          exportCSV();
                                                          }
                                                      }


                                                        ]
                                            },

                                           Group{
                                               translateX: 50
                                               content: bind graph
                                           }


                                            ]
                                }


                            ]
                    }
            }



        } // getPlotWindow


     override function setPlot(s: String): Void{

         var stochast: TnoStochasticVariable = TnoStochasticContainerVar.find(s);
         var perform: Boolean = false;
         if (s.equals( TnoMyStochasticObjects.GEOTHERMAL_POWERS )) perform = true;
         var flowMax: Boolean = false;
         if (s.equals( TnoMyStochasticObjects.PUMP_QVOL )) flowMax = true;
         
         

       var plot = Plot{
       maxValue: stochast.calcMax()
       minValue: stochast.calcMin()
       scriptSize: 13
       stroke: 2
       yTitle: "probability (%)"
       xTitle: stochast.getTitle();
       performance: perform
       flow: flowMax
       p10: stochast.calcPValue(10.0)
       p50: stochast.calcPValue(50.0)
       p90: stochast.calcPValue(90.0)
       }

   delete plot.dataX;
   delete plot.dataY;

   plot.dataX = stochast.getSortedRealisationsAsFloat();
   numSamples = sizeof(plot.dataX);

   delete probabilities;
   for (i in [0..numSamples-1]){
     var yVal = 100*(1- i/((numSamples-1) as Number));
     insert yVal into probabilities;
     }

     plot.dataY = probabilities;

    delete graph.content;
    this.graph = Group{
                    content: [
                        Rectangle {
                            x: 0, y: 0
                            width: this.width, height: this.height
                            fill: Color.WHITE
                            stroke: null
                        },
                        plot.getGraph()
                        ]
                        }
    };


    override function exportCSV(): Void{

        insert "{InputWindow.NORM_TITLE} Probabilistic Results" into csvScript;
        insert "" into csvScript;
        var header: String = "iS, ";
        var probabilisticItems: String[] = [TnoMyStochasticObjects.AQUIFER_PERMEABILITY,
        							TnoMyStochasticObjects.AQUIFER_THICKNESS,
        							TnoMyStochasticObjects.AQUIFER_NG,
        							TnoMyStochasticObjects.AQUIFER_TOPINJECTION,
        							TnoMyStochasticObjects.AQUIFER_TOPPRODUCTION,
        							TnoMyStochasticObjects.AQUIFER_SALINITY,
        							TnoMyStochasticObjects.AQUIFER_KH,
        							TnoMyStochasticObjects.QMASS,
        							TnoMyStochasticObjects.DELTA_T,
        							TnoMyStochasticObjects.HEAT_CAPACITY,
        							TnoMyStochasticObjects.PRODUCT_DENSITY,
        							TnoMyStochasticObjects.PUMP_POWER_REQUIRED        							
        							];
        
        insert selectorItems into probabilisticItems;

        for (item in probabilisticItems){
            header += "{TnoStochasticContainerVar.find(item).getTitle()}, ";
        }
	
        header = removeSeparator(header);
        insert header into csvScript;
            

        for (i in [0..numSamples-1]){

            var row: String = "{i+1}, ";
            var realisation: Number;
            for (item in probabilisticItems){
                if (item == TnoMyStochasticObjects.AQUIFER_PERMEABILITY){
                   realisation = TnoStochasticContainerVar.find(item).getRealisations()[i] * TnoUnits.SI_mDarcy; 
                }else{
                    realisation = TnoStochasticContainerVar.find(item).getRealisations()[i];
                }
                row += ("{realisation}, ");
            }
            row = removeSeparator(row);
            insert row into csvScript;

        }

        writeToFile("Export Probabilistic CSV File");

    };

}// class

package var stochWinExec: Boolean = false;
package var stochWin: Stage;
