package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Van Wees
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import java.util.*;

public abstract class TnoDistributionObject {
	protected Random randomNumber;

	public final static String GAUSSIAN = "Gaussian";
	public final static String TRIANGULAR = "Triangular";
	public final static String UNIFORM = "Uniform";
	public final static String CONSTANT = "Constant";

	public TnoDistributionObject() {
		randomNumber = new Random();
	}

	public TnoDistributionObject(int seed) {
		randomNumber = new Random(seed);
	}

	public void SetSeed(int seed) {
		randomNumber = new Random(seed);
	}

	public boolean isDistributionTimeSeries() {
		return (this instanceof TnoDistributionTimeSeries);
	}

	public void resetRandomObject() {
		randomNumber = null;
	}
}
