package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Van Wees
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import java.util.Random;

public abstract class TnoDistributionVariable extends TnoDistributionObject {

	protected double a; // min
	protected double b; // median
	protected double c; // max
	protected double mean;
	protected boolean isStochastic;

	public double getMin() {
		return a;
	}

	public double getMedian() {
		return b;
	}

	public double getMax() {
		return c;
	}

	public double getMean() {
		return mean;
	}

	public TnoDistributionVariable(double median) {
		this.b = median;
		isStochastic = false;

	}

	public TnoDistributionVariable(double min, double median, double max) {
		setParameters(min, median, max);
		isStochastic = true;
		randomNumber = new Random();
	}

	public TnoDistributionVariable(double min, double median, double max,
			int seed) {
		setParameters(min, median, max);
		randomNumber = new Random(seed);
	}

	public abstract void setParameters(double min, double median, double max);

	public abstract double PDF(double x);

	public abstract double CDF(double x);

	public abstract double NextValue();

	public abstract double[] generateSamples(int numSamples);

}
