package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Van Wees
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import tno.geoenergy.doubletcalc.TnoUnits;

public class TnoMyStochasticObjects {

	// property group code
	final static int BASRES_TYPE = 0;
	final static int SF_TYPE = 1;
	final static int ECONOMICS_TYPE = 2;
	final static int KPIOUTPUT_TYPE = 3;
	
	//General input
	public final static String SIMULATION_RUNS = "number of simulation runs";
	
	//Geotechnical input - Aquifer properties
	public final static String AQUIFER_PERMEABILITY = "aquifer permeability";
	public final static String AQUIFER_NG = "aquifer net to gross";
	public final static String AQUIFER_THICKNESS = "aquifer gross thickness";
	public final static String AQUIFER_TOPINJECTION = "aquifer top at injector";
	public final static String AQUIFER_TOPPRODUCTION = "aquifer top at producer";
	public final static String AQUIFER_SALINITY = "aquifer water salinity";
	
	public final static String KH_KV = "aquifer kh/kv ratio";
	public final static String TEMPERATURE_SURFACE = "surface temperature";
	public final static String GEOTHERMAL_GRADIENT = "geothermal gradient";
	public final static String AQUIFER_TEMPERATURE = "mid aquifer temperature producer";
	public final static String AQUIFER_PRESSURE_INJECTION = "initial aquifer pressure at injector";
	public final static String AQUIFER_PRESSURE_PRODUCTION = "inital aquifer pressure at producer";
	
	//Geotechnical input - Doublet & Pump properties
	public final static String TEMPERATURE_INJECTION = "exit temperature heat exchanger";
	public final static String WELL_DISTANCE = "distance wells at aquifer level";
	public final static String PUMP_EFFICIENCY = "pump system efficiency";
	public final static String PUMP_PRODUCTIONDEPTH = "production pump depth";
	public final static String PUMP_PRESSUREDIFFERENCE = "pump pressure difference";
	
	//Geotechnical input - Well properties
	public final static String SEGMENT_LENGTH = "calculation length subdivision";
	
	public final static String INJ_TUBING_SEGMENTS_AH = "pipe segment sections i";
	public final static String INJ_TUBING_SEGMENTS_TVD = "pipe segment depth i";
	public final static String INJ_TUBING_DIAMETER = "pipe inner diameter i ";
	public final static String INJ_TUBING_ROUGHNESS = "pipe roughness i";
	
	public final static String INJ_OUTERDIAMETER = "outer diameter injector";
	public final static String SKIN_INJECTION = "skin injector";
        public final static String TOTAL_SKIN_INJECTION = "total skin injector";
	public final static String INJ_AQUIFER_ANGLE = "penetration angle injector";
	public final static String INJ_ANGLE_SKIN = "skin due to penetration angle i";
	
	public final static String PRD_TUBING_SEGMENTS_AH = "pipe segment sections p";
	public final static String PRD_TUBING_SEGMENTS_TVD = "pipe segment depth p";
	public final static String PRD_TUBING_DIAMETER = "pipe inner diameter p";
	public final static String PRD_TUBING_ROUGHNESS = "pipe roughness p";
	
	public final static String PRD_OUTERDIAMETER = "outer diameter producer";
	public final static String SKIN_PRODUCTION = "skin producer";
        public final static String TOTAL_SKIN_PRODUCTION = "total skin producer";
	public final static String PRD_AQUIFER_ANGLE = "penetration angle producer";
	public final static String PRD_ANGLE_SKIN = "skin due to penetration angle p";
	

	//Geotechnical output - stochastics
	public final static String AQUIFER_KH = "aquifer kH net";
	public final static String QMASS = "mass flow";
	public final static String PUMP_QVOL = "pump volume flow";
	public final static String PUMP_POWER_REQUIRED = "required pump power";
	public final static String GEOTHERMAL_POWERS = "geothermal power";
	public final static String COP = "COP";
	
	public final static String PRODUCT_DENSITY = "av. production density";
	public final static String HEAT_CAPACITY = "heat capacity";
	public final static String DELTA_T = "delta T";

        public final static String AQP_PRD = "aquifer pressure at producer";
        public final static String AQP_INJ = "aquifer pressure at injector";
        public final static String DP_PRD = "pressure difference at producer";
        public final static String DP_INJ = "pressure difference at injector";
        public final static String AQT_PRD = "aquifer temperature at producer *";
        public final static String T_HE = "temperature at heat exchanger";
         public final static String P_HE = "pressure at heat exchanger";
	
	//Geotechnical output - stochastics (basecase)
	public final static String BASECASE_AQUIFER_KH = "aquifer kH net";
	public final static String BASECASE_QMASS = "mass flow";
	public final static String BASECASE_PUMP_QVOL = "pump volume flow";
	public final static String BASECASE_PUMP_POWER_REQUIRED = "required pump power";
	public final static String BASECASE_GEOTHERMAL_POWERS = "geothermal power";
	public final static String BASECASE_COP = "COP";

        public final static String BASECASE_AQP_PRD = "aquifer pressure at producer";
        public final static String BASECASE_AQP_INJ = "aquifer pressure at injector";
        public final static String BASECASE_DP_PRD = "pressure difference at producer";
        public final static String BASECASE_DP_INJ = "pressure difference at injector";
        public final static String BASECASE_AQT_PRD = "aquifer temperature at producer *";
        public final static String BASECASE_T_HE = "temperature at heat exchanger";
        public final static String BASECASE_P_HE = "pressure at heat exchanger";
    
	public static void initialize() {
		
		TnoStochasticVariable var = null;

		var = new TnoStochasticVariable(AQUIFER_THICKNESS, "m", BASRES_TYPE);
		var.setDistribution(new TnoDistributionVarTriangular(50, 70, 90));

		var = new TnoStochasticVariable(AQUIFER_PERMEABILITY, "mD",
				BASRES_TYPE, TnoUnits.SI_mDarcy, 0);
		var.setDistribution(new TnoDistributionVarTriangular(350, 500, 650));

		var = new TnoStochasticVariable(AQUIFER_NG, "-", BASRES_TYPE, 1, 2);
		var.setDistribution(new TnoDistributionVarTriangular(0.99, 1, 1.01));

		var = new TnoStochasticVariable(AQUIFER_TOPINJECTION, "m TVD", BASRES_TYPE);
		var.setDistribution(new TnoDistributionVarTriangular(1350, 1500, 1650));

		var = new TnoStochasticVariable(AQUIFER_TOPPRODUCTION, "m TVD", BASRES_TYPE);
		var.setDistribution(new TnoDistributionVarTriangular(1350, 1500, 1650));

		new TnoStochasticVariable(AQUIFER_KH, "Dm", KPIOUTPUT_TYPE, 1, 2);
		new TnoStochasticVariable(PRODUCT_DENSITY, "kg/m", KPIOUTPUT_TYPE, 1, 3);
		new TnoStochasticVariable(HEAT_CAPACITY, "kJ/(kg*K)", KPIOUTPUT_TYPE, 1, 3);
		new TnoStochasticVariable(QMASS, "kg/s", KPIOUTPUT_TYPE, 1, 2);
		new TnoStochasticVariable(PUMP_QVOL, "m/h", KPIOUTPUT_TYPE, 1, 1);
		new TnoStochasticVariable(DELTA_T, "C", KPIOUTPUT_TYPE, 1, 1);
		new TnoStochasticVariable(PUMP_POWER_REQUIRED, "kW", KPIOUTPUT_TYPE, 1, 1);
		new TnoStochasticVariable(GEOTHERMAL_POWERS, "MW", KPIOUTPUT_TYPE, 1, 2);
		new TnoStochasticVariable(COP, "kW/kW", KPIOUTPUT_TYPE, 1, 1);

                new TnoStochasticVariable(AQP_PRD, "bar", KPIOUTPUT_TYPE, TnoUnits.SI_Bar, 2);
                new TnoStochasticVariable(AQP_INJ, "bar", KPIOUTPUT_TYPE, TnoUnits.SI_Bar, 2);
                new TnoStochasticVariable(DP_PRD, "bar", KPIOUTPUT_TYPE, TnoUnits.SI_Bar, 2);
                new TnoStochasticVariable(DP_INJ, "bar", KPIOUTPUT_TYPE, TnoUnits.SI_Bar, 2);
                new TnoStochasticVariable(AQT_PRD, "C", KPIOUTPUT_TYPE, 1, 2);
                new TnoStochasticVariable(T_HE, "C", KPIOUTPUT_TYPE, 1, 2);
                new TnoStochasticVariable(P_HE, "bar", KPIOUTPUT_TYPE, TnoUnits.SI_Bar, 2);


		var = new TnoStochasticVariable(AQUIFER_SALINITY, "ppm", BASRES_TYPE, 1e6, 0);
		var.setDistribution(new TnoDistributionVarTriangular(69000, 70000, 71000));
		
		new TnoSingularVariable(AQUIFER_TEMPERATURE, "C", 0, true);
		new TnoSingularVariable(AQUIFER_PRESSURE_INJECTION, "bar", 0,
				TnoUnits.SI_Bar, 1, true);
		new TnoSingularVariable(AQUIFER_PRESSURE_PRODUCTION, "bar", 0,
				TnoUnits.SI_Bar, 1, true);
		new TnoSingularVariable(SKIN_PRODUCTION, "-", 2.0, 1, 2);
		new TnoSingularVariable(SKIN_INJECTION, "-", 0.5, 1, 2);
                new TnoSingularVariable(TOTAL_SKIN_PRODUCTION, "-", 0, 1, 2);
		new TnoSingularVariable(TOTAL_SKIN_INJECTION, "-", 0, 1, 2);
		new TnoSingularVariable(INJ_OUTERDIAMETER, "inch", 8.0,
				TnoUnits.SI_Inch, 2);
		new TnoSingularVariable(PRD_OUTERDIAMETER, "inch", 8.0,
				TnoUnits.SI_Inch, 2);
		new TnoSingularVariable(WELL_DISTANCE, "m", 1700);
		
		double[] depth_p = {1500};
		new TnoSingularVariable(PRD_TUBING_SEGMENTS_TVD, "m TVD", depth_p);
		double[] depth_i = {1500};
		new TnoSingularVariable(INJ_TUBING_SEGMENTS_TVD, "m TVD", depth_i);
		
		double[] rough = {1.38};
		new TnoSingularVariable(INJ_TUBING_ROUGHNESS, "milli-inch", rough,
				TnoUnits.SI_Inch * 1e3, 2);
		new TnoSingularVariable(PRD_TUBING_ROUGHNESS, "milli-inch", rough,
				TnoUnits.SI_Inch * 1e3, 2);
		double[] diam = {7};
		new TnoSingularVariable(INJ_TUBING_DIAMETER, "inch", diam, TnoUnits.SI_Inch, 2);
		new TnoSingularVariable(PRD_TUBING_DIAMETER, "inch", diam, TnoUnits.SI_Inch, 2);
		double[] segi = {2018};
		double[] segp = {2121};
		new TnoSingularVariable(INJ_TUBING_SEGMENTS_AH, "m AH", segi);
		new TnoSingularVariable(PRD_TUBING_SEGMENTS_AH, "m AH", segp);
		
		new TnoSingularVariable(TEMPERATURE_SURFACE, "C", 10.0, 1, 1);
		new TnoSingularVariable(TEMPERATURE_INJECTION, "C", 30.0, 1, 1);
		new TnoSingularVariable(GEOTHERMAL_GRADIENT, "C/m", 0.031, 1, 4);
		new TnoSingularVariable(PUMP_EFFICIENCY, "-", 0.60, 1, 3);
		new TnoSingularVariable(PUMP_PRODUCTIONDEPTH, "m", 300);
		new TnoSingularVariable(PUMP_PRESSUREDIFFERENCE, "bar", 30.0,
				TnoUnits.SI_Bar, 2);
		new TnoSingularVariable(SIMULATION_RUNS, "-", 1000);
		new TnoSingularVariable(SEGMENT_LENGTH, "m", 50);

		new TnoSingularVariable(BASECASE_AQUIFER_KH, "Dm", 0, 1, 2);
		new TnoSingularVariable(BASECASE_QMASS, "kg/s", 0, 1, 2);
		new TnoSingularVariable(BASECASE_PUMP_QVOL, "m/h", 0, 1, 1);
		new TnoSingularVariable(BASECASE_PUMP_POWER_REQUIRED, "kW", 0, 1, 1);
		new TnoSingularVariable(BASECASE_GEOTHERMAL_POWERS, "MW", 0, 1, 2);
		new TnoSingularVariable(BASECASE_COP, "kW/kW", 0, 1, 1);
		
		new TnoSingularVariable(KH_KV, "-", 1);
		new TnoSingularVariable(INJ_AQUIFER_ANGLE, "deg", 0);
		new TnoSingularVariable(PRD_AQUIFER_ANGLE, "deg", 0);
		new TnoSingularVariable(INJ_ANGLE_SKIN, "-", 0, 1, 2);
		new TnoSingularVariable(PRD_ANGLE_SKIN, "-", 0, 1, 2);
                
                new TnoSingularVariable(BASECASE_AQP_PRD, "bar", 0, TnoUnits.SI_Bar, 2);
                new TnoSingularVariable(BASECASE_AQP_INJ, "bar", 0, TnoUnits.SI_Bar, 2);
                new TnoSingularVariable(BASECASE_DP_PRD, "bar", 0, TnoUnits.SI_Bar, 2);
                new TnoSingularVariable(BASECASE_DP_INJ, "bar", 0, TnoUnits.SI_Bar, 2);
                new TnoSingularVariable(BASECASE_AQT_PRD, "C", 0, 1, 2);
                new TnoSingularVariable(BASECASE_T_HE, "C", 0, 1, 2);
                new TnoSingularVariable(BASECASE_P_HE, "bar", 0, TnoUnits.SI_Bar, 2);

				
	}

}
