package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Kronimus
 * 
 * 
 *         (c) 2009 TNO
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html         
 * 
 */

public class TnoSingularVariable extends TnoStochasticObject {

	private double value;
	private double[] arrayvalue;
	private boolean optional;

	public TnoSingularVariable(String name, String unit, double value) {
		this.name = name;
		this.units = unit;
		this.value = value;
		TnoSingularContainer.singularVariables.add(this);
	}

	public TnoSingularVariable(String name, String unit, double value,
			double unitFactor, int round) {
		this.name = name;
		this.units = unit;
		this.value = value;
		this.unitFactor = unitFactor;
		this.round = round;
		TnoSingularContainer.singularVariables.add(this);
	}

	public TnoSingularVariable(String name, String unit, double value,
			double unitFactor, int round, boolean optional) {
		this.name = name;
		this.units = unit;
		this.value = value;
		this.unitFactor = unitFactor;
		this.round = round;
		this.optional = optional;
		TnoSingularContainer.singularVariables.add(this);
	}

	public TnoSingularVariable(String name, String unit, double value,
			boolean optional) {
		this.name = name;
		this.units = unit;
		this.value = value;
		this.optional = optional;
		TnoSingularContainer.singularVariables.add(this);
	}

	public TnoSingularVariable(String name, String unit, double[] value) {
		this.name = name;
		this.units = unit;
		this.arrayvalue = value;
		TnoSingularContainer.singularVariables.add(this);
	}
	
	public TnoSingularVariable(String name, String unit, double[] value,
			double unitFactor, int round) {
		this.name = name;
		this.units = unit;
		this.arrayvalue = value;
		this.unitFactor = unitFactor;
		this.round = round;
		TnoSingularContainer.singularVariables.add(this);
	}

	public TnoSingularVariable(String name, String unit, double[] value,
			double unitFactor, int round, boolean optional) {
		this.name = name;
		this.units = unit;
		this.arrayvalue = value;
		this.unitFactor = unitFactor;
		this.round = round;
		this.optional = optional;
		TnoSingularContainer.singularVariables.add(this);
	}
	
	public String getName() {
		return name;
	}

	public String getUnit() {
		return units;
	}

	public double getValue() {
		return value;
	}
	
	public String getStrValue(int i) {
		if (i < arrayvalue.length){
			return Double.toString(arrayvalue[i]);
		}else{
			return "";
		}
	}
	
	public int getSize(){
		return arrayvalue.length;
	}

	public double[] getArray(){
		return arrayvalue;
	}
	
	public final double getValueForm() {

		return format(value);

	}
	
	public final String getStrValueForm() {
		try {
			double[] arr = format(arrayvalue);
			String res = "";
			for (int i=0; i<arr.length; i++){
				res += arr[i];
				if (i != arr.length-1){
					res += ",";
				}
			}
			return res;
		}catch(Exception e ){
			return Double.toString(format(value));
		}
	}

	public String getTitle() {
		String s = name + " " + "(" + units + ")";
		if (!optional)
			return s;
		else
			return "[ " + s + " ]";
	}

	public void setValue(double value) {
		this.value = value;
	}
	
	public void setArray(double[] value) {
		this.arrayvalue = value;
	}
	
	public void setName(String name){
		this.name = name;
	}

}
