package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Van Wees
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html 
 * 
 */

import java.util.ArrayList;

public class TnoStochasticContainerTS {

	private static ArrayList<TnoStochasticTimeSeries> stochObjects = new ArrayList<TnoStochasticTimeSeries>();

	public static ArrayList<TnoStochasticTimeSeries> getStochObjects() {
		return stochObjects;
	}

	/**
	 * 
	 * clears the container
	 * 
	 */
	public static void clearAll() {
		TnoStochasticContainerTS.getStochObjects().clear();
	}

	/*
	 * 
	 * initializes all stochasticObjects to the requested number of samples for
	 * the inputs it will automatically generate samples distributions
	 */
	public static void initializeRunAllStochastics(int numSamples, int numYears) {

		for (int i = 0; i < stochObjects.size(); i++) {
			TnoStochasticTimeSeries var = stochObjects.get(i);
			var.setNumSamples(numSamples);
			var.setNumYears(numYears);
			var.buildRealisations();
		}

	}

	public static TnoStochasticTimeSeries find(String name) {
		for (int i = 0; i < stochObjects.size(); i++) {
			TnoStochasticTimeSeries var = stochObjects.get(i);
			if (var.name.equalsIgnoreCase(name))
				return var;
		}
		System.out.println("Cannot find time series: " + name);

		return null;
	}

}
