package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Van Wees
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import java.util.ArrayList;

public class TnoStochasticContainerVar {

	private static ArrayList<TnoStochasticVariable> stochObjects = new ArrayList<TnoStochasticVariable>();

	public static ArrayList<TnoStochasticVariable> getStochObjects() {
		return stochObjects;
	}

	/**
	 * 
	 * clears the container
	 * 
	 */
	public static void clearAll() {
		TnoStochasticContainerVar.getStochObjects().clear();
	}

	/*
	 * 
	 * initializes all stochasticObjects to the requested number of samples for
	 * the inputs it will automatically generate samples distributions
	 */

	public static void initializeRunAllStochastics(int numSamples) {
		for (int i = 0; i < stochObjects.size(); i++) {
			TnoStochasticVariable var = stochObjects.get(i);
			var.numSamples = numSamples;
			var.buildRealisations();
		}

	}

	public static TnoStochasticVariable find(String name) {
		for (int i = 0; i < stochObjects.size(); i++) {
			TnoStochasticVariable var = stochObjects.get(i);
			if (var.name.equalsIgnoreCase(name))
				return var;
		}

		System.out.println("Cannot find stochastic: " + name);

		return null;
	}

}
