package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Van Wees
 * 
 * 
 *         (c) 2009 TNO
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html         
 * 
 */

public abstract class TnoStochasticObject {

	protected String name = "none";
	protected String units = "-";
	protected int idtype = 0;
	protected int round = 0;
	protected double unitFactor = 1.00000;

	public String getUnits() {
		return units;
	}

	public int getRound() {
		return round;
	}

	public double getUnitFactor() {
		return unitFactor;
	}

	/**
	 * This constructor will not add the object to the global list
	 */
	public TnoStochasticObject() {
	}

	/**
	 * constructs a stochastic object
	 */
	public TnoStochasticObject(String name, String units, int idType) {
		this.name = name;
		this.units = units;
		this.idtype = idType;
		if (this.isStochasticTimeSeries()) {
			TnoStochasticContainerTS.getStochObjects().add(
					(TnoStochasticTimeSeries) this);
		} else {
			TnoStochasticContainerVar.getStochObjects().add(
					(TnoStochasticVariable) this);
		}
	}

	public void setUnits(String units) {
		this.units = units;
	}

	public int getIdtype() {
		return idtype;
	}

	public void setIdtype(int idtype) {
		this.idtype = idtype;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public String getTitle() {
		return name + " " + "(" + units + ")";
	}

	public boolean isStochasticTimeSeries() {
		return (this instanceof TnoStochasticTimeSeries);
	}

	public boolean isInput() {
		if (this instanceof TnoStochasticTimeSeries) {
			return (((TnoStochasticTimeSeries) this).getDistribution() != null);
		} else {
			return (((TnoStochasticVariable) this).getDistribution() != null);
		}
	}

	public static double numRound(double num, int dec) {

		double p = Math.pow(10, dec);
		return Math.round(num * p) / p;
	}

	protected double format(double value) {
		value *= this.unitFactor;
		return numRound(value, this.round);

	}
	protected double[] format(double[] value) {
		double[] formValues = new double[value.length];
		for (int i=0; i< value.length; i++ )
			formValues[i]= numRound(value[i] * this.unitFactor , this.round);
		return formValues;

	}

}
