package tno.geoenergy.doubletcalc.stochastic;

/**
 * @author Van Wees
 * 
 *         (c) 2009 TNO-NITG
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html        
 * 
 *         This abstract class is used as a base class for time series with a
 *         distribution.
 */

public class TnoStochasticTimeSeries extends TnoStochasticObject {
	protected double realisations[][];
	public TnoDistributionTimeSeries distribution;
	private int numSamples = 0;
	private int numYears = 0;

	public TnoStochasticTimeSeries(String name, String units, int idType) {
		super(name, units, idType);
		numSamples = TnoRunControl.numSamples;
		numYears = TnoRunControl.numYears;
		distribution = null;
	}

	public TnoDistributionTimeSeries getDistribution() {
		return distribution;
	}

	public void setDistribution(TnoDistributionTimeSeries distribution) {
		this.distribution = distribution;
	}

	public void buildRealisations() {
		if (distribution != null) {
			distribution.generateSamples(numSamples, numYears);
		} else {
			this.createEmptyRealisations();
		}
	}

	/**
	 * 
	 * @param i
	 * @return
	 * 
	 *         returns a 1 dimensional lifetime array which can be filled for a
	 *         doublet case
	 * 
	 */

	public double[] getRealisationHandle(int i) {
		if (realisations != null) {
			return (realisations[i]);
		} else {
			System.out.println("no realisations");
			return null;
		}
	}

	public double[] calcPValue(double chance) {
		double[] dist = new double[realisations[0].length];

		for (int year = 0; year < realisations[0].length; year++) {
			double[] timeSlice = new double[realisations.length];

			for (int r = 0; r < realisations.length; r++) {
				timeSlice[r] = realisations[r][year];
			}

			TnoStochasticVariable stochVar = new TnoStochasticVariable(
					timeSlice);

			dist[year] = stochVar.calcPValue(chance);
		}

		return dist;
	}

	/**
	 * Creates realisations with given sample count.
	 * 
	 * @param int sampe count
	 */

	public void createEmptyRealisations() {

		realisations = new double[numSamples][numYears];

	}

	public void disposeRealisations() {
		realisations = null;
	}

	/**
	 * Returns realisation at given index.
	 * 
	 * @return double[] realisation
	 * @param int index
	 */

	public double[] getRealisationAt(int index) {
		return realisations[index];
	}

	/**
	 * Returns an array of realisations.
	 * 
	 * @return double[][] array of realisations
	 */

	public double[][] getRealisations() {
		return realisations;
	}

	public boolean isStochasticTimeSeries() {
		return true;
	}

	/**
	 * Returns the number of realisations.
	 * 
	 * @return int
	 */
	public int size() {
		if (realisations == null) {
			return 0;
		} else {
			return numSamples;
		}
	}

	public int getNumYears() {
		return numYears;
	}

	public void initialiseTimeSeries(int samples, int lifetime) {
		this.setNumSamples(samples);
		this.setNumYears(lifetime);
		this.buildRealisations();
	}

	/**
	 * @param numSamples
	 *            the numSamples to set
	 */
	public void setNumSamples(int numSamples) {
		this.numSamples = numSamples;
	}

	public int getNumSamples() {
		return this.numSamples;
	}

	/**
	 * @param numYears
	 *            the numYears to set
	 */
	public void setNumYears(int numYears) {
		this.numYears = numYears;
	}

}
