#! /usr/bin/gawk -f
# conversion ZMAP grid to ESRI ASCIIgrid
BEGIN {
  FS=","
  # fixed number of cells per line to increase readibility... not really necessary so don't use it
  npix_line = 100
}
{
  # read header ZMAPgrid
  # nodata value in first header line
  while (substr($0,1,1)!="@") getline
  getline
  # first header line contains field width, NDV, [empty], magic number 1, magic number 2 (usually 1?)
  width = 1 * $1
  ndv = 1 * $2
  ndv_out = ndv
  nn[1] = $4
  nn[2] = $4
  getline

  # second header line - get rid of spaces in a nice way
  # contains ny, nx, xmin, xmax, ymin, ymax
  for (i=1;i<=2;++i) gsub(" ","",$i)
  nrows = 1 * $1
  ncols = 1 * $2
  for (i=1;i<=6;++i) gsub(" ","",$i)
  xmin = $3
  xmax = $4
  ymin = $5
  ymax = $6

  # cell sizes from minx/maxx miny/maxy
  cellsize_x = (xmax-xmin)/(ncols-1)
  cellsize_y = (ymax-ymin)/(nrows-1)
  if ( cellsize_x != cellsize_y ) {
    print "**************" >"/dev/tty"
    print "****** pixel size in X (" cellsize_x ") and Y (" cellsize_y ") directions different ********" >"/dev/tty"
    print "**************" >"/dev/tty"
    cellsize = ( cellsize_x + cellsize_y ) / 2
  }
  else cellsize = cellsize_x
  getline

  # 3rd header line contains cell sizes
  # $1=??
  cellsize = $2
  if ($2 != $3) {
    print "**************" >"/dev/tty"
    print "****** pixel size in X (" $2 ") and Y (" $3 ") directions different ********" >"/dev/tty"
    print "**************" >"/dev/tty"
  }

  print "xllcenter, yllcenter:",xmin,ymin >"/dev/tty"
  print "ncols, nrows:",ncols,nrows >"/dev/tty"
  print "cellsize:",cellsize >"/dev/tty"

  outfile = getname(FILENAME)".asc"

  while ( substr($0,1,1)!="@" ) getline 
  col = 1

  FS=" "


  # read cell values
  while ( getline != 0 ) {
    # use fixed width
    #if ( 1 * width > 0 ) {
    #  for (i=1;i<=(length($0)-1)/width;++i) {
    #    val[col,++row] = 1 * substr($0,(i-1)*width+1,width)
    #    if ( val[col,row]==ndv ) val[col,row] = ndv_out
    #  }
    #}
    #else {
      for (i=1;i<=NF;++i) {
        val[col,++row] = 1 * $i
        if ( $i==ndv ) val[col,row] = ndv_out
      }
    #}
    if (row>=nrows) {
      ++col
      row=0
    }
  }
}
END {
  print "finished reading ZMAPgrid" >"/dev/tty"
  print "output to",outfile >"/dev/tty"
  print "start writing" >"/dev/tty"

  print "ncols        ",ncols > outfile
  print "nrows        ",nrows > outfile
  print "xllcenter    ",xmin > outfile
  print "yllcenter    ",ymin > outfile
  print "cellsize     ",cellsize > outfile
  print "NODATA_value ",ndv_out > outfile

  for (i=1;i<=nrows;++i) {
    for (j=1;j<=ncols;++j) {
      printf "%s ", val[j,i] > outfile
    }
    printf "\n" >outfile
  }
}
function getname(name) {
  # remove directory path
  while ( index(name,"/") != 0 ) {
    name = substr(name,index(name,"/")+1)
  }
  # remove filename extension
  if ( index(name,".") != 0 ) {
    name = substr(name,1,index(name,".")-1)
  }
  return(name)
}
