/*
 * Decompiled with CFR 0.152.
 */
package com.sun.embeddedswing;

import com.sun.embeddedswing.EmbeddedGraphics;
import com.sun.embeddedswing.EmbeddedToolkit;
import com.sun.embeddedswing.SwingGlueLayer;
import com.sun.scenario.utils.Utils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedPeer {
    private static final BasicStroke defaultStroke = new BasicStroke(1.0f);
    private static final RenderingHints defaultHints = new RenderingHints(null);
    private static final boolean havePrinterGraphics;
    private final Component component;
    private JComponent parent;
    private final Shell shell;
    private final JPanel container;
    private Dimension size;

    protected EmbeddedPeer(JComponent jComponent, Component component) {
        this.component = component;
        this.parent = jComponent;
        this.shell = new Shell();
        this.shell.add(this.component, "Center");
        this.container = new ShellContainer();
        this.container.add(this.shell);
        if (jComponent != null) {
            jComponent.add(this.container);
        }
    }

    private static void resetDoubleBuffering(Component component, Map<JComponent, Boolean> map, boolean bl) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            if (bl) {
                Boolean bl2 = map.get(container);
                if (bl2 != null) {
                    ((JComponent)container).setDoubleBuffered(bl2);
                }
            } else {
                map.put((JComponent)container, ((JComponent)container).isDoubleBuffered());
                ((JComponent)container).setDoubleBuffered(false);
            }
        }
        if (component instanceof Container) {
            container = (Container)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                EmbeddedPeer.resetDoubleBuffering(container.getComponent(i), map, bl);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.component != null) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setStroke(defaultStroke);
            graphics2D2.setRenderingHints(defaultHints);
            AffineTransform affineTransform = graphics2D2.getTransform();
            if (affineTransform.getType() == 1) {
                double d = Math.round(affineTransform.getTranslateX());
                double d2 = Math.round(affineTransform.getTranslateY());
                affineTransform.setToTranslation(d, d2);
                graphics2D2.setTransform(affineTransform);
            }
            if (havePrinterGraphics && (affineTransform.getScaleX() != 1.0 || affineTransform.getScaleY() != 1.0 || affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0)) {
                graphics2D2 = EmbeddedGraphicsFactory.createGraphics(graphics2D2);
            }
            HashMap<JComponent, Boolean> hashMap = new HashMap<JComponent, Boolean>();
            EmbeddedPeer.resetDoubleBuffering(this.shell, hashMap, false);
            this.shell.paint(graphics2D2);
            EmbeddedPeer.resetDoubleBuffering(this.shell, hashMap, true);
            graphics2D2.dispose();
        }
    }

    public final JComponent getParentComponent() {
        return this.parent;
    }

    public final void setParentComponent(JComponent jComponent) {
        if (this.parent == jComponent) {
            return;
        }
        if (this.parent != null) {
            this.parent.remove(this.getContainer());
        }
        this.parent = jComponent;
        if (this.parent != null) {
            this.parent.add(this.getContainer());
            this.getEmbeddedToolkit().registerEmbeddedToolkit(this.parent);
        }
    }

    public final Component getEmbeddedComponent() {
        return this.component;
    }

    public final void validate() {
        this.getShell().validate();
    }

    public final void dispose() {
        this.setParentComponent(null);
    }

    public abstract void repaint(int var1, int var2, int var3, int var4);

    protected abstract void sizeChanged(Dimension var1, Dimension var2);

    protected abstract EmbeddedToolkit<?> getEmbeddedToolkit();

    public JPanel getShellPanel() {
        return this.getShell();
    }

    Shell getShell() {
        return this.shell;
    }

    JPanel getContainer() {
        return (JPanel)this.getShell().getParent();
    }

    public final Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
        this.shell.validate();
    }

    static {
        boolean bl = false;
        try {
            Utils.platformClassForName("java.awt.print.PrinterGraphics", false);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        havePrinterGraphics = bl;
    }

    private static class EmbeddedGraphicsFactory {
        private EmbeddedGraphicsFactory() {
        }

        static Graphics2D createGraphics(Graphics graphics) {
            return new EmbeddedGraphics((Graphics2D)graphics);
        }
    }

    class Shell
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private boolean firingPCE;
        private boolean contains;
        private boolean validateRunnableDone;
        private Runnable validateRunnable;

        Shell() {
            super(new BorderLayout());
            this.firingPCE = false;
            this.contains = false;
            this.validateRunnableDone = true;
            this.validateRunnable = new Runnable(){

                public void run() {
                    Shell.this.validate();
                    Shell.this.validateRunnableDone = true;
                }
            };
            this.setOpaque(false);
            this.setVisible(true);
            this.setBorder(null);
            this.enableEvents(131120L);
            SwingGlueLayer.getSwingGlueLayer().registerRepaintManager(this);
        }

        public boolean contains(int n, int n2) {
            return this.contains;
        }

        void setContains(boolean bl) {
            this.contains = bl;
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
            EmbeddedPeer.this.repaint(n, n2, n3, n4);
        }

        public boolean isShowing() {
            return true;
        }

        public boolean isVisible() {
            return true;
        }

        public void invalidate() {
            super.invalidate();
            if (!this.firingPCE && EmbeddedPeer.this.component != null) {
                this.firingPCE = true;
                EmbeddedPeer.this.component.firePropertyChange("$fx_preferredSize", 0L, 1L);
                this.firingPCE = false;
            }
            if (this.validateRunnableDone) {
                this.validateRunnableDone = false;
                SwingUtilities.invokeLater(this.validateRunnable);
            }
        }

        public void validate() {
            Dimension dimension;
            Dimension dimension2 = this.getSize();
            if (EmbeddedPeer.this.component != null) {
                if (EmbeddedPeer.this.size != null) {
                    dimension = EmbeddedPeer.this.size;
                    if (dimension.width == Integer.MAX_VALUE || dimension.height == Integer.MAX_VALUE) {
                        Dimension dimension3 = EmbeddedPeer.this.component.getPreferredSize();
                        if (dimension.width == Integer.MAX_VALUE) {
                            dimension.width = dimension3.width;
                        }
                        if (dimension.height == Integer.MAX_VALUE) {
                            dimension.height = dimension3.height;
                        }
                    }
                } else {
                    dimension = EmbeddedPeer.this.component.getPreferredSize();
                }
            } else {
                dimension = new Dimension(0, 0);
            }
            if (!dimension.equals(dimension2)) {
                this.setSize(dimension);
                EmbeddedPeer.this.sizeChanged(dimension2, dimension);
            }
            super.validate();
        }

        EmbeddedPeer getEmbeddedPeer() {
            return EmbeddedPeer.this;
        }
    }

    class ShellContainer
    extends JPanel {
        private static final long serialVersionUID = 1L;

        ShellContainer() {
            super(null);
            this.setBounds(0, 0, 0, 0);
        }

        public boolean contains(int n, int n2) {
            if (this.getComponentCount() > 0) {
                return this.getComponent(0).contains(n, n2);
            }
            return super.contains(n, n2);
        }
    }
}

