/*
 * Decompiled with CFR 0.152.
 */
package com.sun.embeddedswing;

import com.sun.embeddedswing.EmbeddedPeer;
import com.sun.embeddedswing.SwingGlueLayer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedToolkit<T extends EmbeddedPeer> {
    static final Object EmbeddedToolkitKey = new StringBuilder("EmbeddedToolkitKey");
    private static final Runnable nopRunnable = new Runnable(){

        public void run() {
        }
    };

    public abstract Popup getPopup(EmbeddedPeer var1, Component var2, int var3, int var4);

    protected abstract T createEmbeddedPeer(JComponent var1, Component var2, Object ... var3);

    protected abstract CoordinateHandler createCoordinateHandler(JComponent var1, Point2D var2, MouseEvent var3);

    protected Runnable processMouseEvent(MouseEvent mouseEvent, Point2D point2D, EmbeddedPeer embeddedPeer) {
        return nopRunnable;
    }

    public final T embed(JComponent jComponent, Component component, Object ... objectArray) {
        this.registerEmbeddedToolkit(jComponent);
        return this.createEmbeddedPeer(jComponent, component, objectArray);
    }

    public final T getEmbeddedPeer(Component component) {
        EmbeddedPeer embeddedPeer;
        EmbeddedPeer.Shell shell = null;
        if (component instanceof EmbeddedPeer.ShellContainer) {
            component = ((EmbeddedPeer.ShellContainer)component).getComponent(0);
        } else if (!(component instanceof EmbeddedPeer.Shell)) {
            component = SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, component);
        }
        if (component != null && EmbeddedToolkit.getEmbeddedToolkit((embeddedPeer = (shell = (EmbeddedPeer.Shell)component).getEmbeddedPeer()).getParentComponent()) == this) {
            return (T)embeddedPeer;
        }
        return null;
    }

    public static final boolean isEmbedded(Component component) {
        return SwingGlueLayer.getAncestorWithClientProperty(component, EmbeddedToolkitKey) != null;
    }

    public final void registerEmbeddedToolkit(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.putClientProperty(EmbeddedToolkitKey, this);
        }
    }

    public static final EmbeddedToolkit<?> getEmbeddedToolkit(JComponent jComponent) {
        return (EmbeddedToolkit)jComponent.getClientProperty(EmbeddedToolkitKey);
    }

    public static interface CoordinateHandler {
        public EmbeddedPeer getEmbeddedPeer();

        public Point2D transform(Point2D var1, Point2D var2, MouseEvent var3);
    }
}

