/*
 * Decompiled with CFR 0.152.
 */
package com.sun.embeddedswing;

import com.sun.javafx.tk.TKScreenConfigurationListener;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class ScreenConfigurationUpdater {
    private final TKScreenConfigurationListener listener;
    private final TKScreenConfigurationListener.ScreenConfigurationAccessor accessor = new TKScreenConfigurationListener.ScreenConfigurationAccessor(){
        private Object cachedObject = null;
        private Rectangle bounds = null;
        private Insets insets = null;
        private float dpi = 0.0f;

        private void updateCache(Object object) {
            if (this.cachedObject != object) {
                this.cachedObject = object;
                GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)object;
                this.bounds = graphicsConfiguration.getBounds();
                this.insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                this.dpi = (float)(72.0 * graphicsConfiguration.getDefaultTransform().getScaleX() * graphicsConfiguration.getNormalizingTransform().getScaleX());
            }
        }

        public int getMinX(Object object) {
            this.updateCache(object);
            return this.bounds.x;
        }

        public int getMinY(Object object) {
            this.updateCache(object);
            return this.bounds.y;
        }

        public int getWidth(Object object) {
            this.updateCache(object);
            return this.bounds.width;
        }

        public int getHeight(Object object) {
            this.updateCache(object);
            return this.bounds.height;
        }

        public int getVisualMinX(Object object) {
            this.updateCache(object);
            return this.bounds.x + this.insets.left;
        }

        public int getVisualMinY(Object object) {
            this.updateCache(object);
            return this.bounds.y + this.insets.top;
        }

        public int getVisualWidth(Object object) {
            this.updateCache(object);
            return this.bounds.width - this.insets.left - this.insets.right;
        }

        public int getVisualHeight(Object object) {
            this.updateCache(object);
            return this.bounds.height - this.insets.top - this.insets.bottom;
        }

        public float getDPI(Object object) {
            this.updateCache(object);
            return this.dpi;
        }
    };
    private static long UPDATE_THRESHOLD = TimeUnit.SECONDS.toNanos(1L);
    private long lastUpdate = Long.MIN_VALUE;

    ScreenConfigurationUpdater(TKScreenConfigurationListener tKScreenConfigurationListener) {
        this.listener = tKScreenConfigurationListener;
    }

    void update() {
        if (this.lastUpdate == Long.MIN_VALUE || System.nanoTime() - this.lastUpdate > UPDATE_THRESHOLD) {
            this.updateNow();
        }
    }

    void updateNow() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            arrayList.add(graphicsDevice.getDefaultConfiguration());
        }
        this.listener.screenConfigurationChanged(graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration(), arrayList, this.accessor);
        this.lastUpdate = System.nanoTime();
    }
}

