/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class WeakReferenceQueue {
    ArrayList queue = new ArrayList();

    public void add(Object object) {
        this.cleanup();
        this.queue.add(new WeakReference<Object>(object));
    }

    public void remove(Object object) {
        for (int i = this.queue.size() - 1; i >= 0; --i) {
            WeakReference weakReference = (WeakReference)this.queue.get(i);
            Object t = weakReference.get();
            if (t != null && t != object) continue;
            this.queue.remove(i);
        }
    }

    public void cleanup() {
        this.remove(null);
    }

    public Iterator iterator() {
        return new Iterator(){
            private int index;
            private Object next;
            {
                this.index = WeakReferenceQueue.this.queue.size();
                this.next = null;
            }

            public boolean hasNext() {
                this.next = null;
                while (this.next == null && this.index > 0) {
                    int n = this.index - 1;
                    WeakReference weakReference = (WeakReference)WeakReferenceQueue.this.queue.get(n);
                    this.next = weakReference.get();
                    if (this.next != null) continue;
                    WeakReferenceQueue.this.queue.remove(n);
                    --this.index;
                    --n;
                }
                return this.next != null;
            }

            public Object next() {
                this.hasNext();
                --this.index;
                return this.next;
            }

            public void remove() {
                WeakReferenceQueue.this.queue.remove(this.index);
            }
        };
    }
}

