/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.animation.transition;

import com.sun.javafx.animation.transition.Position2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.ArrayList;

public class AnimationPathHelper {
    private static final int SMOOTH_ZONE = 10;
    private ArrayList<Segment> segments = new ArrayList();
    private float totalLength = 0.0f;

    public AnimationPathHelper(Path2D path2D, BaseTransform baseTransform, float f) {
        Segment segment = Segment.getZeroSegment();
        Segment segment2 = Segment.getZeroSegment();
        float[] fArray = new float[6];
        PathIterator pathIterator = path2D.getPathIterator(baseTransform, f);
        while (!pathIterator.isDone()) {
            Segment segment3 = null;
            int n = pathIterator.currentSegment(fArray);
            float f2 = fArray[0];
            float f3 = fArray[1];
            switch (n) {
                case 0: {
                    segment3 = segment = Segment.newMoveTo(f2, f3, segment2.accumLength);
                    break;
                }
                case 4: {
                    segment3 = Segment.newClosePath(segment2, segment);
                    if (segment3 != null) break;
                    segment2.convertToClosePath(segment);
                    break;
                }
                case 1: {
                    segment3 = Segment.newLineTo(segment2, f2, f3);
                }
            }
            if (segment3 != null) {
                this.segments.add(segment3);
                segment2 = segment3;
            }
            pathIterator.next();
        }
        this.totalLength = segment2.accumLength;
    }

    public Position2D getPosition2D(float f, boolean bl, Position2D position2D) {
        float f2 = this.totalLength * Math.min(1.0f, Math.max(0.0f, f));
        int n = this.findSegment(0, this.segments.size() - 1, f2);
        Segment segment = this.segments.get(n);
        float f3 = segment.accumLength - segment.length;
        float f4 = f2 - f3;
        if (position2D == null) {
            position2D = new Position2D();
        }
        float f5 = f4 / segment.length;
        Segment segment2 = segment.prevSeg;
        position2D.x = segment2.toX + (segment.toX - segment2.toX) * f5;
        position2D.y = segment2.toY + (segment.toY - segment2.toY) * f5;
        position2D.rotateAngle = segment.rotateAngle;
        float f6 = Math.min(10.0f, segment.length / 2.0f);
        if (f4 < f6 && !segment2.isMoveTo) {
            position2D.rotateAngle = AnimationPathHelper.interpolate(segment2.rotateAngle, segment.rotateAngle, f4 / f6 / 2.0f + 0.5f);
        } else {
            float f7 = segment.length - f4;
            Segment segment3 = segment.nextSeg;
            if (f7 < f6 && segment3 != null && !segment3.isMoveTo) {
                position2D.rotateAngle = AnimationPathHelper.interpolate(segment.rotateAngle, segment3.rotateAngle, (f6 - f7) / f6 / 2.0f);
            }
        }
        return position2D;
    }

    private static float interpolate(float f, float f2, float f3) {
        float f4 = f2 - f;
        if (Math.abs(f4) > 180.0f) {
            f2 += f4 > 0.0f ? -360.0f : 360.0f;
        }
        return AnimationPathHelper.normalize(f + f3 * (f2 - f));
    }

    private static float normalize(float f) {
        while (f > 360.0f) {
            f -= 360.0f;
        }
        while (f < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    private int findSegment(int n, int n2, float f) {
        if (n == n2) {
            return this.segments.get((int)n).isMoveTo && n > 0 ? this.findSegment(n - 1, n - 1, f) : n;
        }
        int n3 = n + (n2 - n) / 2;
        return this.segments.get((int)n3).accumLength > f ? this.findSegment(n, n3, f) : this.findSegment(n3 + 1, n2, f);
    }

    private static class Segment {
        private static Segment zeroSegment;
        boolean isMoveTo;
        float length;
        float accumLength;
        float toX;
        float toY;
        float rotateAngle;
        Segment prevSeg;
        Segment nextSeg;

        private Segment(boolean bl, float f, float f2, float f3, float f4, float f5) {
            this.isMoveTo = bl;
            this.toX = f;
            this.toY = f2;
            this.length = f3;
            this.accumLength = f4 + f3;
            this.rotateAngle = f5;
        }

        public static Segment getZeroSegment() {
            if (zeroSegment == null) {
                zeroSegment = new Segment(true, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            return zeroSegment;
        }

        public static Segment newMoveTo(float f, float f2, float f3) {
            return new Segment(true, f, f2, 0.0f, f3, 0.0f);
        }

        public static Segment newLineTo(Segment segment, float f, float f2) {
            float f3 = f - segment.toX;
            float f4 = f2 - segment.toY;
            float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
            if (f5 >= 1.0f) {
                Segment segment2;
                float f6 = Math.signum(f4 == 0.0f ? f3 : f4);
                float f7 = (float)((double)f6 * Math.acos(f3 / f5));
                f7 = AnimationPathHelper.normalize((float)((double)f7 / Math.PI * 180.0));
                segment.nextSeg = segment2 = new Segment(false, f, f2, f5, segment.accumLength, f7);
                segment2.prevSeg = segment;
                return segment2;
            }
            return null;
        }

        public static Segment newClosePath(Segment segment, Segment segment2) {
            Segment segment3 = Segment.newLineTo(segment, segment2.toX, segment2.toY);
            if (segment3 != null) {
                segment3.convertToClosePath(segment2);
            }
            return segment3;
        }

        public void convertToClosePath(Segment segment) {
            Segment segment2;
            this.nextSeg = segment2 = segment.nextSeg;
            segment2.prevSeg = this;
        }
    }
}

