/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.json;

import com.sun.javafx.data.json.JSONSymbol;
import com.sun.javafx.data.pull.impl.Position;
import com.sun.javafx.data.pull.impl.StreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class JSONScanner
implements Position {
    private Reader reader;
    private String value;
    private int prevChar;
    private int x;
    private int y = 1;
    private int checkpointX;
    private int checkpointY;
    private int offset;
    private boolean isInt;

    public JSONScanner(InputStream inputStream, String string) throws StreamException, IOException {
        this.reader = new InputStreamReader(inputStream, string);
        this.offset = 0;
        this.prevChar = this.reader.read();
    }

    JSONSymbol nextSymbol() throws StreamException, IOException {
        JSONSymbol jSONSymbol;
        int n = this.prevChar;
        while (n != -1 && (n == 32 || n == 9 || n == 12 || n == 10 || n == 13)) {
            n = this.readChar(true);
        }
        this.value = null;
        switch (n) {
            case -1: {
                jSONSymbol = JSONSymbol.EOS;
                this.prevChar = -1;
                break;
            }
            case 123: {
                jSONSymbol = JSONSymbol.CURLYOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 125: {
                jSONSymbol = JSONSymbol.CURLYCLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 91: {
                jSONSymbol = JSONSymbol.SQUAREOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 93: {
                jSONSymbol = JSONSymbol.SQUARECLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 58: {
                jSONSymbol = JSONSymbol.COLON;
                this.prevChar = this.readChar(true);
                break;
            }
            case 44: {
                jSONSymbol = JSONSymbol.COMMA;
                this.prevChar = this.readChar(true);
                break;
            }
            case 116: {
                this.readKeyword("true");
                jSONSymbol = JSONSymbol.KEYWORD;
                break;
            }
            case 102: {
                this.readKeyword("false");
                jSONSymbol = JSONSymbol.KEYWORD;
                break;
            }
            case 110: {
                this.readKeyword("null");
                jSONSymbol = JSONSymbol.KEYWORD;
                break;
            }
            case 34: {
                this.value = this.readString();
                jSONSymbol = JSONSymbol.STRING;
                break;
            }
            case 45: {
                this.value = this.readNumber(n);
                jSONSymbol = JSONSymbol.NUMBER;
                break;
            }
            default: {
                if (n >= 48 && n <= 57) {
                    this.value = this.readNumber(n);
                    jSONSymbol = JSONSymbol.NUMBER;
                    break;
                }
                throw new StreamException("Unexpected character '" + (char)n + "'", this);
            }
        }
        return jSONSymbol;
    }

    public String getValue() {
        return this.value;
    }

    public Position getLocation() {
        return this;
    }

    private void readKeyword(String string) throws StreamException, IOException {
        int n;
        int n2 = 0;
        for (n = 1; n < string.length() && (n2 = this.readChar(false)) == string.charAt(n); ++n) {
        }
        if (n < string.length()) {
            throw new StreamException("Unexpected character '" + (char)n2 + "'", this);
        }
        this.value = string;
        this.prevChar = this.readChar(true);
    }

    private String readString() throws StreamException, IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            n = this.readChar(false);
            block0 : switch (n) {
                case -1: {
                    throw new StreamException("Unexpected end of stream", this);
                }
                case 92: {
                    int n2 = this.readChar(false);
                    switch (n2) {
                        case 34: 
                        case 47: 
                        case 92: {
                            stringBuilder.append((char)n2);
                            break block0;
                        }
                        case 98: {
                            stringBuilder.append('\b');
                            break block0;
                        }
                        case 102: {
                            stringBuilder.append('\f');
                            break block0;
                        }
                        case 110: {
                            stringBuilder.append('\n');
                            break block0;
                        }
                        case 114: {
                            stringBuilder.append('\r');
                            break block0;
                        }
                        case 116: {
                            stringBuilder.append('\t');
                            break block0;
                        }
                        case 117: {
                            int n3 = 0;
                            int n4 = 4;
                            while (--n4 >= 0) {
                                n2 = this.readChar(false);
                                n3 = (char)(n3 << 4);
                                if (n2 >= 48 && n2 <= 57) {
                                    n3 = (char)(n3 | (char)n2 - 48);
                                    continue;
                                }
                                if (n2 >= 97 && n2 <= 102) {
                                    n3 = (char)(n3 | (char)n2 - 97 + 10);
                                    continue;
                                }
                                if (n2 >= 65 && n2 <= 70) {
                                    n3 = (char)(n3 | (char)n2 - 65 + 10);
                                    continue;
                                }
                                throw new StreamException("Unexpected character '" + n2 + "'", this);
                            }
                            stringBuilder.append((char)(n3 & 0xFFFF));
                            break block0;
                        }
                    }
                    throw new StreamException("Unexpected character '" + n2 + "'", this);
                }
                case 34: {
                    break;
                }
                default: {
                    if (n >= 0 && n <= 31 || n >= 127 && n <= 159) {
                        throw new StreamException("Control character is not allowed inside string", this);
                    }
                    stringBuilder.append((char)n);
                }
            }
        } while (n != 34);
        this.prevChar = this.readChar(true);
        return stringBuilder.toString();
    }

    private String readNumber(int n) throws StreamException, IOException {
        int n2;
        int n3 = n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n3);
        if (n3 == 45) {
            n3 = this.readChar(true);
            stringBuilder.append((char)n3);
            if (n3 < 48 || n3 > 57) {
                throw new StreamException("Unexpected character '" + (char)n3 + "'", this);
            }
        }
        this.isInt = true;
        if (n3 == 48) {
            n3 = this.readChar(true);
            stringBuilder.append((char)n3);
        } else {
            do {
                n3 = this.readChar(true);
                stringBuilder.append((char)n3);
            } while (n3 >= 48 && n3 <= 57);
        }
        if (n3 == 46) {
            this.isInt = false;
            n2 = 0;
            do {
                n3 = this.readChar(true);
                stringBuilder.append((char)n3);
                ++n2;
            } while (n3 >= 48 && n3 <= 57);
            if (n2 == 1) {
                throw new StreamException("Unexpected character '" + (char)n3 + "'", this);
            }
        }
        if (n3 == 101 || n3 == 69) {
            this.isInt = false;
            n3 = this.readChar(false);
            stringBuilder.append((char)n3);
            if (n3 == 43 || n3 == 45) {
                n3 = this.readChar(false);
                stringBuilder.append((char)n3);
            }
            n2 = 0;
            while (n3 >= 48 && n3 <= 57) {
                n3 = this.readChar(true);
                stringBuilder.append((char)n3);
                ++n2;
            }
            if (n2 == 0) {
                throw new StreamException("Unexpected character '" + (char)n3 + "'", this);
            }
        }
        this.prevChar = n3;
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    private int readChar(boolean bl) throws IOException {
        int n = this.reader.read();
        if (bl) {
            this.checkpointX = this.x;
            this.checkpointY = this.y;
        }
        if (n == 10) {
            ++this.y;
            this.x = 0;
        } else {
            ++this.x;
        }
        ++this.offset;
        return n;
    }

    public boolean isInteger() {
        return this.isInt;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int line() {
        return this.y;
    }

    public int column() {
        return this.x;
    }

    public int getCharacterOffset() {
        return this.offset;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public String toString() {
        return this.y + ":" + this.x + (this.offset >= 0 ? "@" + this.offset : "");
    }
}

