/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;
import com.sun.javafx.geom.Order0;

final class CurveLink {
    Curve curve;
    float ytop;
    float ybot;
    int etag;
    CurveLink next;

    public CurveLink(Curve curve, float f, float f2, int n) {
        this.curve = curve;
        this.ytop = f;
        this.ybot = f2;
        this.etag = n;
        if (this.ytop < curve.getYTop() || this.ybot > curve.getYBot()) {
            throw new InternalError("bad curvelink [" + this.ytop + "=>" + this.ybot + "] for " + curve);
        }
    }

    public boolean absorb(CurveLink curveLink) {
        return this.absorb(curveLink.curve, curveLink.ytop, curveLink.ybot, curveLink.etag);
    }

    public boolean absorb(Curve curve, float f, float f2, int n) {
        if (this.curve != curve || this.etag != n || this.ybot < f || this.ytop > f2) {
            return false;
        }
        if (f < curve.getYTop() || f2 > curve.getYBot()) {
            throw new InternalError("bad curvelink [" + f + "=>" + f2 + "] for " + curve);
        }
        this.ytop = Math.min(this.ytop, f);
        this.ybot = Math.max(this.ybot, f2);
        return true;
    }

    public boolean isEmpty() {
        return this.ytop == this.ybot;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public Curve getSubCurve() {
        if (this.ytop == this.curve.getYTop() && this.ybot == this.curve.getYBot()) {
            return this.curve.getWithDirection(this.etag);
        }
        return this.curve.getSubCurve(this.ytop, this.ybot, this.etag);
    }

    public Curve getMoveto() {
        return new Order0(this.getXTop(), this.getYTop());
    }

    public float getXTop() {
        return this.curve.XforY(this.ytop);
    }

    public float getYTop() {
        return this.ytop;
    }

    public float getXBot() {
        return this.curve.XforY(this.ybot);
    }

    public float getYBot() {
        return this.ybot;
    }

    public float getX() {
        return this.curve.XforY(this.ytop);
    }

    public int getEdgeTag() {
        return this.etag;
    }

    public void setNext(CurveLink curveLink) {
        this.next = curveLink;
    }

    public CurveLink getNext() {
        return this.next;
    }
}

