/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Curve;
import java.util.Vector;

final class Order2
extends Curve {
    private float x0;
    private float y0;
    private float cx0;
    private float cy0;
    private float x1;
    private float y1;
    private float xmin;
    private float xmax;
    private float xcoeff0;
    private float xcoeff1;
    private float xcoeff2;
    private float ycoeff0;
    private float ycoeff1;
    private float ycoeff2;

    public static void insert(Vector vector, float[] fArray, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        int n2 = Order2.getHorizontalParams(f2, f4, f6, fArray);
        if (n2 == 0) {
            Order2.addInstance(vector, f, f2, f3, f4, f5, f6, n);
            return;
        }
        float f7 = fArray[0];
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        Order2.split(fArray, 0, f7);
        int n3 = n == 1 ? 0 : 4;
        int n4 = 4 - n3;
        Order2.addInstance(vector, fArray[n3], fArray[n3 + 1], fArray[n3 + 2], fArray[n3 + 3], fArray[n3 + 4], fArray[n3 + 5], n);
        Order2.addInstance(vector, fArray[n4], fArray[n4 + 1], fArray[n4 + 2], fArray[n4 + 3], fArray[n4 + 4], fArray[n4 + 5], n);
    }

    public static void addInstance(Vector vector, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        if (f2 > f6) {
            vector.add(new Order2(f5, f6, f3, f4, f, f2, -n));
        } else if (f6 > f2) {
            vector.add(new Order2(f, f2, f3, f4, f5, f6, n));
        }
    }

    public static int getHorizontalParams(float f, float f2, float f3, float[] fArray) {
        if (f <= f2 && f2 <= f3) {
            return 0;
        }
        float f4 = (f -= f2) + (f3 -= f2);
        if (f4 == 0.0f) {
            return 0;
        }
        float f5 = f / f4;
        if (f5 <= 0.0f || f5 >= 1.0f) {
            return 0;
        }
        fArray[0] = f5;
        return 1;
    }

    public static void split(float[] fArray, int n, float f) {
        float f2;
        float f3;
        fArray[n + 8] = f3 = fArray[n + 4];
        fArray[n + 9] = f2 = fArray[n + 5];
        float f4 = fArray[n + 2];
        float f5 = fArray[n + 3];
        f3 = f4 + (f3 - f4) * f;
        f2 = f5 + (f2 - f5) * f;
        float f6 = fArray[n + 0];
        float f7 = fArray[n + 1];
        f6 += (f4 - f6) * f;
        f7 += (f5 - f7) * f;
        f4 = f6 + (f3 - f6) * f;
        f5 = f7 + (f2 - f7) * f;
        fArray[n + 2] = f6;
        fArray[n + 3] = f7;
        fArray[n + 4] = f4;
        fArray[n + 5] = f5;
        fArray[n + 6] = f3;
        fArray[n + 7] = f2;
    }

    public Order2(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        super(n);
        if (f4 < f2) {
            f4 = f2;
        } else if (f4 > f6) {
            f4 = f6;
        }
        this.x0 = f;
        this.y0 = f2;
        this.cx0 = f3;
        this.cy0 = f4;
        this.x1 = f5;
        this.y1 = f6;
        this.xmin = Math.min(Math.min(f, f5), f3);
        this.xmax = Math.max(Math.max(f, f5), f3);
        this.xcoeff0 = f;
        this.xcoeff1 = f3 + f3 - f - f;
        this.xcoeff2 = f - f3 - f3 + f5;
        this.ycoeff0 = f2;
        this.ycoeff1 = f4 + f4 - f2 - f2;
        this.ycoeff2 = f2 - f4 - f4 + f6;
    }

    public int getOrder() {
        return 2;
    }

    public float getXTop() {
        return this.x0;
    }

    public float getYTop() {
        return this.y0;
    }

    public float getXBot() {
        return this.x1;
    }

    public float getYBot() {
        return this.y1;
    }

    public float getXMin() {
        return this.xmin;
    }

    public float getXMax() {
        return this.xmax;
    }

    public float getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    public float getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public float getCX0() {
        return this.cx0;
    }

    public float getCY0() {
        return this.cy0;
    }

    public float getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    public float getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    public float XforY(float f) {
        if (f <= this.y0) {
            return this.x0;
        }
        if (f >= this.y1) {
            return this.x1;
        }
        return this.XforT(this.TforY(f));
    }

    public float TforY(float f) {
        if (f <= this.y0) {
            return 0.0f;
        }
        if (f >= this.y1) {
            return 1.0f;
        }
        return Order2.TforY(f, this.ycoeff0, this.ycoeff1, this.ycoeff2);
    }

    public static float TforY(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        f2 -= f;
        if (f4 == 0.0f) {
            f6 = -f2 / f3;
            if (f6 >= 0.0f && f6 <= 1.0f) {
                return f6;
            }
        } else {
            f6 = f3 * f3 - 4.0f * f4 * f2;
            if (f6 >= 0.0f) {
                float f7;
                f6 = (float)Math.sqrt(f6);
                if (f3 < 0.0f) {
                    f6 = -f6;
                }
                if ((f7 = (f5 = (f3 + f6) / -2.0f) / f4) >= 0.0f && f7 <= 1.0f) {
                    return f7;
                }
                if (f5 != 0.0f && (f7 = f2 / f5) >= 0.0f && f7 <= 1.0f) {
                    return f7;
                }
            }
        }
        return 0.0f < ((f6 = f2) + (f5 = f2 + f3 + f4)) / 2.0f ? 0.0f : 1.0f;
    }

    public float XforT(float f) {
        return (this.xcoeff2 * f + this.xcoeff1) * f + this.xcoeff0;
    }

    public float YforT(float f) {
        return (this.ycoeff2 * f + this.ycoeff1) * f + this.ycoeff0;
    }

    public float dXforT(float f, int n) {
        switch (n) {
            case 0: {
                return (this.xcoeff2 * f + this.xcoeff1) * f + this.xcoeff0;
            }
            case 1: {
                return 2.0f * this.xcoeff2 * f + this.xcoeff1;
            }
            case 2: {
                return 2.0f * this.xcoeff2;
            }
        }
        return 0.0f;
    }

    public float dYforT(float f, int n) {
        switch (n) {
            case 0: {
                return (this.ycoeff2 * f + this.ycoeff1) * f + this.ycoeff0;
            }
            case 1: {
                return 2.0f * this.ycoeff2 * f + this.ycoeff1;
            }
            case 2: {
                return 2.0f * this.ycoeff2;
            }
        }
        return 0.0f;
    }

    public float nextVertical(float f, float f2) {
        float f3 = -this.xcoeff1 / (2.0f * this.xcoeff2);
        if (f3 > f && f3 < f2) {
            return f3;
        }
        return f2;
    }

    public void enlarge(Bounds2D bounds2D) {
        bounds2D.add(this.x0, this.y0);
        float f = -this.xcoeff1 / (2.0f * this.xcoeff2);
        if (f > 0.0f && f < 1.0f) {
            bounds2D.add(this.XforT(f), this.YforT(f));
        }
        bounds2D.add(this.x1, this.y1);
    }

    public Curve getSubCurve(float f, float f2, int n) {
        int n2;
        float f3;
        if (f <= this.y0) {
            if (f2 >= this.y1) {
                return this.getWithDirection(n);
            }
            f3 = 0.0f;
        } else {
            f3 = Order2.TforY(f, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        }
        float f4 = f2 >= this.y1 ? 1.0f : Order2.TforY(f2, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        float[] fArray = new float[10];
        fArray[0] = this.x0;
        fArray[1] = this.y0;
        fArray[2] = this.cx0;
        fArray[3] = this.cy0;
        fArray[4] = this.x1;
        fArray[5] = this.y1;
        if (f4 < 1.0f) {
            Order2.split(fArray, 0, f4);
        }
        if (f3 <= 0.0f) {
            n2 = 0;
        } else {
            Order2.split(fArray, 0, f3 / f4);
            n2 = 4;
        }
        return new Order2(fArray[n2 + 0], f, fArray[n2 + 2], fArray[n2 + 3], fArray[n2 + 4], f2, n);
    }

    public Curve getReversedCurve() {
        return new Order2(this.x0, this.y0, this.cx0, this.cy0, this.x1, this.y1, -this.direction);
    }

    public int getSegment(float[] fArray) {
        fArray[0] = this.cx0;
        fArray[1] = this.cy0;
        if (this.direction == 1) {
            fArray[2] = this.x1;
            fArray[3] = this.y1;
        } else {
            fArray[2] = this.x0;
            fArray[3] = this.y0;
        }
        return 2;
    }

    public String controlPointString() {
        return "(" + Order2.round(this.cx0) + ", " + Order2.round(this.cy0) + "), ";
    }
}

