/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl.desktop;

import com.sun.javafx.functions.Function0;
import com.sun.javafx.io.http.impl.Connection;
import com.sun.javafx.io.http.impl.HttpTask;
import com.sun.javafx.io.http.impl.Profile;
import com.sun.javafx.io.http.impl.Task;
import com.sun.javafx.io.http.impl.desktop.DesktopConnection;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.lang.FX;

public final class DesktopProfile
implements Profile {
    private static final int CORE_POOL_SIZE = 8;
    private static final int MAX_POOL_SIZE = 64;
    private static final long KEEP_ALIVE_SECONDS = 30L;
    private static final Logger LOG = Logger.getLogger(DesktopProfile.class.getName());
    private static final BlockingQueue<Runnable> ioQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadGroup threadGroup = new ThreadGroup("request io pool");
    private static final Thread.UncaughtExceptionHandler uncaughtHandler = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!(throwable instanceof IllegalMonitorStateException)) {
                LOG.log(Level.WARNING, "Uncaught throwable in " + threadGroup.getName(), throwable);
            }
        }
    };
    private static final ThreadFactory threadFactory = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(threadGroup, runnable);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(uncaughtHandler);
            return thread;
        }
    };
    private static final ThreadPoolExecutor executor = new IOThreadPoolExecutor(8, 64, 30L, TimeUnit.SECONDS, ioQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    private static final Queue<IOTask> activeTasks = new ConcurrentLinkedQueue<IOTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task) {
        BlockingQueue<Runnable> blockingQueue = ioQueue;
        synchronized (blockingQueue) {
            executor.execute(new IOTask(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int n) {
        BlockingQueue<Runnable> blockingQueue = ioQueue;
        synchronized (blockingQueue) {
            Iterator object = ioQueue.iterator();
            while (object.hasNext()) {
                Runnable runnable = (Runnable)object.next();
                if (!(runnable instanceof IOTask)) continue;
                IOTask iOTask = (IOTask)runnable;
                if (iOTask.task.getId() != n) continue;
                iOTask.task.cancel();
                iOTask.cancel(true);
                object.remove();
                break;
            }
        }
        for (IOTask iOTask : activeTasks) {
            if (iOTask.task.getId() != n) continue;
            iOTask.task.cancel();
            iOTask.cancel(true);
            break;
        }
    }

    public void shutdown() {
        executor.shutdown();
    }

    public void shutdownNow() {
        executor.shutdownNow();
    }

    public void deferTask(final Runnable runnable) {
        FX.deferAction(new Function0<Void>(){

            @Override
            public Void invoke() {
                runnable.run();
                return null;
            }
        });
    }

    public String encodeURL(String string) {
        try {
            return HttpTask.encodeURL(string, false, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.WARNING, "unable to encode params " + string, unsupportedEncodingException);
            return null;
        }
    }

    public String encodeURL(String string, boolean bl, boolean bl2) {
        try {
            return HttpTask.encodeURL(string, bl, bl2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.WARNING, "unable to encode params " + string, unsupportedEncodingException);
            return null;
        }
    }

    public String decodeURL(String string) {
        try {
            return URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.WARNING, "unable to decode params " + string, unsupportedEncodingException);
            return null;
        }
    }

    public Connection newConnection() {
        return new DesktopConnection();
    }

    public String name() {
        return "desktop";
    }

    public int getMaxChunkSize() {
        return 65536;
    }

    public int getMinChunkSize() {
        return 512;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IOTask
    extends FutureTask<Object> {
        final Task task;

        IOTask(Task task) {
            super(Executors.callable(task));
            this.task = task;
        }

        @Override
        protected void setException(Throwable throwable) {
            super.setException(throwable);
            if (throwable instanceof Exception) {
                this.task.setException((Exception)throwable);
            } else {
                this.task.setException(new RuntimeException(throwable));
            }
        }

        @Override
        protected void done() {
            this.task.setDone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IOThreadPoolExecutor
    extends ThreadPoolExecutor {
        public IOThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
            super(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            if (runnable instanceof IOTask) {
                IOTask iOTask = (IOTask)runnable;
                activeTasks.add(iOTask);
                String string = "io." + iOTask.task.getId();
                thread.setName(string);
                LOG.finer(threadGroup.getName() + ": starting " + string);
            }
            super.beforeExecute(thread, runnable);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            if (runnable instanceof IOTask) {
                IOTask iOTask = (IOTask)runnable;
                activeTasks.remove(iOTask);
                String string = "io." + iOTask.task.getId();
                LOG.finer(threadGroup.getName() + ": done " + string);
            }
        }
    }
}

