/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.impl.file;

import com.sun.javafx.io.impl.AbstractFactory;
import com.sun.javafx.io.impl.AbstractStorage;
import com.sun.javafx.io.impl.file.config.Config;
import java.io.File;

public class AbstractStorageImpl
extends AbstractStorage {
    private static final String DOMAIN_LIMIT_KEY = "storage.limit.domain";
    private static final String FILE_LIMIT_KEY = "storage.limit.file";
    private static final String BASE_KEY = "storage.base";
    private static final String TRACE_KEY = "storage.trace";
    private static final String ENABLED_KEY = "storage.enabled";
    private static final String SHARE_KEY = "storage.share";
    private static final String BASE_DIR = Config.getStorageDirectory();
    private static final String DEFAULT_PROPERTY_FILE_NAME = "__defaultPropertyFile.dat";
    private static final long APPLICATION_SIZE_LIMIT = 0x100000L;
    private static final long FILE_SIZE_LIMIT = 8192L;
    private static final long SYSTEM_SIZE_LIMIT = 0x500000L;
    public static boolean DEBUG = AbstractFactory.getAbstractStorage().isTraceEnabled();

    public String getStorageBase() {
        String string = Config.getProperty(BASE_KEY);
        return string != null ? string : BASE_DIR;
    }

    public String getDefaultPropertiesFileName() {
        return DEFAULT_PROPERTY_FILE_NAME;
    }

    public long getApplicationSizeLimit() {
        String string = Config.getProperty(DOMAIN_LIMIT_KEY);
        AbstractStorageImpl.print("getApplicationSizeLimit: llimit=" + string);
        if (string != null) {
            try {
                return Long.parseLong(string) * 1024L;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return 0x100000L;
    }

    public long getFileSizeLimit() {
        String string = Config.getProperty(FILE_LIMIT_KEY);
        AbstractStorageImpl.print("getFileSizeLimit: llimit=" + string);
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return 8192L;
    }

    public char getPlatformSeparatorChar() {
        return File.separatorChar;
    }

    public boolean isTraceEnabled() {
        String string = Config.getProperty(TRACE_KEY);
        if (string != null) {
            return Boolean.valueOf(string) == Boolean.TRUE;
        }
        return false;
    }

    public boolean isEnabled() {
        String string = Config.getProperty(ENABLED_KEY);
        if (string != null) {
            return Boolean.valueOf(string) == Boolean.TRUE;
        }
        return true;
    }

    public boolean isSharingEnabled() {
        String string = Config.getProperty(SHARE_KEY);
        if (string != null) {
            return Boolean.valueOf(string) == Boolean.TRUE;
        }
        return true;
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("AbstractStorageImpl." + string);
        }
    }
}

