/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.impl.file.config;

import com.sun.javafx.io.impl.AbstractFactory;
import com.sun.javafx.io.impl.file.config.UnixConfig;
import com.sun.javafx.io.impl.file.config.WinConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class Config {
    private static Properties _defaultProps = null;
    private static Properties _props = null;
    private static final String _userHome;
    private static final String BASE = "deployment.";
    private static final String USER = "deployment.user.";
    private static final String STORAGEDIR_KEY = "deployment.user.storagedir";
    private static final String STORAGEDIR_DEF;
    private static Config _config;
    private static final String _os;
    private static boolean DEBUG;

    public static synchronized Config getInstance() {
        if (_config == null) {
            _config = _os.startsWith("Win") ? new WinConfig() : new UnixConfig();
        }
        return _config;
    }

    private static boolean initialize() {
        boolean bl = true;
        _defaultProps = Config.getDefaultProps();
        Config.refreshProps();
        return true;
    }

    private static Properties getDefaultProps() {
        Properties properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Config.getStorageProperties();
            }
        });
        properties.setProperty(STORAGEDIR_KEY, STORAGEDIR_DEF);
        return properties;
    }

    public static void refreshProps() {
        _props = new Properties(_defaultProps);
    }

    public static String getProperty(String string) {
        String string2 = _props.getProperty(string);
        Config.print("getProperty: key=" + string + " value=" + string2);
        if (string2 != null) {
            return Config.replaceVariables(string2).trim();
        }
        return null;
    }

    public static String getProperty(String string, String string2) {
        String string3 = Config.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    private static String replaceVariables(String string) {
        Config.print("replaceVariables: value=" + string);
        if (string.indexOf("$USER_HOME") >= 0) {
            string = Config.substitute(string, _userHome, "$USER_HOME");
            Config.print("replaceVariables: _userHome=" + _userHome + " new value=" + string);
        }
        return string;
    }

    private static String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string3);
        return n < 0 ? string : string.substring(0, n) + string2 + string.substring(n + string3.length());
    }

    public static String getStorageDirectory() {
        Config.print("getStorageDirectory STORAGEDIR_KEY=deployment.user.storagedir STORAGEDIR_DEF=" + STORAGEDIR_DEF + " " + Config.getProperty(STORAGEDIR_KEY));
        return Config.getProperty(STORAGEDIR_KEY);
    }

    public String getPlatformUserHome() {
        return null;
    }

    private static Properties getStorageProperties() {
        Properties properties;
        String string = _userHome;
        File file = new File(string + File.separator + "storage.properties");
        if (!file.exists()) {
            block5: {
                File file2 = new File(string);
                if (!file2.exists()) {
                    Config.print("getStorageProperties: " + string + " does not exist; creating");
                    try {
                        file2.mkdirs();
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block5;
                        exception.printStackTrace();
                    }
                }
            }
            properties = Config.getDefaultStorageProperties();
            Config.saveProperties(properties, file);
        } else {
            properties = Config.loadProperties(file);
        }
        return properties;
    }

    private static Properties loadProperties(File file) {
        Properties properties = null;
        try {
            properties = new Properties();
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    private static void saveProperties(Properties properties, File file) {
        if (null == properties) {
            return;
        }
        try {
            File file2 = file;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, "JavaFX Storage Configuration");
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static Properties getDefaultStorageProperties() {
        Properties properties = new Properties();
        URL uRL = ClassLoader.getSystemResource("com/sun/javafx/io/impl/file/storage.properties");
        Config.print("getDefautStorageProperties: res=" + uRL);
        if (uRL != null) {
            File file = new File(uRL.getFile());
            properties = Config.loadProperties(file);
        }
        return properties;
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("Config." + string);
        }
    }

    static {
        STORAGEDIR_DEF = "$USER_HOME" + File.separator + "storage";
        String string = System.getProperty("os.name");
        _os = string.startsWith("Win") ? "Windows" : string;
        _userHome = Config.getInstance().getPlatformUserHome();
        Config.initialize();
        DEBUG = AbstractFactory.getAbstractStorage().isTraceEnabled();
    }
}

