/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.SystemProperties;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LauncherHelper {
    INSTANCE;

    private static final String myname = "javafx";
    private static final String defaultBundleName = "com.sun.javafx.runtime.resources.launcher";
    private static ResourceBundle javafxrb;

    private static void printVersion(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("javafx ");
        if (bl) {
            stringBuilder = stringBuilder.append("full version ");
            stringBuilder = stringBuilder.append("\"");
            stringBuilder = stringBuilder.append(SystemProperties.getProperty("javafx.runtime.version"));
            stringBuilder = stringBuilder.append("\"");
        } else {
            stringBuilder = stringBuilder.append(SystemProperties.getProperty("javafx.version"));
        }
        System.err.println(stringBuilder.toString());
        System.err.flush();
    }

    static synchronized String getLocalizedMessage(String string, Object ... objectArray) {
        if (javafxrb == null) {
            javafxrb = ResourceBundle.getBundle(defaultBundleName);
        }
        String string2 = javafxrb.getString(string);
        return objectArray != null ? MessageFormat.format(string2, objectArray) : string2;
    }

    static StringBuilder getHelpMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = stringBuilder.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.header", myname));
        stringBuilder = stringBuilder.append("\n");
        stringBuilder = stringBuilder.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.datamodel", 32, LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        stringBuilder = stringBuilder.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.datamodel", 64, LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        stringBuilder = stringBuilder.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.vmselect", "-client", "client", LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        stringBuilder = stringBuilder.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.vmselect", "-server", "server", LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        stringBuilder = stringBuilder.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.footer", File.pathSeparator));
        return stringBuilder;
    }

    private static void printHelpMessage() {
        System.err.println(LauncherHelper.getHelpMessage().toString());
        System.err.flush();
    }

    static void printHelpMessageX() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = stringBuilder.append(LauncherHelper.getLocalizedMessage("javafx.launcher.X.usage", File.pathSeparator));
        System.err.println(stringBuilder.toString());
        System.err.flush();
    }

    public static void main(String ... stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-fullversion")) {
                LauncherHelper.printVersion(true);
            } else if (stringArray[0].equals("-version")) {
                LauncherHelper.printVersion(false);
            } else if (stringArray[0].endsWith("-helpx")) {
                LauncherHelper.printHelpMessageX();
            } else {
                LauncherHelper.printHelpMessage();
            }
        }
    }

    static {
        javafxrb = null;
    }
}

