/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.date;

import com.sun.javafx.runtime.date.CalendarUtils;
import com.sun.javafx.runtime.date.DateTimeEngine;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeConverter {
    private static final String DELIMITERS = "--T::";
    private static int FIELD_YEAR = 0;
    private static int FIELD_MONTH = 1;
    private static int FIELD_DAY_OF_MONTH = 2;
    private static int FIELD_HOUR = 3;
    private static int FIELD_MINUTE = 4;
    private static int FIELD_SECOND = 5;
    static final String[] DAY_ABBRS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] MONTH_ABBRS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final int NAME_STD = 0;
    private static final int NAME_DST = 1;
    private static final String[][] RFC822ZONE_NAMES = new String[][]{{"EST", "EDT"}, {"CST", "CDT"}, {"MST", "MDT"}, {"PST", "PDT"}, {"GMT", null}, {"UT", null}};
    private static final int OFFSET_STD = 0;
    private static final int OFFSET_DST = 1;
    private static final int[][] RFC822ZONE_OFFSETS = new int[][]{{-18000000, -14400000}, {-21600000, -18000000}, {-25200000, -21600000}, {-28800000, -25200000}, {0, 0}, {0, 0}};
    private static final int ZONE_ID = 0;
    private static final int ZONE_ALTSTD = 1;
    private static final int ZONE_ALTDST = 2;
    private static final String[][] RFC822ZONE_IDS = new String[][]{{"America/New_York", "GMT-05:00", "GMT-04:00"}, {"America/Chicago", "GMT-06:00", "GMT-05:00"}, {"America/Denver", "America/Phoenix", "GMT-06:00"}, {"America/Los_Angeles", "GMT-08:00", "GMT-07:00"}, {"GMT", null, null}, {"GMT", null, null}};

    public static DateTimeEngine parseXMLDateTime(String string) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int[] nArray = new int[]{0};
        int n5 = string.length();
        int n6 = DELIMITERS.length();
        int[] nArray2 = new int[n6 + 1];
        for (n3 = 0; n3 <= n6; ++n3) {
            n2 = DateTimeConverter.parseInt(string, n4, nArray);
            n = n2 - n4;
            int n7 = nArray[0];
            if (n3 == FIELD_YEAR) {
                if (n7 == 0) {
                    DateTimeConverter.syntaxError(n4);
                }
                if (n7 < 0) {
                    --n;
                    ++n4;
                }
                if (n < 4 || n > 4 && string.charAt(n4) == '0') {
                    DateTimeConverter.syntaxError(n4);
                }
            } else if (n != 2 || n7 < 0) {
                DateTimeConverter.syntaxError(n4);
            }
            n4 = n2;
            if (n3 != n6 && n4 < n5 && string.charAt(n4++) != DELIMITERS.charAt(n3)) {
                DateTimeConverter.syntaxError(n4 - 1);
            }
            nArray2[n3] = n7;
        }
        n3 = 0;
        if (n4 < n5 && (n2 = (int)string.charAt(n4)) == 46) {
            n = n4++;
            while (n4 < n5) {
                char c = string.charAt(n4);
                n2 = c;
                if (c < '0' || n2 > 57) break;
                ++n4;
            }
            try {
                float f = Float.parseFloat(string.substring(n, n4));
                n3 = (int)(f * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.toString());
            }
        }
        n2 = 0;
        if (nArray2[FIELD_HOUR] == 24) {
            if (nArray2[FIELD_MINUTE] != 0 || nArray2[FIELD_SECOND] != 0 || n3 != 0) {
                throw new IllegalArgumentException("invalid hour of day value");
            }
            n2 = 1;
            nArray2[DateTimeConverter.FIELD_HOUR] = 0;
        }
        DateTimeEngine dateTimeEngine = DateTimeEngine.getInstance();
        if (n4 < n5) {
            char c;
            if ((c = string.charAt(n4++)) == 'Z') {
                dateTimeEngine.setZone(TimeZone.getTimeZone("UTC"));
            } else if (c == '-' || c == '+') {
                int n8 = n4 - 1;
                int n9 = DateTimeConverter.parseInt(string, n4, nArray);
                if (n9 - n4 != 2) {
                    DateTimeConverter.syntaxError(n4);
                }
                int n10 = nArray[0] * 60;
                n4 = n9;
                if (string.charAt(n4++) != ':') {
                    DateTimeConverter.syntaxError(n4 - 1);
                }
                if ((n9 = DateTimeConverter.parseInt(string, n4, nArray)) - n4 != 2 || nArray[0] > 59) {
                    DateTimeConverter.syntaxError(n4);
                }
                n4 = n9;
                if ((n10 += nArray[0]) > 840) {
                    DateTimeConverter.syntaxError(n4);
                }
                if (n10 == 0) {
                    dateTimeEngine.setZone(TimeZone.getTimeZone("UTC"));
                } else {
                    TimeZone timeZone = TimeZone.getTimeZone("GMT" + string.substring(n8, n8 + 6));
                    if (timeZone.getRawOffset() == 0) {
                        throw new InternalError("No custom time zone support");
                    }
                    dateTimeEngine.setZone(timeZone);
                }
            }
        }
        if (n4 != n5) {
            DateTimeConverter.syntaxError(n4);
        }
        dateTimeEngine.setDate(nArray2[FIELD_YEAR], nArray2[FIELD_MONTH], nArray2[FIELD_DAY_OF_MONTH]);
        dateTimeEngine.setTimeOfDay(nArray2[FIELD_HOUR], nArray2[FIELD_MINUTE], nArray2[FIELD_SECOND], n3);
        if (!dateTimeEngine.validate()) {
            throw new IllegalArgumentException("invalid date-time");
        }
        if (n2 != 0) {
            dateTimeEngine.setHours(24);
        }
        dateTimeEngine.resetNormalized();
        return dateTimeEngine;
    }

    public static String toRFC822String(DateTimeEngine dateTimeEngine) {
        dateTimeEngine.getInstant();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DAY_ABBRS[dateTimeEngine.getDayOfWeek() - 1]).append(", ");
        CalendarUtils.sprintf0d(stringBuilder, dateTimeEngine.getDayOfMonth(), 2).append(' ');
        stringBuilder.append(MONTH_ABBRS[dateTimeEngine.getMonth() - 1]).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, dateTimeEngine.getYear(), 4).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, dateTimeEngine.getHours(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, dateTimeEngine.getMinutes(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, dateTimeEngine.getSeconds(), 2);
        TimeZone timeZone = dateTimeEngine.getZone();
        if (timeZone != null) {
            stringBuilder.append(' ');
            try {
                String string = timeZone.getDisplayName(false, 0, Locale.US);
                int n = timeZone.getRawOffset();
                if (DateTimeConverter.isRFC822ZoneName(string, n)) {
                    DateTimeConverter.appendRFC822ZoneName(stringBuilder, dateTimeEngine.getZoneOffset(), dateTimeEngine.getDaylightSaving() > 0);
                } else {
                    DateTimeConverter.appendRFC822ZoneNumeric(stringBuilder, dateTimeEngine.getZoneOffset());
                }
            }
            catch (LinkageError linkageError) {
                DateTimeConverter.appendRFC822ZoneNumeric(stringBuilder, dateTimeEngine.getZoneOffset());
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DateTimeEngine parseRFC822DateTime(String string) {
        try {
            DateTimeEngine dateTimeEngine;
            int n;
            int n2;
            int[] nArray;
            int n3;
            DateTimeEngine dateTimeEngine2 = DateTimeEngine.getInstance();
            int n4 = 0;
            int n5 = 0;
            if (string.charAt(3) == ',') {
                for (int i = 0; i < DAY_ABBRS.length; ++i) {
                    if (!string.startsWith(DAY_ABBRS[i])) continue;
                    n5 = i + 1;
                    break;
                }
                if (n5 == 0) {
                    DateTimeConverter.parseError("invalid day name");
                }
                DateTimeConverter.checkDelimiter(string, 4, ' ');
                n4 = 5;
            }
            if ((n3 = DateTimeConverter.parseInt(string, n4, nArray = new int[]{0})) - n4 > 2) {
                DateTimeConverter.syntaxError(n4);
            }
            dateTimeEngine2.setDayOfMonth(nArray[0]);
            DateTimeConverter.checkDelimiter(string, n3++, ' ');
            n4 = n3;
            for (n2 = 0; n2 < MONTH_ABBRS.length; ++n2) {
                if (!string.startsWith(MONTH_ABBRS[n2], n4)) continue;
                dateTimeEngine2.setMonth(n2 + 1);
                n4 += 3;
                break;
            }
            if (n4 == n3) {
                DateTimeConverter.parseError("invalid month name");
            }
            DateTimeConverter.checkDelimiter(string, n4++, ' ');
            n3 = DateTimeConverter.parseInt(string, n4, nArray);
            n2 = nArray[0];
            if (n2 >= 0 && n3 - n4 == 2 && (n2 += (n = (dateTimeEngine = DateTimeEngine.getInstance(System.currentTimeMillis(), TimeZone.getDefault())).getYear() - 80) / 100 * 100) < n) {
                n2 += 100;
            }
            if (n2 == 0) {
                DateTimeConverter.parseError("invalid year value");
            }
            if (n2 < 0) {
                ++n2;
            }
            dateTimeEngine2.setYear(n2);
            n4 = n3;
            DateTimeConverter.checkDelimiter(string, n4++, ' ');
            int n6 = 0;
            block9: for (n = 0; n < 3; ++n) {
                n3 = DateTimeConverter.parseInt(string, n4, nArray);
                if (n3 - n4 != 2) {
                    DateTimeConverter.syntaxError(n4);
                }
                int n7 = nArray[0];
                boolean bl = string.charAt(n3) == ':';
                switch (n) {
                    case 0: {
                        if (!bl) {
                            DateTimeConverter.syntaxError(n3);
                        }
                        dateTimeEngine2.setHours(n7);
                        n6 = n7;
                        break;
                    }
                    case 1: {
                        dateTimeEngine2.setMinutes(n7);
                        if (!bl) {
                            n4 = n3;
                            break block9;
                        }
                        ++n3;
                        break;
                    }
                    case 2: {
                        dateTimeEngine2.setSeconds(n7);
                    }
                }
                n4 = ++n3;
            }
            DateTimeConverter.checkDelimiter(string, n4++, ' ');
            boolean[] blArray = new boolean[]{false};
            String string2 = DateTimeConverter.parseRFC822Zone(string, n4, blArray);
            if (string2 == null) {
                throw new IllegalArgumentException("invalid time zone");
            }
            TimeZone timeZone = TimeZone.getTimeZone(string2);
            dateTimeEngine2.setZone(timeZone);
            if (!dateTimeEngine2.validate()) {
                DateTimeConverter.parseError("invalid date-time");
            }
            boolean bl = blArray[0];
            dateTimeEngine2.setDaylightTime(bl);
            long l = dateTimeEngine2.getInstant();
            if (dateTimeEngine2.getDaylightSaving() > 0 != bl) {
                String string3 = null;
                for (String[] stringArray : RFC822ZONE_IDS) {
                    if (!string2.equals(stringArray[0])) continue;
                    string3 = stringArray[bl ? 2 : 1];
                }
                if (string3 == null) {
                    DateTimeConverter.parseError("invalid local time");
                }
                timeZone = TimeZone.getTimeZone(string3);
                if (n6 == dateTimeEngine2.getHours()) {
                    l += (long)dateTimeEngine2.getDaylightSaving();
                }
                dateTimeEngine2 = DateTimeEngine.getInstance(l, timeZone);
            }
            if (n5 != 0 && dateTimeEngine2.getDayOfWeek() != n5) {
                DateTimeConverter.parseError("incorrect day of week");
            }
            dateTimeEngine2.resetNormalized();
            return dateTimeEngine2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean isRFC822ZoneName(String string, int n) {
        for (int i = 0; i < RFC822ZONE_OFFSETS.length; ++i) {
            if (n != RFC822ZONE_OFFSETS[i][0] || !string.equals(RFC822ZONE_NAMES[i][0])) continue;
            return true;
        }
        return false;
    }

    private static void appendRFC822ZoneName(StringBuilder stringBuilder, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        for (int i = 0; i < RFC822ZONE_OFFSETS.length; ++i) {
            if (n != RFC822ZONE_OFFSETS[i][n2]) continue;
            stringBuilder.append(RFC822ZONE_NAMES[i][n2]);
            return;
        }
        DateTimeConverter.appendRFC822ZoneNumeric(stringBuilder, n);
    }

    private static void appendRFC822ZoneNumeric(StringBuilder stringBuilder, int n) {
        char c = '+';
        if (n < 0) {
            n = -n;
            c = '-';
        }
        stringBuilder.append(c);
        CalendarUtils.sprintf0d(stringBuilder, (n /= 60000) / 60, 2);
        CalendarUtils.sprintf0d(stringBuilder, n % 60, 2);
    }

    private static String parseRFC822Zone(String string, int n, boolean[] blArray) {
        String string2 = null;
        char c = string.charAt(n);
        if (c == '+' || c == '-') {
            int[] nArray = new int[]{0};
            int n2 = DateTimeConverter.parseInt(string, ++n, nArray);
            int n3 = nArray[0];
            if (n2 - n != 4 || n2 != string.length() || n3 % 100 >= 60) {
                throw new IllegalArgumentException();
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("GMT").append(c);
                CalendarUtils.sprintf0d(stringBuilder, n3 / 100, 2).append(':');
                CalendarUtils.sprintf0d(stringBuilder, n3 % 100, 2);
                string2 = stringBuilder.toString();
            } else {
                string2 = "GMT";
            }
        } else {
            String string3 = string.substring(n);
            if (string3.length() == 1) {
                char c2;
                int n4 = 0;
                if (c >= 'A' && c < 'J') {
                    n4 = c - 65 + 1;
                    c2 = '-';
                } else if (c >= 'K' && c <= 'M') {
                    n4 = c - 65;
                    c2 = '-';
                } else if (c >= 'N' && c <= 'Y') {
                    n4 = c - 78 + 1;
                    c2 = '+';
                } else if (c == 'Z') {
                    c2 = '+';
                } else {
                    throw new IllegalArgumentException();
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("GMT").append(c2);
                CalendarUtils.sprintf0d(stringBuilder, n4, 2).append(":00");
                string2 = stringBuilder.toString();
            } else {
                int n5 = RFC822ZONE_NAMES.length;
                for (int i = 0; i < RFC822ZONE_NAMES.length; ++i) {
                    if (string3.equals(RFC822ZONE_NAMES[i][0])) {
                        string2 = RFC822ZONE_IDS[i][0];
                        break;
                    }
                    if (!string3.equals(RFC822ZONE_NAMES[i][1])) continue;
                    string2 = RFC822ZONE_IDS[i][0];
                    blArray[0] = true;
                    break;
                }
            }
        }
        return string2;
    }

    private static int parseInt(String string, int n, int[] nArray) {
        char c;
        int n2 = string.length();
        int n3 = 1;
        if (n < n2 && string.charAt(n) == '-') {
            n3 = -1;
            ++n;
        }
        int n4 = 0;
        while (n < n2 && (c = string.charAt(n)) >= '0' && c <= '9') {
            n4 = n4 * 10 + (c - 48);
            ++n;
        }
        nArray[0] = n4 * n3;
        return n;
    }

    private static void checkDelimiter(String string, int n, char c) {
        if (string.charAt(n) != c) {
            DateTimeConverter.syntaxError(n);
        }
    }

    private static void syntaxError(int n) {
        throw new IllegalArgumentException("syntax error at " + n);
    }

    private static void parseError(String string) {
        throw new IllegalArgumentException(string);
    }
}

