/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.BitSet;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence<T>
implements Sequence<T>,
Formattable {
    protected TypeInfo<T> ti;

    protected AbstractSequence(TypeInfo<T> typeInfo) {
        this.ti = typeInfo;
    }

    @Override
    public abstract int size();

    public boolean isNumeric() {
        return this.ti.isNumeric();
    }

    @Override
    public abstract T get(int var1);

    @Override
    public boolean getAsBoolean(int n) {
        return (Boolean)this.get(n);
    }

    @Override
    public char getAsChar(int n) {
        return ((Character)this.get(n)).charValue();
    }

    @Override
    public byte getAsByte(int n) {
        return ((Number)this.get(n)).byteValue();
    }

    @Override
    public short getAsShort(int n) {
        return ((Number)this.get(n)).shortValue();
    }

    @Override
    public int getAsInt(int n) {
        return ((Number)this.get(n)).intValue();
    }

    @Override
    public long getAsLong(int n) {
        return ((Number)this.get(n)).longValue();
    }

    @Override
    public float getAsFloat(int n) {
        return ((Number)this.get(n)).floatValue();
    }

    @Override
    public double getAsDouble(int n) {
        return ((Number)this.get(n)).doubleValue();
    }

    @Override
    public Sequence<T> getSlice(int n, int n2) {
        return Sequences.subsequence(this, n, n2);
    }

    @Override
    public BitSet getBits(SequencePredicate<? super T> sequencePredicate) {
        int n = this.size();
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (!sequencePredicate.matches(this, i, this.get(i))) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    @Override
    public TypeInfo<T> getElementType() {
        return this.ti;
    }

    @Override
    public T getDefaultValue() {
        return this.ti.defaultValue;
    }

    @Override
    public Sequence<T> getEmptySequence() {
        return this.ti.emptySequence;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void toArray(Object[] objectArray, int n) {
        this.toArray(0, this.size(), objectArray, n);
    }

    @Override
    public void toArray(int n, int n2, Object[] objectArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            objectArray[i + n3] = this.get(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            nArray[i + n3] = this.getAsInt(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, double[] dArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            dArray[i + n3] = this.getAsDouble(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, float[] fArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            fArray[i + n3] = this.getAsFloat(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, short[] sArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            sArray[i + n3] = this.getAsShort(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, char[] cArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            cArray[i + n3] = this.getAsChar(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, long[] lArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            lArray[i + n3] = this.getAsLong(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, boolean[] blArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            blArray[i + n3] = this.getAsBoolean(i + n);
        }
    }

    @Override
    public void toArray(int n, int n2, byte[] byArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            byArray[i + n3] = this.getAsByte(i + n);
        }
    }

    @Override
    public Sequence<T> get(SequencePredicate<? super T> sequencePredicate) {
        return Sequences.filter(this, this.getBits(sequencePredicate));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(0, this.size() - 1);
    }

    @Override
    public final Iterator<T> iterator(final int n, final int n2) {
        return new Iterator<T>(){
            private int cur;
            private final int last;
            {
                this.cur = Math.min(Math.max(0, n), AbstractSequence.this.size());
                this.last = Math.min(Math.max(this.cur, n2 + 1), AbstractSequence.this.size());
            }

            @Override
            public boolean hasNext() {
                return this.cur < this.last;
            }

            @Override
            public T next() {
                if (this.cur >= this.last) {
                    throw new NoSuchElementException();
                }
                return AbstractSequence.this.get(this.cur++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object object) {
        return object instanceof Sequence && Sequences.isEqual(this, (Sequence)object);
    }

    public int hashCode() {
        int n = 0;
        for (T t : this) {
            n = 31 * n + (t != null ? t.hashCode() : 0);
        }
        return n;
    }

    @Override
    public void incrementSharing() {
    }

    @Override
    public void decrementSharing() {
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[ ]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        for (T t : this) {
            stringBuilder.append(t);
            stringBuilder.append(", ");
        }
        int n = stringBuilder.length();
        if (n > 1) {
            stringBuilder.delete(n - 2, n);
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        for (T t : this) {
            formatter.format("%s", t);
        }
    }
}

