/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArraySequence
extends ArraySequence<Byte> {
    byte[] array;

    public ByteArraySequence(int n, TypeInfo<Byte> typeInfo) {
        super(typeInfo);
        this.array = new byte[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public ByteArraySequence(int n) {
        this(n, TypeInfo.Byte);
    }

    public ByteArraySequence() {
        this(16, TypeInfo.Byte);
    }

    public ByteArraySequence(TypeInfo<Byte> typeInfo, byte ... byArray) {
        this(typeInfo, byArray, false);
    }

    public ByteArraySequence(TypeInfo<Byte> typeInfo, byte[] byArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = byArray;
        } else {
            this.array = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.array, 0, byArray.length);
        }
        this.gapStart = this.gapEnd = byArray.length;
    }

    public ByteArraySequence(byte[] byArray, int n, int n2) {
        super(TypeInfo.Byte);
        this.array = new byte[n2];
        System.arraycopy(byArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public ByteArraySequence(Sequence<? extends Byte> sequence) {
        super(TypeInfo.Byte);
        int n = sequence.size();
        this.array = new byte[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new byte[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (byte[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Byte getRawArrayElementAsObject(int n) {
        return this.array[n];
    }

    public ByteArraySequence makeNew(int n) {
        return new ByteArraySequence(n, this.getElementType());
    }

    @Override
    public byte getAsByte(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return 0;
        }
        return this.array[n];
    }

    public void add(byte by) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = by;
    }

    @Override
    public void add(Sequence<? extends Byte> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, byte[] byArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, byArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, byArray, n3, n2);
    }

    @Override
    protected ByteArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        ByteArraySequence byteArraySequence = new ByteArraySequence(n3, this.getElementType());
        byteArraySequence.addFromArray(this.array, 0, n);
        byteArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return byteArraySequence;
    }

    public void replace(int n, byte by) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = by;
    }

    public void replace(int n, int n2, byte by, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, by);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = by;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Byte> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static byte extractOldElement(ArraySequence<Byte> arraySequence, Sequence<? extends Byte> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3);
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3);
            }
        }
        return (Byte)arraySequence.getDefaultValue();
    }

    public static byte extractNewElement(ArraySequence<Byte> arraySequence, int n, Sequence<? extends Byte> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2);
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2);
        }
        return (Byte)arraySequence.getDefaultValue();
    }
}

