/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumbMutableSequence<T>
implements Iterable<T> {
    private T[] array;
    private int size;

    public DumbMutableSequence(T[] TArray) {
        this(TArray.length);
        System.arraycopy(TArray, 0, this.array, 0, TArray.length);
        this.size = TArray.length;
    }

    public DumbMutableSequence(int n) {
        this.array = Util.newObjectArray(Util.powerOfTwo(1, n));
        this.size = 0;
    }

    public DumbMutableSequence() {
        this(8);
    }

    public T get(int n) {
        return n < 0 || n >= this.size ? null : (T)this.array[n];
    }

    public void set(int n, T t) {
        if (n < 0 && n > this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (n == this.size && this.size + 1 < this.array.length) {
            T[] TArray = Util.newObjectArray(Util.powerOfTwo(this.size, this.size + 1));
            System.arraycopy(this.array, 0, TArray, 0, this.size);
            this.array[this.size++] = t;
        } else {
            this.array[n] = t;
        }
    }

    public void replaceSlice(int n, int n2, T[] TArray) {
        int n3 = TArray.length;
        int n4 = n2 - n;
        int n5 = n3 - n4;
        if (n5 == 0) {
            System.arraycopy(TArray, 0, this.array, n, n3);
        } else if (this.size + n5 < this.array.length) {
            System.arraycopy(this.array, n2, this.array, n2 + n5, this.size - n2);
            System.arraycopy(TArray, 0, this.array, n, n3);
            if (n5 < 0) {
                Arrays.fill(this.array, this.size + n5, this.size, null);
            }
            this.size += n5;
        } else {
            int n6 = this.size + n5;
            T[] TArray2 = Util.newObjectArray(Util.powerOfTwo(this.size, n6));
            System.arraycopy(this.array, 0, TArray2, 0, n);
            System.arraycopy(TArray, 0, TArray2, n, n3);
            System.arraycopy(this.array, n2, TArray2, n + n3, this.size - n2);
            this.array = TArray2;
            this.size = n6;
        }
    }

    public Sequence<? extends T> replaceSlice(int n, int n2, Sequence<? extends T> sequence) {
        int n3 = Sequences.size(sequence);
        Object[] objectArray = Util.newObjectArray(n3);
        sequence.toArray(0, n3, objectArray, 0);
        this.replaceSlice(n, n2, objectArray);
        return sequence;
    }

    public Sequence<T> get(Class<T> clazz) {
        return Sequences.make(TypeInfo.getTypeInfo(clazz), this.array, this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DumbMutableSequence.this.size;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return DumbMutableSequence.this.array[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void testValid() {
        int n;
        for (n = 0; n < this.size; ++n) {
            if (this.array[n] == null) {
                throw new AssertionError((Object)("Null element at " + n));
            }
        }
        for (n = this.size; n < this.array.length; ++n) {
            if (this.array[n] != null) {
                throw new AssertionError((Object)("Non-null element at " + n));
            }
        }
    }
}

