/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArraySequence
extends ArraySequence<Integer> {
    int[] array;

    public IntArraySequence(int n, TypeInfo<Integer> typeInfo) {
        super(typeInfo);
        this.array = new int[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public IntArraySequence(int n) {
        this(n, TypeInfo.Integer);
    }

    public IntArraySequence() {
        this(16, TypeInfo.Integer);
    }

    public IntArraySequence(TypeInfo<Integer> typeInfo, int ... nArray) {
        this(typeInfo, nArray, false);
    }

    public IntArraySequence(TypeInfo<Integer> typeInfo, int[] nArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = nArray;
        } else {
            this.array = new int[nArray.length];
            System.arraycopy(nArray, 0, this.array, 0, nArray.length);
        }
        this.gapStart = this.gapEnd = nArray.length;
    }

    public IntArraySequence(int[] nArray, int n, int n2) {
        super(TypeInfo.Integer);
        this.array = new int[n2];
        System.arraycopy(nArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public IntArraySequence(Sequence<? extends Integer> sequence) {
        super(TypeInfo.Integer);
        int n = sequence.size();
        this.array = new int[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new int[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (int[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Integer getRawArrayElementAsObject(int n) {
        return this.array[n];
    }

    public IntArraySequence makeNew(int n) {
        return new IntArraySequence(n, this.getElementType());
    }

    @Override
    public int getAsInt(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return 0;
        }
        return this.array[n];
    }

    public void add(int n) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = n;
    }

    @Override
    public void add(Sequence<? extends Integer> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, int[] nArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, nArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, nArray, n3, n2);
    }

    @Override
    protected IntArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        IntArraySequence intArraySequence = new IntArraySequence(n3, this.getElementType());
        intArraySequence.addFromArray(this.array, 0, n);
        intArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return intArraySequence;
    }

    public void replace(int n, int n2) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = n2;
    }

    public void replace(int n, int n2, int n3, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, n3);
            return;
        }
        int n4 = this.size();
        int n5 = n2 - n;
        this.gapReserve(n, n5 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n4 + n5;
        this.array[n++] = n3;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Integer> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static int extractOldElement(ArraySequence<Integer> arraySequence, Sequence<? extends Integer> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3);
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3);
            }
        }
        return (Integer)arraySequence.getDefaultValue();
    }

    public static int extractNewElement(ArraySequence<Integer> arraySequence, int n, Sequence<? extends Integer> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2);
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2);
        }
        return (Integer)arraySequence.getDefaultValue();
    }
}

