/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntRangeSequence
extends AbstractSequence<Integer>
implements Sequence<Integer> {
    private final int start;
    private final int step;
    private final int size;

    public IntRangeSequence(int n, int n2, int n3, boolean bl) {
        super(TypeInfo.Integer);
        if (n3 == 0) {
            throw new IllegalArgumentException("Range step of zero");
        }
        this.start = n;
        this.step = n3;
        this.size = Sequences.calculateIntRangeSize(n, n2, n3, bl);
    }

    public IntRangeSequence(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public IntRangeSequence(int n, int n2) {
        this(n, n2, 1, false);
    }

    public IntRangeSequence(int n, int n2, boolean bl) {
        this(n, n2, 1, bl);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getAsInt(int n) {
        if (n < 0 || n >= this.size) {
            return 0;
        }
        return this.start + n * this.step;
    }

    @Override
    public Integer get(int n) {
        if (n < 0 || n >= this.size) {
            return 0;
        }
        return this.start + n * this.step;
    }

    @Override
    public void toArray(int n, int n2, Object[] objectArray, int n3) {
        if (n < 0 || n2 > 0 && n + n2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = this.start + n * this.step;
        for (int i = n3; i < n3 + n2; ++i) {
            objectArray[i] = n4;
            n4 += this.step;
        }
    }
}

