/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArraySequence<T>
extends ArraySequence<T>
implements Sequence<T> {
    T[] array;

    public ObjectArraySequence(int n, TypeInfo<T> typeInfo) {
        super(typeInfo);
        this.array = Util.newObjectArray(n);
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public ObjectArraySequence(TypeInfo<T> typeInfo) {
        this(16, typeInfo);
    }

    public ObjectArraySequence(TypeInfo<T> typeInfo, T ... TArray) {
        this(typeInfo, TArray, false);
    }

    public ObjectArraySequence(TypeInfo<T> typeInfo, T[] TArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = TArray;
        } else {
            this.array = Util.newObjectArray(TArray.length);
            System.arraycopy(TArray, 0, this.array, 0, TArray.length);
        }
        this.gapStart = this.gapEnd = TArray.length;
        this.checkForNulls();
    }

    public ObjectArraySequence(TypeInfo<T> typeInfo, T[] TArray, int n, int n2) {
        super(typeInfo);
        this.array = Util.newObjectArray(n2);
        System.arraycopy(TArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
        this.checkForNulls();
    }

    public ObjectArraySequence(TypeInfo<T> typeInfo, List<? extends T> list) {
        super(typeInfo);
        this.array = list.toArray();
        this.gapStart = this.gapEnd = this.array.length;
        this.checkForNulls();
    }

    public ObjectArraySequence(TypeInfo<T> typeInfo, Sequence<? extends T> sequence) {
        super(typeInfo);
        int n = sequence.size();
        this.array = Util.newObjectArray(n);
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    private void checkForNulls() {
        int n = this.gapStart;
        for (int i = 0; i != n || n == this.gapStart && (i = this.gapEnd) != (n = this.array.length); ++i) {
            if (this.array[i] != null) continue;
            throw new IllegalArgumentException("cannot create sequence with null values");
        }
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return Util.newObjectArray(n);
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (Object[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected T getRawArrayElementAsObject(int n) {
        return this.array[n];
    }

    @Override
    protected ObjectArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        ObjectArraySequence objectArraySequence = new ObjectArraySequence(n3, this.getElementType());
        objectArraySequence.addFromArray(this.array, 0, n);
        objectArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return objectArraySequence;
    }

    @Override
    public T get(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return this.getDefaultValue();
        }
        return this.array[n];
    }

    @Override
    public BitSet getBits(SequencePredicate<? super T> sequencePredicate) {
        int n = this.size();
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            if (n2 >= this.gapStart) {
                n2 += this.gapEnd - this.gapStart;
            }
            if (!sequencePredicate.matches(this, i, this.array[n2])) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    @Override
    public void toArray(int n, int n2, Object[] objectArray, int n3) {
        if (n < 0 || n2 < 0 || n + n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, objectArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, objectArray, n3, n2);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                if (this.index == ObjectArraySequence.this.gapStart) {
                    this.index = ObjectArraySequence.this.gapEnd;
                }
                return this.index < ObjectArraySequence.this.array.length;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return ObjectArraySequence.this.array[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void add(T t) {
        if (t != null) {
            this.gapReserve(this.size(), 1);
            this.array[this.gapStart++] = t;
        }
    }

    @Override
    public void add(Sequence<? extends T> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    public void add(T[] TArray, int n, int n2) {
        this.addFromArray(TArray, n, n2);
    }

    public void replace(int n, T t) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = t;
    }

    public void replace(int n, int n2, T t, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, t);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = t;
        this.gapStart = n;
        if (!bl) {
            this.clearOldValues(n4);
        }
    }

    @Override
    protected void replaceRaw(Sequence<? extends T> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    protected <T> void insert(Sequence<? extends T> sequence, int n, int n2) {
        this.gapReserve(n2, n);
        sequence.toArray(this.array, n2);
        this.gapStart += n;
    }

    @Override
    public void clearOldValues(int n) {
        for (int i = this.gapEnd - n; i < this.gapEnd; ++i) {
            this.array[i] = null;
        }
    }
}

