/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.util;

import com.sun.javafx.runtime.util.backport.ResourceBundle;
import com.sun.javafx.runtime.util.backport.ResourceBundleEnumeration;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FXPropertyResourceBundle
extends ResourceBundle {
    private static final String CHARTAG = "@charset \"";
    private static final List<String> FORMAT_FXPROPERTIES = Collections.unmodifiableList(Arrays.asList("javafx.properties"));
    private ConcurrentMap<String, Object> lookup = new ConcurrentHashMap<String, Object>();
    private static Logger logger = null;
    private static final int CRETURN = 13;
    private static final int NEWLINE = 10;
    private static final int FSLASH = 47;
    private static final int DQUOTE = 34;
    private static final int SQUOTE = 39;
    private static final int EQUAL = 61;
    private static final int BSLASH = 92;
    private static final int SUBST = 65533;
    private static final int BOM = 65279;
    private static final Locale ROOTLOCALE = new Locale("");

    public FXPropertyResourceBundle(InputStream inputStream, String string) throws IOException {
        this(FXPropertyResourceBundle.getReader(inputStream), string);
    }

    public FXPropertyResourceBundle(Reader reader, String string) throws IOException {
        this.initialize(reader, string);
    }

    @Override
    public boolean containsKey(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return true;
    }

    @Override
    protected Object handleGetObject(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.lookup.get(string);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle resourceBundle = this.parent;
        return new ResourceBundleEnumeration(this.lookup.keySet(), resourceBundle != null ? resourceBundle.getKeys() : null);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.lookup.keySet();
    }

    private void initialize(Reader reader, String string) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        int n2 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        block13: while ((n = this.getCodePoint(bufferedReader)) != -1) {
            switch (n) {
                case 13: {
                    bufferedReader.mark(8);
                    if (this.getCodePoint(bufferedReader) != 10) {
                        bufferedReader.reset();
                    }
                }
                case 10: {
                    ++n2;
                    if (n3 == 0) continue block13;
                    stringBuilder.appendCodePoint(10);
                    continue block13;
                }
                case 47: {
                    if (n3 != 0) {
                        stringBuilder.appendCodePoint(n);
                        continue block13;
                    }
                    n2 += this.skipComments(bufferedReader, string);
                    continue block13;
                }
                case 34: 
                case 39: {
                    if (n3 == 0) {
                        if (string2 == null && bl || string2 != null && !bl) {
                            FXPropertyResourceBundle.logPropertySyntaxError(n, n2, string);
                            continue block13;
                        }
                        n3 = n;
                        continue block13;
                    }
                    if (n != 39 && n != 34) {
                        stringBuilder.appendCodePoint(n);
                        continue block13;
                    }
                    if (n3 != n) {
                        stringBuilder.appendCodePoint(n);
                        continue block13;
                    }
                    n3 = 0;
                    if (!bl && string2 == null) {
                        try {
                            string2 = FXPropertyResourceBundle.convertEscapes(stringBuilder.toString());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            FXPropertyResourceBundle.logPropertySyntaxError(illegalArgumentException.getMessage(), n2, string);
                        }
                        stringBuilder.setLength(0);
                        continue block13;
                    }
                    if (bl && string2 != null) {
                        try {
                            this.lookup.put(string2, FXPropertyResourceBundle.convertEscapes(stringBuilder.toString()));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            FXPropertyResourceBundle.logPropertySyntaxError(illegalArgumentException.getMessage(), n2, string);
                        }
                        stringBuilder.setLength(0);
                        string2 = null;
                        bl = false;
                        continue block13;
                    }
                    FXPropertyResourceBundle.logPropertySyntaxError(n, n2, string);
                    continue block13;
                }
                case 61: {
                    if (n3 != 0) {
                        stringBuilder.appendCodePoint(n);
                        continue block13;
                    }
                    if (bl) {
                        FXPropertyResourceBundle.logPropertySyntaxError(n, n2, string);
                        continue block13;
                    }
                    if (string2 == null) {
                        FXPropertyResourceBundle.logPropertySyntaxError(n, n2, string);
                        continue block13;
                    }
                    bl = true;
                    continue block13;
                }
                case 92: {
                    if (n3 != 0) {
                        stringBuilder.appendCodePoint(n);
                        stringBuilder.appendCodePoint(this.getCodePoint(bufferedReader));
                        continue block13;
                    }
                    FXPropertyResourceBundle.logPropertySyntaxError(n, n2, string);
                    continue block13;
                }
                case 65279: {
                    if (bl2) {
                        bl2 = false;
                        continue block13;
                    }
                    FXPropertyResourceBundle.logPropertySyntaxError(n, n2, string);
                    continue block13;
                }
            }
            if (n3 != 0) {
                stringBuilder.appendCodePoint(n);
                continue;
            }
            if (Character.isWhitespace(n) || n == 65533) continue;
            FXPropertyResourceBundle.logPropertySyntaxError(n, n2, string);
        }
        bufferedReader.close();
    }

    private int getCodePoint(BufferedReader bufferedReader) throws IOException {
        int n = bufferedReader.read();
        if (Character.isHighSurrogate((char)n)) {
            return Character.toCodePoint((char)n, (char)bufferedReader.read());
        }
        return n;
    }

    private int skipComments(BufferedReader bufferedReader, String string) throws IOException {
        int n = 0;
        block0 : switch ((char)this.getCodePoint(bufferedReader)) {
            case '*': {
                while (true) {
                    int n2;
                    if ((char)(n2 = this.getCodePoint(bufferedReader)) == '\n') {
                        ++n;
                        continue;
                    }
                    if ((char)n2 == '*') {
                        if ((char)this.getCodePoint(bufferedReader) != '/') continue;
                        break block0;
                    }
                    if (n2 == -1) break;
                }
                FXPropertyResourceBundle.log(Level.WARNING, "non-closing comment at the end of " + string);
                break;
            }
            case '/': {
                int n3;
                do {
                    if ((char)(n3 = this.getCodePoint(bufferedReader)) != '\n') continue;
                    ++n;
                    break block0;
                } while (n3 != -1);
                break;
            }
        }
        return n;
    }

    private static String convertEscapes(String string) {
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n != 0) {
            stringBuilder.append(string, 0, n);
        }
        int n2 = string.length();
        try {
            while (n < n2) {
                int n3;
                if ((n3 = string.charAt(n++)) != 92) {
                    stringBuilder.append((char)n3);
                    continue;
                }
                int n4 = n - 1;
                n3 = string.charAt(n++);
                int n5 = -1;
                switch (n3) {
                    case 117: {
                        int n6;
                        n5 = 0;
                        for (n6 = 0; n6 < 4; ++n6) {
                            if (!(48 <= (n3 = string.charAt(n++)) && n3 <= 57 || 97 <= n3 && n3 <= 102 || 65 <= n3 && n3 <= 70)) {
                                throw new IllegalArgumentException("illegal escape sequence '" + string.substring(n4, n) + "'");
                            }
                            n5 = (n5 << 4) + Character.digit((char)n3, 16);
                        }
                        break;
                    }
                    case 98: {
                        n5 = 8;
                        break;
                    }
                    case 116: {
                        n5 = 9;
                        break;
                    }
                    case 110: {
                        n5 = 10;
                        break;
                    }
                    case 102: {
                        n5 = 12;
                        break;
                    }
                    case 114: {
                        n5 = 13;
                        break;
                    }
                    case 34: {
                        n5 = 34;
                        break;
                    }
                    case 39: {
                        n5 = 39;
                        break;
                    }
                    case 92: {
                        n5 = n3;
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        n5 = Character.digit((char)n3, 8);
                        int n6 = n3;
                        if (n >= n2 || 48 > (n3 = string.charAt(n)) || n3 > 55) break;
                        n5 = (n5 << 3) + Character.digit((char)n3, 8);
                        if (++n >= n2) break;
                        n3 = string.charAt(n);
                        if (n6 > 51 || 48 > n3 || n3 > 55) break;
                        n5 = (n5 << 3) + Character.digit((char)n3, 8);
                        ++n;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal escape sequence '" + string.substring(n4, n) + "'");
                    }
                }
                if (n5 == -1) continue;
                stringBuilder.append((char)n5);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("illegal escape sequence: " + string);
        }
        return stringBuilder.toString();
    }

    private static Reader getReader(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream;
        Charset charset;
        block10: {
            charset = null;
            bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(256);
            byte[] byArray = new byte[CHARTAG.length()];
            if (bufferedInputStream.read(byArray, 0, CHARTAG.length()) == byArray.length) {
                String string = new String(byArray, "UTF-8");
                if (string.equals(CHARTAG)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    while (true) {
                        byte by;
                        if ((by = (byte)bufferedInputStream.read()) == 13 || by == 10) {
                            if (!bl) {
                                FXPropertyResourceBundle.log(Level.WARNING, "Incorrect format in @charset tag");
                            }
                            break block10;
                        }
                        if (by != 34) {
                            stringBuilder.append((char)by);
                            continue;
                        }
                        bl = true;
                        if ((char)bufferedInputStream.read() == ';') {
                            try {
                                charset = Charset.forName(stringBuilder.toString());
                            }
                            catch (Exception exception) {
                                FXPropertyResourceBundle.log(Level.WARNING, "charset '" + stringBuilder.toString() + "' was not available");
                            }
                            continue;
                        }
                        FXPropertyResourceBundle.log(Level.WARNING, "Incorrect format in @charset tag");
                    }
                }
                bufferedInputStream.reset();
            }
        }
        if (charset == null) {
            charset = Charset.forName("UTF-8");
        }
        return new InputStreamReader((InputStream)bufferedInputStream, charset);
    }

    private static void logPropertySyntaxError(int n, int n2, String string) {
        FXPropertyResourceBundle.logPropertySyntaxError(String.format("'%c' (U+%04X) is incorrectly placed", n, n), n2, string);
    }

    private static void logPropertySyntaxError(String string, int n, String string2) {
        FXPropertyResourceBundle.logPropertySyntaxError(String.format("%s in line %d of %s", string, n, string2));
    }

    private static void logPropertySyntaxError(String string) {
        FXPropertyResourceBundle.log(Level.WARNING, string);
        throw new IllegalArgumentException(string);
    }

    private static void log(Level level, String string) {
        if (logger == null) {
            logger = Logger.getLogger("com.sun.javafx.runtime.util.FXPropertyResourceBundle");
        }
        logger.log(level, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FXPropertiesControl
    extends ResourceBundle.Control {
        static final FXPropertiesControl INSTANCE = new FXPropertiesControl();

        private FXPropertiesControl() {
        }

        @Override
        public List<String> getFormats(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return FORMAT_FXPROPERTIES;
        }

        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            if (string == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            if (locale.equals(ROOTLOCALE)) {
                return FxEchoBackResourceBundle.INSTANCE;
            }
            String string3 = this.toBundleName(string, locale);
            FXPropertyResourceBundle fXPropertyResourceBundle = null;
            final String string4 = this.toResourceName(string3, "fxproperties");
            final ClassLoader classLoader2 = classLoader;
            final boolean bl2 = bl;
            InputStream inputStream = null;
            try {
                inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        InputStream inputStream = null;
                        if (bl2) {
                            URLConnection uRLConnection;
                            URL uRL = classLoader2.getResource(string4);
                            if (uRL != null && (uRLConnection = uRL.openConnection()) != null) {
                                uRLConnection.setUseCaches(false);
                                inputStream = uRLConnection.getInputStream();
                            }
                        } else {
                            inputStream = classLoader2.getResourceAsStream(string4);
                        }
                        return inputStream;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            if (inputStream != null) {
                try {
                    fXPropertyResourceBundle = new FXPropertyResourceBundle(inputStream, string4);
                }
                finally {
                    inputStream.close();
                }
            }
            return fXPropertyResourceBundle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FxEchoBackResourceBundle
    extends ResourceBundle {
        private static final Set<String> keyset = new HashSet<String>();
        static final FxEchoBackResourceBundle INSTANCE = new FxEchoBackResourceBundle();

        private FxEchoBackResourceBundle() {
        }

        @Override
        public boolean containsKey(String string) {
            return true;
        }

        @Override
        protected Object handleGetObject(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return string;
        }

        @Override
        public Enumeration<String> getKeys() {
            return new ResourceBundleEnumeration(keyset, null);
        }

        @Override
        protected Set<String> handleKeySet() {
            return keyset;
        }
    }
}

