/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.util;

import com.sun.javafx.runtime.util.ClassContext;
import com.sun.javafx.runtime.util.FXFormatter;
import com.sun.javafx.runtime.util.FXPropertyResourceBundle;
import com.sun.javafx.runtime.util.backport.ResourceBundle;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLocalization {
    private static final Map<ThreadGroup, Map<String, String>> map = Collections.synchronizedMap(new WeakHashMap());
    private static ClassContext classContext = null;
    private static final String PKGNAME = StringLocalization.class.getPackage().getName();

    public static String getLocalizedString(String string, String string2, String string3, Object ... objectArray) {
        String string4 = string.replaceAll("/", "\\.");
        int n = string4.lastIndexOf(46);
        string4 = n != -1 ? string4.substring(0, n) + "/" + string4.substring(n + 1) : "/" + string4;
        return StringLocalization.getLocalizedString(StringLocalization.getPropertiesName(string4), string2, string3, Locale.getDefault(), objectArray);
    }

    public static String getLocalizedString(String string, String string2, String string3, Locale locale, Object ... objectArray) {
        String string4 = string3;
        ClassLoader classLoader = StringLocalization.getCallerLoader();
        if (classLoader == null) {
            return string3;
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader, FXPropertyResourceBundle.FXPropertiesControl.INSTANCE);
        if (string2 != null) {
            string4 = resourceBundle.getString(string2);
            if (string2.equals(string4) && !resourceBundle.keySet().contains(string2)) {
                string4 = string3;
            }
        } else {
            string4 = resourceBundle.getString(string3.replaceAll("\r\n|\r|\n", "\n"));
        }
        if (objectArray.length != 0) {
            string4 = FXFormatter.sprintf(locale, string4, objectArray);
        }
        return string4;
    }

    public static void associate(String string, String string2) {
        StringLocalization.getAssociation().put(string, string2);
    }

    public static void dissociate(String string) {
        Map<String, String> map = StringLocalization.getAssociation();
        map.remove(string);
        if (string.indexOf(47) == -1) {
            String string2 = string + "/";
            for (String string3 : map.keySet()) {
                if (!string3.startsWith(string2)) continue;
                map.remove(string3);
            }
        }
    }

    public static String getPropertiesName(String string) {
        String string2 = string.replaceAll("^/", "").replaceAll("/", ".");
        Map<String, String> map = StringLocalization.getAssociation();
        Pattern pattern = Pattern.compile("[\\./][^\\./]*\\z");
        while (true) {
            if (map.containsKey(string)) {
                string2 = map.get(string);
                break;
            }
            if ("".equals(string)) break;
            if (pattern.matcher(string).find()) {
                string = pattern.matcher(string).replaceAll("");
                continue;
            }
            string = "";
        }
        return string2;
    }

    private static Map<String, String> getAssociation() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Map<String, String> map = StringLocalization.map.get(threadGroup);
        if (map == null) {
            map = new ConcurrentHashMap<String, String>();
            StringLocalization.map.put(threadGroup, map);
        }
        return map;
    }

    private static ClassLoader getCallerLoader() {
        if (classContext != null) {
            Class[] classArray;
            for (Class clazz : classArray = classContext.getClassContext()) {
                if (clazz.getName().startsWith(PKGNAME)) continue;
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) {
                    return ClassLoader.getSystemClassLoader();
                }
                return classLoader;
            }
        }
        return null;
    }

    static {
        try {
            classContext = (ClassContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return new ClassContext();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }
}

