/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.paint;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class SplitImagePaint
implements Paint {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    public BufferedImage img;
    private PaintType type;
    private Insets sInsets;
    private Insets dInsets;
    private boolean inverse;

    public SplitImagePaint(BufferedImage bufferedImage, PaintType paintType, Insets insets, Insets insets2) {
        this.img = bufferedImage;
        this.type = paintType;
        this.sInsets = insets;
        this.dInsets = insets2;
    }

    public SplitImagePaint(BufferedImage bufferedImage, PaintType paintType, boolean bl, Size size, Size size2, Size size3, Size size4) {
        this.img = bufferedImage;
        this.type = paintType;
        this.inverse = bl;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = size != null ? size.getSize(n2) : 0;
        int n4 = size2 != null ? size2.getSize(n) : 0;
        int n5 = size3 != null ? size3.getSize(n2) : 0;
        int n6 = size4 != null ? size4.getSize(n) : 0;
        this.sInsets = this.dInsets = new Insets(n3, n4, n5, n6);
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.inverse) {
            int n = this.img.getWidth() - this.sInsets.left - this.sInsets.right;
            int n2 = this.img.getHeight() - this.sInsets.top - this.sInsets.bottom;
            int n3 = (int)((rectangle2D.getWidth() - (double)n) / 2.0);
            int n4 = (int)((rectangle2D.getHeight() - (double)n2) / 2.0);
            this.dInsets = new Insets(n4, n3, n4, n3);
        }
        return new SplitImagePaintContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    public int getTransparency() {
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PaintType {
        CENTER,
        STRETCH,
        TILE,
        PAINT9_STRETCH,
        PAINT9_TILE;

    }

    public static class Size {
        private int pxSize = 0;
        private double percentageSize = 0.0;
        private final boolean isPercentage;

        public Size(double d) {
            this.percentageSize = d;
            this.isPercentage = true;
        }

        public Size(int n) {
            this.pxSize = n;
            this.isPercentage = false;
        }

        private int getSize(int n) {
            if (this.isPercentage) {
                return (int)Math.round((double)n * this.percentageSize);
            }
            return this.pxSize;
        }
    }

    private class SplitImagePaintContext
    implements PaintContext {
        private Rectangle deviceBounds;
        private ColorModel cm;
        private Raster transformedRaster;

        public SplitImagePaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            this.deviceBounds = rectangle;
            BufferedImage bufferedImage = colorModel != null ? new BufferedImage(colorModel, WritableRaster.createWritableRaster(colorModel.createCompatibleSampleModel(rectangle.width, rectangle.height), new Point(0, 0)), false, null) : new BufferedImage(rectangle.width, rectangle.height, 1);
            this.cm = bufferedImage.getColorModel();
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.setColor(Color.PINK);
            graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics2D.translate(-rectangle.getX(), -rectangle.getY());
            graphics2D.transform(affineTransform);
            this.paint9(graphics2D, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            graphics2D.dispose();
            this.transformedRaster = bufferedImage.getRaster();
        }

        public void dispose() {
            this.transformedRaster = null;
        }

        public ColorModel getColorModel() {
            return this.cm;
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            return this.transformedRaster.createChild(n - this.deviceBounds.x, n2 - this.deviceBounds.y, n3, n4, 0, 0, null);
        }

        protected void paint9(Graphics graphics, int n, int n2, int n3, int n4) {
            if (SplitImagePaint.this.sInsets == null) {
                SplitImagePaint.this.sInsets = EMPTY_INSETS;
            }
            if (SplitImagePaint.this.dInsets == null) {
                SplitImagePaint.this.dInsets = EMPTY_INSETS;
            }
            int n5 = SplitImagePaint.this.img.getWidth(null);
            int n6 = SplitImagePaint.this.img.getHeight(null);
            if (SplitImagePaint.this.type == PaintType.CENTER) {
                graphics.drawImage(SplitImagePaint.this.img, n + (n3 - n5) / 2, n2 + (n4 - n6) / 2, null);
            } else if (SplitImagePaint.this.type == PaintType.TILE) {
                int n7 = 0;
                int n8 = n2 + n4;
                for (int i = n2; i < n8; i += n6 - n7) {
                    int n9 = 0;
                    int n10 = n + n3;
                    for (int j = n; j < n10; j += n5 - n9) {
                        int n11 = Math.min(n10, j + n5 - n9);
                        int n12 = Math.min(n8, i + n6 - n7);
                        graphics.drawImage(SplitImagePaint.this.img, j, i, n11, n12, n9, n7, n9 + n11 - j, n7 + n12 - i, null);
                        n9 = 0;
                    }
                    n7 = 0;
                }
            } else {
                boolean bl;
                int n13 = ((SplitImagePaint)SplitImagePaint.this).sInsets.top;
                int n14 = ((SplitImagePaint)SplitImagePaint.this).sInsets.left;
                int n15 = ((SplitImagePaint)SplitImagePaint.this).sInsets.bottom;
                int n16 = ((SplitImagePaint)SplitImagePaint.this).sInsets.right;
                int n17 = ((SplitImagePaint)SplitImagePaint.this).dInsets.top;
                int n18 = ((SplitImagePaint)SplitImagePaint.this).dInsets.left;
                int n19 = ((SplitImagePaint)SplitImagePaint.this).dInsets.bottom;
                int n20 = ((SplitImagePaint)SplitImagePaint.this).dInsets.right;
                if (n13 + n15 > n6) {
                    n15 = n13 = Math.max(0, n6 / 2);
                    n17 = n13;
                    n19 = n13;
                }
                if (n14 + n16 > n5) {
                    n14 = n16 = Math.max(0, n5 / 2);
                    n20 = n16;
                    n18 = n16;
                }
                if (n17 + n19 > n4) {
                    n17 = n19 = Math.max(0, n4 / 2 - 1);
                }
                if (n18 + n20 > n3) {
                    n18 = n20 = Math.max(0, n3 / 2 - 1);
                }
                boolean bl2 = bl = SplitImagePaint.this.type == PaintType.PAINT9_STRETCH;
                if (SplitImagePaint.this.type != PaintType.STRETCH) {
                    this.drawChunk(SplitImagePaint.this.img, graphics, bl, n, n2 + n17, n + n18, n2 + n4 - n19, 0, n13, n14, n6 - n15, false);
                    this.drawImage(SplitImagePaint.this.img, graphics, n, n2, n + n18, n2 + n17, 0, 0, n14, n13);
                    this.drawChunk(SplitImagePaint.this.img, graphics, bl, n + n18, n2, n + n3 - n20, n2 + n17, n14, 0, n5 - n16, n13, true);
                    this.drawImage(SplitImagePaint.this.img, graphics, n + n3 - n20, n2, n + n3, n2 + n17, n5 - n16, 0, n5, n13);
                    this.drawChunk(SplitImagePaint.this.img, graphics, bl, n + n3 - n20, n2 + n17, n + n3, n2 + n4 - n19, n5 - n16, n13, n5, n6 - n15, false);
                    this.drawImage(SplitImagePaint.this.img, graphics, n + n3 - n20, n2 + n4 - n19, n + n3, n2 + n4, n5 - n16, n6 - n15, n5, n6);
                    this.drawChunk(SplitImagePaint.this.img, graphics, bl, n + n18, n2 + n4 - n19, n + n3 - n20, n2 + n4, n14, n6 - n15, n5 - n16, n6, true);
                    this.drawImage(SplitImagePaint.this.img, graphics, n, n2 + n4 - n19, n + n18, n2 + n4, 0, n6 - n15, n14, n6);
                }
                this.drawImage(SplitImagePaint.this.img, graphics, n + n18, n2 + n17, n + n3 - n20, n2 + n4 - n19, n14, n13, n5 - n16, n6 - n15);
            }
        }

        private void drawImage(Image image, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            if (n3 - n <= 0 || n4 - n2 <= 0 || n7 - n5 <= 0 || n8 - n6 <= 0) {
                return;
            }
            graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
        }

        private void drawChunk(Image image, Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
            if (n3 - n <= 0 || n4 - n2 <= 0 || n7 - n5 <= 0 || n8 - n6 <= 0) {
                return;
            }
            if (bl) {
                graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
            } else {
                int n9;
                int n10;
                int n11 = n7 - n5;
                int n12 = n8 - n6;
                if (bl2) {
                    n10 = n11;
                    n9 = 0;
                } else {
                    n10 = 0;
                    n9 = n12;
                }
                while (n < n3 && n2 < n4) {
                    int n13 = Math.min(n3, n + n11);
                    int n14 = Math.min(n4, n2 + n12);
                    graphics.drawImage(image, n, n2, n13, n14, n5, n6, n5 + n13 - n, n6 + n14 - n2, null);
                    n += n10;
                    n2 += n9;
                }
            }
        }
    }
}

