/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.transfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTI {
    private static final List<UTI> utiList = new ArrayList<UTI>();
    private final String identifier;
    private final Set<UTI> conformsTo;
    private final Set<String> extensions;
    private final Set<String> mimeTypes;
    private final Set<String> osTypes;
    private final Set<String> nsPasteboardTypes;
    public static final UTI ITEM = new Builder("public.item").build();
    public static final UTI DATA = new Builder("public.data").conformsTo(ITEM).build();
    public static final UTI CONTENT = new Builder("public.content").build();
    public static final UTI TEXT = new Builder("public.text").conformsTo(CONTENT).conformsTo(DATA).build();
    public static final UTI TEXT_PLAIN = new Builder("public.plain-text").conformsTo(TEXT).extension(".txt").mimeType("text/plain").build();
    public static final UTI URL = new Builder("public.url").conformsTo(DATA).osType("url").build();
    public static final UTI IMAGE = new Builder("public.image").conformsTo(DATA).conformsTo(CONTENT).build();
    public static final UTI IMAGE_JPEG = new Builder("public.jpeg").conformsTo(IMAGE).osType("JPEG").extension(".jpg").extension(".jpeg").mimeType("image/jpeg").build();
    public static final UTI IMAGE_PNG = new Builder("public.png").conformsTo(IMAGE).osType("PNGf").extension(".png").mimeType("image/png").build();
    public static final UTI IMAGE_GIF = new Builder("com.compuserve.gif").conformsTo(IMAGE).osType("GIFf").extension(".gif").mimeType("image/gif").build();
    public static final UTI IMAGE_BMP = new Builder("com.microsoft.bmp").conformsTo(IMAGE).osType("BMP ").osType("BMPf").extension(".bmp").build();
    public static final UTI IMAGE_TIFF = Builder.access$400(Builder.access$400(new Builder("public.tiff").conformsTo(IMAGE).osType("TIFF").extension(".tif").extension(".tiff").mimeType("image/tiff"), "NeXT TIFF v4.0 pasteboard type"), "NSTIFFPBoardType").build();
    public static final UTI IMAGE_ICO = new Builder("com.microsoft.ico").conformsTo(IMAGE).extension(".ico").build();
    public static final UTI AUDIOVISUAL_CONTENT = new Builder("public.audiovisual-content").conformsTo(DATA).conformsTo(CONTENT).build();
    public static final UTI MOVIE = new Builder("public.movie").conformsTo(AUDIOVISUAL_CONTENT).build();
    public static final UTI MOVIE_VIDEO_ONLY = new Builder("public.video").conformsTo(MOVIE).build();
    public static final UTI MOVIE_AVI = new Builder("public.avi").conformsTo(MOVIE).osType("Vfw ").extension(".avi").extension(".vfw").mimeType("video/avi").mimeType("video/msvideo").mimeType("video/x-msvideo").build();
    public static final UTI MOVIE_QUICKTIME = new Builder("com.apple.quicktime-movie").conformsTo(MOVIE).osType("MooV").extension(".mov").extension(".qt").mimeType("video/quicktime").build();
    public static final UTI MOVIE_MPEG = new Builder("public.mpeg").conformsTo(MOVIE).osType("MPG").osType("MPEG").extension(".mpg").extension(".mpeg").extension(".m75").extension(".m15").mimeType("video/mpg").mimeType("video/mpeg").mimeType("video/x-mpg").mimeType("video/x-mpeg").build();
    public static final UTI MOVIE_MPEG_4 = new Builder("public.mpeg-4").conformsTo(MOVIE).osType("mpg4").extension(".mp4").extension(".m4v").mimeType("video/mp4").mimeType("video/mp4v").build();
    public static final UTI AUDIOVISUAL_CONTENT_ASF = new Builder("com.microsoft.advanced-systems-format").conformsTo(AUDIOVISUAL_CONTENT).osType("ASF_").extension(".asf").mimeType("video/x-ms-asf").build();
    public static final UTI MOVIE_WM = new Builder("com.microsoft.windows-media-wm").conformsTo(MOVIE).conformsTo(AUDIOVISUAL_CONTENT_ASF).extension(".wm").mimeType("video/x-ms-wm").build();
    public static final UTI MOVIE_WMV = new Builder("com.microsoft.windows-media-wmv").conformsTo(MOVIE).conformsTo(AUDIOVISUAL_CONTENT_ASF).extension(".wmv").mimeType("video/x-ms-wmv").build();
    public static final UTI MOVIE_WMP = new Builder("com.microsoft.windows-media-wmp").conformsTo(MOVIE).conformsTo(AUDIOVISUAL_CONTENT_ASF).extension(".wmp").mimeType("video/x-ms-wmp").build();
    public static final UTI MOVIE_FLV = new Builder("com.adobe.flash-video").conformsTo(MOVIE).extension(".flv").mimeType("video/x-flv").build();
    public static final UTI MOVIE_OGV = new Builder("org.xiph.ogg-video").conformsTo(MOVIE).extension(".ogv").mimeType("video/ogg").build();
    public static final UTI AUDIO = new Builder("public.audio").conformsTo(AUDIOVISUAL_CONTENT).build();
    public static final UTI AUDIO_MP3 = new Builder("public.mp3").conformsTo(AUDIO).osType("MPG3").osType("mpg3").osType("Mp3").osType("MP3").osType("mp3!").osType("MP3!").extension(".mp3").mimeType("audio/mpeg").mimeType("audio/mpeg3").mimeType("audio/mpg").mimeType("audio/mp3").mimeType("audio/x-mpeg").mimeType("audio/x-mpeg3").mimeType("audio/x-mpg").mimeType("audio/x-mp3").build();
    public static final UTI AUDIO_WAVE = new Builder("com.microsoft.waveform-audio").conformsTo(AUDIO).osType(".WAV").osType("WAVE").extension(".wav").extension(".wave").mimeType("audio/wav").mimeType("audio/wave").build();
    public static final UTI AUDIO_WMA = new Builder("com.microsoft.windows-media-wma").conformsTo(AUDIO).conformsTo(AUDIOVISUAL_CONTENT_ASF).extension(".wma").mimeType("video/x-ms-wma").build();
    public static final UTI AUDIO_AIFC = new Builder("public.aifc-audio").conformsTo(AUDIO).osType("AIFC").extension(".aifc").extension(".aiff").extension(".aif").mimeType("audio/aiff").mimeType("audio/x-aiff").build();
    public static final UTI AUDIO_AIFF = new Builder("public.aiff-audio").conformsTo(AUDIO).osType("AIFF").extension(".aiff").extension(".aif").mimeType("audio/aiff").mimeType("audio/x-aiff").build();
    public static final UTI AUDIO_ULAW = new Builder("public.ulaw-audio").conformsTo(AUDIO).osType("ULAW").extension(".au").extension(".ulw").extension(".snd").mimeType("audio/basic").mimeType("audio/au").mimeType("audio/snd").build();
    public static final UTI AUDIO_MIDI = new Builder("public.midi").conformsTo(AUDIO).extension(".midi").extension(".mid").extension(".smf").mimeType("audio/x-midi").mimeType("audio/midi").build();
    public static final UTI AUDIO_KARAOKE_MIDI = new Builder("public.karaoke-midi").conformsTo(AUDIO_MIDI).extension(".kar").mimeType("x-music/x-midi").mimeType("audio/mid").build();
    public static final UTI AUDIO_OGA = new Builder("org.xiph.ogg-audio").conformsTo(AUDIO).extension(".oga").mimeType("audio/ogg").build();
    public static final UTI DIRECTORY = new Builder("public.directory").conformsTo(ITEM).build();
    public static final UTI FOLDER = new Builder("public.folder").conformsTo(DIRECTORY).build();
    public static final UTI UNKNOWN = new Builder("unknown").build();
    public static final UTI JAVAFX_FXZ = new Builder("public.fxz").conformsTo(DATA).conformsTo(CONTENT).extension(".fxz").build();
    public static final UTI JAVA_FILE = new Builder("java.file").conformsTo(DATA).build();
    public static final UTI UNKNOWN_JAVA_FILE = new Builder("java.unknown-file").conformsTo(UNKNOWN).conformsTo(JAVA_FILE).build();
    public static final UTI JAVA_FILE_LIST = new Builder("java.file-list").conformsTo(DATA).build();

    private UTI(String string, Set<UTI> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5) {
        this.identifier = string;
        this.conformsTo = set;
        this.conformsTo.add(this);
        this.extensions = set2;
        this.mimeTypes = set3;
        this.osTypes = set4;
        this.nsPasteboardTypes = set5;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Iterable<UTI> getConformsTo() {
        return this.conformsTo;
    }

    public Iterable<String> getExtensions() {
        if (this.extensions == null) {
            return Collections.EMPTY_SET;
        }
        return this.extensions;
    }

    public Iterable<String> getMimeTypes() {
        if (this.mimeTypes == null) {
            return Collections.EMPTY_SET;
        }
        return this.mimeTypes;
    }

    public String toString() {
        return this.identifier;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof UTI)) {
            return false;
        }
        UTI uTI = (UTI)object;
        if (this.identifier.equals(uTI.identifier)) {
            return true;
        }
        if (this.identifier.startsWith("dyn")) {
            this.isSubset(this.extensions, uTI.extensions);
            this.isSubset(this.mimeTypes, uTI.mimeTypes);
            this.isSubset(this.osTypes, uTI.osTypes);
            this.isSubset(this.nsPasteboardTypes, uTI.nsPasteboardTypes);
        }
        return false;
    }

    private boolean isSubset(Set<String> set, Set<String> set2) {
        for (String string : set) {
            if (set2.contains(string)) continue;
            return false;
        }
        return true;
    }

    public boolean conformsTo(UTI uTI) {
        if (uTI == null) {
            return false;
        }
        if (this.equals(uTI)) {
            return true;
        }
        if (this.conformsTo != null) {
            for (UTI uTI2 : this.conformsTo) {
                if (uTI2 == this || !uTI2.conformsTo(uTI)) continue;
                return true;
            }
        }
        return false;
    }

    public static UTI lookupExtension(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (UTI uTI : utiList) {
            if (uTI.extensions == null) continue;
            for (String string2 : uTI.extensions) {
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                return uTI;
            }
        }
        return null;
    }

    public static UTI lookupMimeType(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (UTI uTI : utiList) {
            if (uTI.mimeTypes == null) continue;
            for (String string2 : uTI.mimeTypes) {
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                return uTI;
            }
        }
        return null;
    }

    public static UTI lookupOSType(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (UTI uTI : utiList) {
            if (uTI.osTypes == null) continue;
            for (String string2 : uTI.osTypes) {
                if (string2 == null || !string2.equals(string)) continue;
                return uTI;
            }
        }
        return null;
    }

    public static Iterable<UTI> lookupChildren(UTI uTI) {
        ArrayList<UTI> arrayList = new ArrayList<UTI>();
        if (uTI == null) {
            return arrayList;
        }
        for (UTI uTI2 : utiList) {
            if (uTI2 == null || uTI2.equals(uTI) || !uTI2.conformsTo(uTI)) continue;
            arrayList.add(uTI2);
        }
        return arrayList;
    }

    public static class Builder {
        private final String identifier;
        private Set<UTI> conformsTo;
        private Set<String> extensions;
        private Set<String> mimeTypes;
        private Set<String> osTypes;
        private Set<String> nsPasteboardTypes;

        public Builder(String string) throws IllegalArgumentException {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("UTI identifier can not be null or empty. Provided UTI identifier: " + string);
            }
            for (UTI uTI : utiList) {
                if (!uTI.identifier.equalsIgnoreCase(string)) continue;
                throw new IllegalArgumentException("UTI identifier can not be duplicated. '" + string + "' is already used as an UTI idenfitier");
            }
            this.conformsTo = new HashSet<UTI>();
            this.identifier = string;
        }

        public Builder conformsTo(UTI uTI) {
            if (uTI == null) {
                return this;
            }
            this.conformsTo.add(uTI);
            this.conformsTo.addAll(uTI.conformsTo);
            return this;
        }

        public Builder extension(String string) {
            if (string == null || string.length() == 0) {
                return this;
            }
            if (this.extensions == null) {
                this.extensions = new HashSet<String>();
            }
            this.extensions.add(string);
            return this;
        }

        public Builder mimeType(String string) {
            if (string == null || string.length() == 0) {
                return this;
            }
            if (this.mimeTypes == null) {
                this.mimeTypes = new HashSet<String>();
            }
            this.mimeTypes.add(string);
            return this;
        }

        public Builder osType(String string) {
            if (string == null || string.length() == 0) {
                return this;
            }
            String string2 = null;
            int n = string.length();
            if (n < 4) {
                switch (n) {
                    case 0: {
                        return this;
                    }
                    case 1: {
                        string2 = string + "   ";
                        break;
                    }
                    case 2: {
                        string2 = string + "  ";
                        break;
                    }
                    case 3: {
                        string2 = string + " ";
                    }
                }
            } else {
                string2 = n > 4 ? string.substring(0, 4) : string;
            }
            if (this.osTypes == null) {
                this.osTypes = new HashSet<String>();
            }
            this.osTypes.add(string2);
            return this;
        }

        private Builder nsPasteboardType(String string) {
            if (string == null || string.length() == 0) {
                return this;
            }
            if (this.nsPasteboardTypes == null) {
                this.nsPasteboardTypes = new HashSet<String>();
            }
            this.nsPasteboardTypes.add(string);
            return this;
        }

        public UTI build() {
            UTI uTI = new UTI(this.identifier, this.conformsTo, this.extensions, this.mimeTypes, this.osTypes, this.nsPasteboardTypes);
            utiList.add(uTI);
            return uTI;
        }

        static /* synthetic */ Builder access$400(Builder builder, String string) {
            return builder.nsPasteboardType(string);
        }
    }
}

