/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.svgpath.ext.geom;

import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.ArrayList;
import java.util.List;

public class PathLength {
    protected Shape path;
    protected List segments;
    protected int[] segmentIndexes;
    protected float pathLength;
    protected boolean initialised;

    public PathLength(Shape shape) {
        this.setPath(shape);
    }

    public Shape getPath() {
        return this.path;
    }

    public void setPath(Shape shape) {
        this.path = shape;
        this.initialised = false;
    }

    public float lengthOfPath() {
        if (!this.initialised) {
            this.initialise();
        }
        return this.pathLength;
    }

    protected void initialise() {
        this.pathLength = 0.0f;
        PathIterator pathIterator = this.path.getPathIterator(BaseTransform.IDENTITY_TRANSFORM);
        SingleSegmentPathIterator singleSegmentPathIterator = new SingleSegmentPathIterator();
        this.segments = new ArrayList(20);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(20);
        int n = 0;
        int n2 = -1;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = new float[6];
        this.segments.add(new PathSegment(0, 0.0f, 0.0f, 0.0f, n2));
        block5: while (!pathIterator.isDone()) {
            ++n2;
            arrayList.add(new Integer(n));
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    this.segments.add(new PathSegment(n3, fArray[0], fArray[1], this.pathLength, n2));
                    f3 = fArray[0];
                    f4 = fArray[1];
                    f = f3;
                    f2 = f4;
                    ++n;
                    pathIterator.next();
                    continue block5;
                }
                case 1: {
                    this.pathLength += Point2D.distance(f3, f4, fArray[0], fArray[1]);
                    this.segments.add(new PathSegment(n3, fArray[0], fArray[1], this.pathLength, n2));
                    f3 = fArray[0];
                    f4 = fArray[1];
                    ++n;
                    pathIterator.next();
                    continue block5;
                }
                case 4: {
                    this.pathLength += Point2D.distance(f3, f4, f, f2);
                    this.segments.add(new PathSegment(1, f, f2, this.pathLength, n2));
                    f3 = f;
                    f4 = f2;
                    ++n;
                    pathIterator.next();
                    continue block5;
                }
            }
            singleSegmentPathIterator.setPathIterator(pathIterator, f3, f4);
            FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(singleSegmentPathIterator, 0.01f);
            while (!flatteningPathIterator.isDone()) {
                n3 = flatteningPathIterator.currentSegment(fArray);
                if (n3 == 1) {
                    this.pathLength += Point2D.distance(f3, f4, fArray[0], fArray[1]);
                    this.segments.add(new PathSegment(n3, fArray[0], fArray[1], this.pathLength, n2));
                    f3 = fArray[0];
                    f4 = fArray[1];
                    ++n;
                }
                flatteningPathIterator.next();
            }
        }
        this.segmentIndexes = new int[arrayList.size()];
        for (int i = 0; i < this.segmentIndexes.length; ++i) {
            this.segmentIndexes[i] = (Integer)arrayList.get(i);
        }
        this.initialised = true;
    }

    public int getNumberOfSegments() {
        if (!this.initialised) {
            this.initialise();
        }
        return this.segmentIndexes.length;
    }

    public PathSegment[] getSegments() {
        return this.segments.toArray(new PathSegment[this.segments.size()]);
    }

    public PathSegment getSegment(int n) {
        if (!this.initialised) {
            this.initialise();
        }
        if (n <= 0) {
            return null;
        }
        if (n >= this.segmentIndexes.length) {
            return null;
        }
        return (PathSegment)this.segments.get(this.segmentIndexes[n]);
    }

    public float getLengthAtSegment(int n) {
        if (!this.initialised) {
            this.initialise();
        }
        if (n <= 0) {
            return 0.0f;
        }
        if (n >= this.segmentIndexes.length) {
            return this.pathLength;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n]);
        return pathSegment.getLength();
    }

    public int segmentAtLength(float f) {
        int n = this.findUpperIndex(f);
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            PathSegment pathSegment = (PathSegment)this.segments.get(n);
            return pathSegment.getIndex();
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(n - 1);
        return pathSegment.getIndex();
    }

    public Point2D pointAtLength(int n, float f) {
        float f2;
        if (!this.initialised) {
            this.initialise();
        }
        if (n < 0 || n >= this.segmentIndexes.length) {
            return null;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n]);
        float f3 = pathSegment.getLength();
        if (n == this.segmentIndexes.length - 1) {
            f2 = this.pathLength;
        } else {
            pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n + 1]);
            f2 = pathSegment.getLength();
        }
        return this.pointAtLength(f3 + (f2 - f3) * f);
    }

    public Point2D pointAtLength(float f) {
        int n = this.findUpperIndex(f);
        if (n == -1) {
            return null;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(n);
        if (n == 0) {
            return new Point2D(pathSegment.getX(), pathSegment.getY());
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.get(n - 1);
        float f2 = f - pathSegment2.getLength();
        double d = Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
        float f3 = (float)((double)pathSegment2.getX() + (double)f2 * Math.cos(d));
        float f4 = (float)((double)pathSegment2.getY() + (double)f2 * Math.sin(d));
        return new Point2D(f3, f4);
    }

    public float angleAtLength(int n, float f) {
        float f2;
        if (!this.initialised) {
            this.initialise();
        }
        if (n < 0 || n >= this.segmentIndexes.length) {
            return 0.0f;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n]);
        float f3 = pathSegment.getLength();
        if (n == this.segmentIndexes.length - 1) {
            f2 = this.pathLength;
        } else {
            pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n + 1]);
            f2 = pathSegment.getLength();
        }
        return this.angleAtLength(f3 + (f2 - f3) * f);
    }

    public float angleAtLength(float f) {
        int n = this.findUpperIndex(f);
        if (n == -1) {
            return 0.0f;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(n);
        if (n == 0) {
            n = 1;
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.get(n - 1);
        return (float)Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
    }

    public int findUpperIndex(float f) {
        PathSegment pathSegment;
        if (!this.initialised) {
            this.initialise();
        }
        if (f < 0.0f || f > this.pathLength) {
            return -1;
        }
        int n = 0;
        int n2 = this.segments.size() - 1;
        while (n != n2) {
            int n3 = n + n2 >> 1;
            PathSegment pathSegment2 = (PathSegment)this.segments.get(n3);
            if (pathSegment2.getLength() >= f) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        while ((pathSegment = (PathSegment)this.segments.get(n2)).getSegType() == 0 && n2 != this.segments.size() - 1) {
            ++n2;
        }
        int n4 = -1;
        int n5 = this.segments.size();
        for (int i = 0; n4 <= 0 && i < n5; ++i) {
            PathSegment pathSegment3 = (PathSegment)this.segments.get(i);
            if (!(pathSegment3.getLength() >= f) || pathSegment3.getSegType() == 0) continue;
            n4 = i;
        }
        return n4;
    }

    public static class PathSegment {
        protected final int segType;
        protected float x;
        protected float y;
        protected float length;
        protected int index;

        PathSegment(int n, float f, float f2, float f3, int n2) {
            this.segType = n;
            this.x = f;
            this.y = f2;
            this.length = f3;
            this.index = n2;
        }

        public int getSegType() {
            return this.segType;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float f) {
            this.x = f;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float f) {
            this.y = f;
        }

        public float getLength() {
            return this.length;
        }

        public void setLength(float f) {
            this.length = f;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }
    }

    protected static class SingleSegmentPathIterator
    implements PathIterator {
        protected PathIterator it;
        protected boolean done;
        protected boolean moveDone;
        protected double x;
        protected double y;

        protected SingleSegmentPathIterator() {
        }

        public void setPathIterator(PathIterator pathIterator, double d, double d2) {
            this.it = pathIterator;
            this.x = d;
            this.y = d2;
            this.done = false;
            this.moveDone = false;
        }

        public int currentSegment(float[] fArray) {
            int n = this.it.currentSegment(fArray);
            if (!this.moveDone) {
                fArray[0] = (float)this.x;
                fArray[1] = (float)this.y;
                return 0;
            }
            return n;
        }

        public int getWindingRule() {
            return this.it.getWindingRule();
        }

        public boolean isDone() {
            return this.done || this.it.isDone();
        }

        public void next() {
            if (!this.done) {
                if (!this.moveDone) {
                    this.moveDone = true;
                } else {
                    this.it.next();
                    this.done = true;
                }
            }
        }
    }
}

