/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.embeddedswing.EventFilter;
import com.sun.embeddedswing.SwingGlueLayer;
import com.sun.javafx.tk.TKStageListener;
import com.sun.javafx.tk.swing.FullScreenManager;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JFrame;

public class FullScreenFrame
extends JFrame
implements EventFilter {
    private TKStageListener listener;
    private boolean isUntrusted;
    private long timeEnteredFS = 0L;
    private boolean inFullScreen;
    private static final boolean isMacFSExclusive = System.getProperty("os.name").startsWith("Mac") ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return !Boolean.getBoolean("apple.awt.fakefullscreen");
        }
    }) : false;
    private static final int[] allowedKeys = new int[]{38, 40, 37, 39, 32, 9, 33, 34, 36, 35, 10};

    public FullScreenFrame(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(graphicsConfiguration);
        this.isUntrusted = bl;
        this.setUndecorated(true);
        this.installListeners();
    }

    public void setTKStageListener(TKStageListener tKStageListener) {
        this.listener = tKStageListener;
    }

    private void installListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                if (FullScreenFrame.this.listener != null) {
                    Point point = FullScreenFrame.this.getLocation();
                    FullScreenFrame.this.listener.changedLocation(point.x, point.y);
                }
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (FullScreenFrame.this.listener != null) {
                    Dimension dimension = FullScreenFrame.this.getSize();
                    FullScreenFrame.this.listener.changedSize(dimension.width, dimension.height);
                }
            }
        });
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (FullScreenFrame.this.inFullScreen) {
                    FullScreenFrame.this.exitFS();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FullScreenFrame.this.listener.closing();
                        }
                    });
                }
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (FullScreenFrame.this.listener != null) {
                    FullScreenFrame.this.listener.changedContainsFocus(true);
                }
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                if (FullScreenFrame.this.listener != null) {
                    boolean bl;
                    FullScreenFrame.this.listener.changedContainsFocus(false);
                    boolean bl2 = bl = isMacFSExclusive || FullScreenFrame.this.isVisible();
                    if (bl && System.currentTimeMillis() - FullScreenFrame.this.timeEnteredFS > 1000L) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                FullScreenFrame.this.listener.changedFullscreen(false);
                            }
                        });
                    }
                }
            }
        };
        this.addWindowListener(windowAdapter);
        this.addWindowFocusListener(windowAdapter);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                FullScreenFrame.this.getContentPane().requestFocusInWindow();
            }
        });
    }

    public void enterFS() {
        if (!this.inFullScreen) {
            SwingGlueLayer.getSwingGlueLayer().addEventFilter(this);
            FullScreenManager.enterFullScreenExclusiveMode(this, this.getGraphicsConfiguration().getDevice());
            this.timeEnteredFS = System.currentTimeMillis();
            this.inFullScreen = true;
        }
    }

    public void exitFS() {
        if (this.inFullScreen) {
            this.inFullScreen = false;
            FullScreenManager.exitFullScreenExclusiveMode(this);
            this.dispose();
            SwingGlueLayer.getSwingGlueLayer().removeEventFilter(this);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FullScreenFrame.this.listener.changedFullscreen(false);
                }
            });
        }
    }

    public AWTEvent filter(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (keyEvent.getKeyCode() == 27) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FullScreenFrame.this.listener.changedFullscreen(false);
                    }
                });
                return null;
            }
            if (this.isUntrusted) {
                for (int i = 0; i < allowedKeys.length; ++i) {
                    if (allowedKeys[i] != keyEvent.getKeyCode()) continue;
                    return aWTEvent;
                }
                return null;
            }
        }
        return aWTEvent;
    }
}

