/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.javafx.scene.transfer.UTI;
import com.sun.javafx.scene.transfer.UtiUtils;
import com.sun.javafx.tk.swing.UtiTransferable;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SwingTransferableClipboard {
    private static DataFlavor uriListString = null;

    SwingTransferableClipboard() {
    }

    public static boolean hasAnyContent(Transferable transferable) {
        if (transferable == null) {
            return false;
        }
        try {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            return dataFlavorArray != null && dataFlavorArray.length > 0;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static boolean hasContent(UTI uTI, Transferable transferable, List<File> list) {
        if (!SwingTransferableClipboard.hasAnyContent(transferable)) {
            return false;
        }
        UTI uTI2 = SwingTransferableClipboard.getTransferableUTI(transferable, list);
        return uTI2.conformsTo(uTI);
    }

    public static Object getContent(UTI uTI, Transferable transferable, List<File> list) {
        if (uTI == null || transferable == null) {
            return null;
        }
        if (uTI.conformsTo(UTI.TEXT)) {
            return SwingTransferableClipboard.getString(transferable);
        }
        Object object = SwingTransferableClipboard.getData(transferable, null);
        if (object instanceof List) {
            return object == null ? Collections.EMPTY_LIST : object;
        }
        if (object != null) {
            return object;
        }
        throw new UnsupportedOperationException("Either DragEvent.accept() has not been called, or " + uTI + " is not currently supported in DnD");
    }

    public static Object getContent(Transferable transferable, List<File> list) {
        if (transferable == null && list == null) {
            return null;
        }
        return SwingTransferableClipboard.getData(transferable, null);
    }

    public static Sequence<Object> getContents(Transferable transferable) {
        if (transferable == null) {
            return Sequences.emptySequence(Object.class);
        }
        Object object = SwingTransferableClipboard.getData(transferable, null);
        if (object instanceof List) {
            return Sequences.make(TypeInfo.getTypeInfo(Object.class), (List)object);
        }
        if (object != null) {
            return Sequences.singleton(TypeInfo.getTypeInfo(Object.class), object);
        }
        return Sequences.emptySequence(Object.class);
    }

    public static Sequence<UTI> getContentTypes(Transferable transferable, List<File> list) {
        Object object;
        if (transferable == null && list == null) {
            return Sequences.singleton(TypeInfo.getTypeInfo(UTI.class), UTI.UNKNOWN);
        }
        Object object2 = SwingTransferableClipboard.getData(transferable, null);
        if (object2 instanceof List) {
            object = new ArrayList();
            for (Object e : (List)object2) {
                if (!(e instanceof File)) continue;
                object.add(SwingTransferableClipboard.getFileUTI((File)e));
            }
            if (!object.isEmpty()) {
                return Sequences.make(TypeInfo.getTypeInfo(UTI.class), object);
            }
        } else if (list != null) {
            object = new ArrayList();
            for (File file : list) {
                object.add(SwingTransferableClipboard.getFileUTI(file));
            }
            if (!object.isEmpty()) {
                return Sequences.make(TypeInfo.getTypeInfo(UTI.class), object);
            }
        }
        object = SwingTransferableClipboard.getTransferableUTI(transferable, list);
        return Sequences.singleton(TypeInfo.getTypeInfo(UTI.class), object);
    }

    public static boolean hasString(Transferable transferable) {
        return transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public static String getString(Transferable transferable) {
        if (transferable != null) {
            Object object = SwingTransferableClipboard.getData(transferable, DataFlavor.stringFlavor);
            return object == null ? "" : (String)object;
        }
        return "";
    }

    public static boolean hasImage(Transferable transferable, List<File> list) {
        if (transferable == null) {
            return false;
        }
        if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            return true;
        }
        return SwingTransferableClipboard.hasImage(SwingTransferableClipboard.getFileList(transferable, list));
    }

    public static javafx.scene.image.Image getImage(Transferable transferable, List<File> list) {
        Object object = null;
        if (transferable != null) {
            object = SwingTransferableClipboard.getData(transferable, DataFlavor.imageFlavor);
            if (object != null) {
                if (object instanceof javafx.scene.image.Image) {
                    return (javafx.scene.image.Image)object;
                }
                if (object instanceof Image) {
                    return javafx.scene.image.Image.impl_fromPlatformImage((Image)object);
                }
                System.out.println("Unsupported image type found in transferable in SwingTransferableClipboard.getImage(Transferable): " + object.getClass());
            }
            return SwingTransferableClipboard.getImage(SwingTransferableClipboard.getFileList(transferable, list));
        }
        return null;
    }

    public static boolean hasImages(Transferable transferable, List<File> list) {
        return SwingTransferableClipboard.hasImages(SwingTransferableClipboard.getFileList(transferable, list));
    }

    public static Sequence<? extends javafx.scene.image.Image> getImages(Transferable transferable, List<File> list) {
        return SwingTransferableClipboard.getImages(SwingTransferableClipboard.getFileList(transferable, list));
    }

    private static boolean hasImage(List<File> list) {
        if (list != null) {
            for (File file : list) {
                if (!SwingTransferableClipboard.isImage(file)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasImages(List<File> list) {
        if (list != null) {
            boolean bl = false;
            for (File file : list) {
                if (!SwingTransferableClipboard.isImage(file)) continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private static javafx.scene.image.Image getImage(List<File> list) {
        if (list != null) {
            for (File file : list) {
                if (!SwingTransferableClipboard.isImage(file)) continue;
                try {
                    return javafx.scene.image.Image.impl_fromPlatformImage(ImageIO.read(file));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private static Sequence<? extends javafx.scene.image.Image> getImages(List<File> list) {
        ArrayList<javafx.scene.image.Image> arrayList = new ArrayList<javafx.scene.image.Image>();
        if (list != null) {
            for (File file : list) {
                if (!SwingTransferableClipboard.isImage(file)) continue;
                try {
                    javafx.scene.image.Image image = javafx.scene.image.Image.impl_fromPlatformImage(ImageIO.read(file));
                    arrayList.add(image);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return Sequences.make(TypeInfo.getTypeInfo(javafx.scene.image.Image.class), arrayList);
    }

    public static boolean hasFile(Transferable transferable) {
        return transferable != null && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    static File getFile(Transferable transferable) {
        return SwingTransferableClipboard.getFile(transferable, null);
    }

    private static boolean isImage(File file) {
        return UtiUtils.isType(file.getName(), UTI.IMAGE);
    }

    public static Sequence<File> getFiles(Transferable transferable) {
        if (transferable.getTransferDataFlavors().length == 0) {
            return Sequences.emptySequence(File.class);
        }
        return Sequences.fromCollection(TypeInfo.getTypeInfo(File.class), SwingTransferableClipboard.getFileList(transferable));
    }

    static File getFile(Transferable transferable, List<File> list) {
        if ((list = SwingTransferableClipboard.getFileList(transferable, list)) != null && list.size() >= 1) {
            return list.get(0);
        }
        return null;
    }

    public static boolean hasFiles(Transferable transferable) {
        return SwingTransferableClipboard.hasFile(transferable) && SwingTransferableClipboard.getFileList(transferable).size() > 1;
    }

    static List<File> getFileList(Transferable transferable, List<File> list) {
        if (list == null || list.isEmpty()) {
            list = SwingTransferableClipboard.getFileList(transferable);
        }
        return list;
    }

    static List<File> getFileList(Transferable transferable) {
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List<File> list = new ArrayList();
                list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list != null && !list.isEmpty()) {
                    return list;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static Object getData(Transferable transferable, DataFlavor dataFlavor) {
        if (transferable == null) {
            return null;
        }
        try {
            if ((dataFlavor == null || DataFlavor.javaFileListFlavor.equals(dataFlavor)) && transferable.isDataFlavorSupported(uriListString)) {
                return SwingTransferableClipboard.getFileList(transferable);
            }
            if (dataFlavor == null && transferable.getTransferDataFlavors().length > 0) {
                dataFlavor = transferable.getTransferDataFlavors()[0];
            }
            if (!transferable.isDataFlavorSupported(dataFlavor)) {
                return null;
            }
            return transferable.getTransferData(dataFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println("SwingTransferableUtils.getData() encountered: " + unsupportedFlavorException + ", returning null");
        }
        catch (IOException iOException) {
            System.err.println("SwingTransferableUtils.getData() encountered: " + iOException + ", returning null");
        }
        return null;
    }

    static UTI getTransferableUTI(Transferable transferable, List<File> list) {
        UTI object;
        if (transferable == null) {
            return UTI.UNKNOWN;
        }
        if (transferable instanceof UtiTransferable && (object = ((UtiTransferable)transferable).getUTI()) != null) {
            return object;
        }
        if (SwingTransferableClipboard.hasString(transferable)) {
            return UTI.TEXT;
        }
        if (SwingTransferableClipboard.hasFiles(transferable)) {
            return UTI.JAVA_FILE_LIST;
        }
        if (SwingTransferableClipboard.hasFile(transferable)) {
            File file = SwingTransferableClipboard.getFile(transferable, list);
            if (file == null) {
                return UTI.UNKNOWN_JAVA_FILE;
            }
            return SwingTransferableClipboard.getFileUTI(file);
        }
        if (SwingTransferableClipboard.hasImage(transferable, null)) {
            return UTI.IMAGE;
        }
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            String string = dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
            UTI uTI = UTI.lookupMimeType(string);
            if (uTI == null) continue;
            return uTI;
        }
        return UTI.UNKNOWN;
    }

    static UTI getFileUTI(File file) {
        UTI uTI;
        String string;
        if (file.isDirectory()) {
            return UTI.FOLDER;
        }
        int n = file.getName().lastIndexOf(".");
        if (n >= 0 && (string = file.getName().substring(n)) != null && string.length() != 0 && (uTI = UTI.lookupExtension(string)) != null) {
            return uTI;
        }
        return UTI.DATA;
    }

    static {
        try {
            uriListString = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }
}

