/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.tk.swing.FrameStage;
import com.sun.javafx.tk.swing.WindowStage;
import com.sun.scenario.Settings;
import com.sun.scenario.utils.Utils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.RectangularShape;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javafx.lang.FX;
import javafx.stage.StageStyle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;

public class WindowImpl {
    private static Vector windows = new Vector();
    private static boolean debug = false;
    static boolean isApplet = false;
    private static Boolean transparencySupported = null;

    public static void disposeAll() {
        for (Object e : windows) {
            ((Window)e).dispose();
        }
    }

    private static void add(Window window) {
        windows.addElement(window);
        if (debug) {
            System.out.println("WindowImpl.add: " + windows.size());
        }
    }

    public static void dispose(Window window) {
        windows.removeElement(window);
        if (debug) {
            System.out.println("WindowImpl.dispose: " + windows.size());
        }
        if (windows.size() == 0 && !isApplet) {
            FX.exit();
        }
    }

    private static final boolean isMac() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    private static final boolean isLinux() {
        return "Linux".equalsIgnoreCase(System.getProperty("os.name"));
    }

    private static final boolean isSolaris() {
        return "Solaris".equalsIgnoreCase(System.getProperty("os.name"));
    }

    private static final boolean isTransparencySupported() {
        if (transparencySupported == null) {
            if (WindowImpl.isLinux() || WindowImpl.isSolaris()) {
                boolean bl = false;
                transparencySupported = Settings.getBoolean("javafx.allowTransparentStage", bl);
            } else {
                transparencySupported = true;
            }
            if (!transparencySupported.booleanValue()) {
                System.err.println("Warning: Transparent windows are not supported by the current platform.");
            }
        }
        return transparencySupported;
    }

    static JDialog createJDialog() {
        JDialog jDialog = WindowImpl.isMac() ? new JDialog(){

            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){

                    public void paint(Graphics graphics) {
                        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                        super.paint(graphics);
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        } : new JDialog();
        jDialog.setBackground(Color.WHITE);
        WindowImpl.add(jDialog);
        return jDialog;
    }

    static JFrame createJFrame(StageStyle stageStyle) {
        GraphicsConfiguration graphicsConfiguration;
        JFrame jFrame = WindowImpl.isMac() ? new JFrame(){

            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){

                    public void paint(Graphics graphics) {
                        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                        super.paint(graphics);
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        } : ((WindowImpl.isLinux() || WindowImpl.isSolaris()) && stageStyle == StageStyle.TRANSPARENT && WindowImpl.isTransparencySupported() ? ((graphicsConfiguration = WindowImpl.getTransparentGraphicsConfiguration()) == null ? new JFrame() : new JFrame(graphicsConfiguration)) : new JFrame());
        jFrame.setBackground(Color.WHITE);
        WindowImpl.add(jFrame);
        return jFrame;
    }

    static JWindow createJWindow(Object object) {
        GraphicsConfiguration graphicsConfiguration;
        Window window = null;
        if (object instanceof WindowStage) {
            window = ((WindowStage)object).window;
        }
        JFrame jFrame = null;
        if (object instanceof FrameStage) {
            jFrame = ((FrameStage)object).frame;
        }
        JWindow jWindow = WindowImpl.isMac() ? new JWindow(jFrame){

            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){

                    public void paint(Graphics graphics) {
                        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                        super.paint(graphics);
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        } : ((WindowImpl.isLinux() || WindowImpl.isSolaris()) && WindowImpl.isTransparencySupported() ? ((graphicsConfiguration = WindowImpl.getTransparentGraphicsConfiguration()) == null ? new JWindow(jFrame) : new JWindow(graphicsConfiguration)) : new JWindow(jFrame));
        jWindow.setBackground(Color.WHITE);
        WindowImpl.add(jWindow);
        return jWindow;
    }

    public static void setWindowTransparency(Window window, boolean bl) {
        if (!WindowImpl.isTransparencySupported()) {
            return;
        }
        if (WindowImpl.isMac() && window instanceof RootPaneContainer) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            window.setBackground(new Color(0, 0, 0, 0));
            rootPaneContainer.getRootPane().putClientProperty("apple.awt.windowShadow.revalidateNow", new Object());
            rootPaneContainer.getRootPane().putClientProperty("Window.hasShadow", Boolean.FALSE);
            rootPaneContainer.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", false);
        } else {
            Class clazz = null;
            try {
                clazz = Utils.platformClassForName("com.sun.awt.AWTUtilities", true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                try {
                    Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                    try {
                        method.invoke(null, window, !bl);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        System.err.println("Warning: Transparent windows are not supported by the current platform.");
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error setting window transparency using AWTUtilities");
                }
            }
        }
    }

    public static void setWindowOpacity(Window window, double d) {
        if (!WindowImpl.isTransparencySupported()) {
            return;
        }
        if (WindowImpl.isMac() && window instanceof RootPaneContainer) {
            if (debug) {
                System.out.println("WindowImpl.setWindowOpacity: mac: " + d);
            }
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            rootPaneContainer.getRootPane().putClientProperty("Window.alpha", new Float(d));
        } else {
            if (debug) {
                System.out.println("WindowImpl.setWindowOpacity: not mac: " + d + " name: " + System.getProperty("os.name"));
            }
            if (debug) {
                System.out.println("WindowImpl.setWindowOpacity: window: " + (window == null ? "null" : window.getClass().getName()));
            }
            Class clazz = null;
            try {
                clazz = Utils.platformClassForName("com.sun.awt.AWTUtilities", true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                try {
                    Method method = clazz.getMethod("setWindowOpacity", Window.class, Float.TYPE);
                    try {
                        method.invoke(null, window, Float.valueOf((float)d));
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        System.err.println("Warning: Setting the opacity of a window is not supported by the current platform.");
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error setting window opacity using AWTUtilities");
                }
            }
        }
    }

    public static GraphicsConfiguration getTransparentGraphicsConfiguration() {
        try {
            Class clazz = Utils.platformClassForName("com.sun.awt.AWTUtilities", true);
            Method method = clazz.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            GraphicsConfiguration graphicsConfiguration = null;
            for (int i = 0; i < graphicsDeviceArray.length && graphicsConfiguration == null; ++i) {
                GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
                for (int j = 0; j < graphicsConfigurationArray.length && graphicsConfiguration == null; ++j) {
                    Boolean bl = (Boolean)method.invoke(null, graphicsConfigurationArray[j]);
                    if (!bl.booleanValue()) continue;
                    graphicsConfiguration = graphicsConfigurationArray[j];
                    System.out.println("FOUND translucency capable GC: " + graphicsConfigurationArray[j]);
                }
            }
            return graphicsConfiguration;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public static GraphicsDevice getGraphicsDevice(Window window) {
        GraphicsDevice[] graphicsDeviceArray;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (window == null) {
            return graphicsEnvironment.getDefaultScreenDevice();
        }
        if (window.getGraphicsConfiguration() != null) {
            return window.getGraphicsConfiguration().getDevice();
        }
        Rectangle rectangle = window.getBounds();
        int n = (int)(((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() / 2.0);
        int n2 = (int)(((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight() / 2.0);
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            Rectangle rectangle2 = graphicsDevice.getDefaultConfiguration().getBounds();
            if (!rectangle2.contains(n, n2)) continue;
            return graphicsDevice;
        }
        return graphicsEnvironment.getDefaultScreenDevice();
    }
}

