/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.container.AbstractFXDContainer;
import com.sun.javafx.tools.fxd.container.ContainerEntry;
import com.sun.javafx.tools.fxd.container.Context;
import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.FXDContainerFactoryImpl;
import com.sun.javafx.tools.fxd.container.FXDReaderContainerImpl;
import com.sun.javafx.tools.fxd.container.doc.GlobalReference;
import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import java.io.IOException;
import java.io.Reader;

public abstract class FXDContainerFactory
extends FXDContainerFactoryImpl {
    public static ContainerEntry create(Object object, FXDContainer fXDContainer, Context context) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("The source cannot be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("The context cannot be null");
        }
        if (object instanceof Reader) {
            return new FXDReaderContainerImpl((Reader)object);
        }
        GlobalReference globalReference = object instanceof GlobalReference ? (GlobalReference)object : new GlobalReference(object);
        if (globalReference.archive == null) {
            if (fXDContainer != null) {
                return ContainerEntry.create(fXDContainer, globalReference.entry);
            }
            return FXDContainerFactory.createContainer(globalReference.entry, context);
        }
        String string = globalReference.archive;
        if (fXDContainer != null && !ContainerUtils.isAbsoluteURL(string) && (string = fXDContainer.getRelativeURL(string)) == null) {
            throw new IOException("Invalid reference: " + object);
        }
        AbstractFXDContainer abstractFXDContainer = FXDContainerFactory.createContainer(string, context);
        return globalReference.entry == null ? abstractFXDContainer : ContainerEntry.create(abstractFXDContainer, globalReference.entry);
    }

    protected FXDContainerFactory() {
    }

    static interface ContainerCreator {
        public AbstractFXDContainer create(Object var1) throws IOException;
    }
}

