/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.container.AbstractDesktopFXDContainer;
import com.sun.javafx.tools.fxd.container.AbstractFXDContainer;
import com.sun.javafx.tools.fxd.container.FXDBrowsableContainer;
import com.sun.javafx.tools.fxd.container.FXDContainerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class FXZFileContainerImpl
extends AbstractDesktopFXDContainer
implements FXDBrowsableContainer {
    protected File m_file;
    protected ZipFile m_zip;
    protected String[] m_entryNames;
    public static final FXDContainerFactory.ContainerCreator CREATOR = new FXDContainerFactory.ContainerCreator(){

        public AbstractFXDContainer create(Object object) throws IOException {
            return new FXZFileContainerImpl((File)object);
        }
    };

    public FXZFileContainerImpl(File file) throws MalformedURLException, FileNotFoundException, IOException {
        super(file.getCanonicalFile().toURI().toURL());
        this.m_file = file.getCanonicalFile();
        if (!this.m_file.exists()) {
            throw new FileNotFoundException("The file " + this.m_file.getAbsolutePath() + " not found.");
        }
        if (!this.m_file.isFile()) {
            throw new IllegalArgumentException(this.m_file.getAbsolutePath() + " is not a file.");
        }
    }

    public synchronized void load() throws IOException {
        try {
            this.m_zip = new ZipFile(this.m_file);
        }
        catch (ZipException zipException) {
            throw new IllegalArgumentException("The file " + this.m_file.getAbsolutePath() + " is not valid FXZ archive.");
        }
        this.m_entryNames = new String[this.m_zip.size()];
        Enumeration<? extends ZipEntry> enumeration = this.m_zip.entries();
        for (int i = 0; i < this.m_entryNames.length; ++i) {
            this.m_entryNames[i] = enumeration.nextElement().getName();
        }
    }

    public synchronized InputStream open(String string) throws FileNotFoundException, IOException {
        this.checkState();
        string = FXZFileContainerImpl.removeMagicDirVar(string);
        ZipEntry zipEntry = this.m_zip.getEntry(string);
        if (zipEntry != null) {
            return new BufferedInputStream(this.m_zip.getInputStream(zipEntry));
        }
        throw new FileNotFoundException("The entry '" + string + "' not found in the file " + this.m_file);
    }

    public synchronized String[] getEntryNames() throws IOException {
        this.checkState();
        return this.m_entryNames;
    }

    protected synchronized int getSize(String string) throws IOException {
        this.checkState();
        string = FXZFileContainerImpl.removeMagicDirVar(string);
        ZipEntry zipEntry = this.m_zip.getEntry(string);
        return zipEntry != null ? (int)zipEntry.getSize() : -1;
    }

    protected String getArchiveSeparator() {
        return "!";
    }

    protected String getContainerURL() throws IOException {
        String string = super.getContainerURL();
        assert (string.startsWith("file:"));
        return "jar:" + string;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getName(), this.m_file != null ? this.m_file.toString() : "null");
    }

    public synchronized void close() {
        this.m_file = null;
        if (this.m_zip != null) {
            this.m_entryNames = null;
            try {
                this.m_zip.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_zip = null;
        }
        super.close();
    }

    private synchronized void checkState() throws IOException {
        if (this.m_file == null) {
            throw new IllegalStateException("The archive " + this.toString() + " has been closed.");
        }
        if (this.m_zip == null) {
            this.load();
        }
    }

    public String getRelativeURL(String string) throws IOException {
        File file = new File(this.m_file.getParentFile(), string);
        return file.getCanonicalFile().toURI().toString();
    }
}

