/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.loader.misc;

import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.loader.misc.FXDLogger;

public abstract class CommonFXDLogger {
    public static final String PROP_LEVEL = "fxd.logger.level";
    private static Handler s_handler = null;
    protected Level level;

    public static void setHandler(Handler handler) {
        s_handler = handler;
    }

    protected CommonFXDLogger() {
        String string;
        try {
            string = System.getProperty(PROP_LEVEL);
        }
        catch (Exception exception) {
            string = null;
        }
        if (string != null) {
            try {
                this.level = Level.valueOf(string.toString().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Invalid fxd.logger.level value: '" + string.toString() + "'");
                this.level = Level.SEVERE;
            }
        } else {
            this.level = Level.SEVERE;
        }
    }

    public static void setLevel(Level level) {
        FXDLogger.instance.level = level;
    }

    private static Level getLevel() {
        return s_handler == null ? FXDLogger.instance.level : s_handler.getLevel();
    }

    public static void log(String string, Level level) {
        if (level.index <= CommonFXDLogger.getLevel().index) {
            CommonFXDLogger.writeImpl(level.displayName.concat(string), level);
        }
    }

    public static void log(Object object, Object object2, Level level) {
        if (level.index <= CommonFXDLogger.getLevel().index) {
            CommonFXDLogger.writeImpl(ContainerUtils.toString(object).concat(ContainerUtils.toString(object2)), level);
        }
    }

    public static void log(Object object, Object object2, Object object3, Level level) {
        if (level.index <= CommonFXDLogger.getLevel().index) {
            CommonFXDLogger.writeImpl(ContainerUtils.toString(object).concat(ContainerUtils.toString(object2)).concat(ContainerUtils.toString(object3)), level);
        }
    }

    public static void log(Object object, Object object2, Object object3, Object object4, Level level) {
        if (level.index <= CommonFXDLogger.getLevel().index) {
            CommonFXDLogger.writeImpl(ContainerUtils.toString(object).concat(ContainerUtils.toString(object2)).concat(ContainerUtils.toString(object3)).concat(ContainerUtils.toString(object4)), level);
        }
    }

    public static void error(String string, Throwable throwable) {
        CommonFXDLogger.error(string, throwable, Level.SEVERE);
    }

    public static void error(String string, Throwable throwable, Level level) {
        if (level.index <= CommonFXDLogger.getLevel().index) {
            CommonFXDLogger.errorImpl(string, throwable, level);
        }
    }

    private static void writeImpl(String string, Level level) {
        if (s_handler != null) {
            s_handler.log(string, level);
        } else {
            FXDLogger.instance.write(level.displayName.concat(": ").concat(string));
        }
    }

    private static void errorImpl(String string, Throwable throwable, Level level) {
        if (s_handler != null) {
            s_handler.error(string, throwable, level);
        } else {
            FXDLogger.instance.write(level.displayName.concat(": ").concat(string), throwable);
        }
    }

    protected abstract void write(String var1);

    protected abstract void write(String var1, Throwable var2);

    public static interface Handler {
        public void log(String var1, Level var2);

        public void error(String var1, Throwable var2, Level var3);

        public Level getLevel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OFF("OFF", 0),
        SEVERE("SEVERE", 1),
        WARNING("WARNING", 2),
        INFO("INFO", 3),
        FINE("FINE", 4),
        FINER("FINER", 5),
        FINEST("FINEST", 6),
        ALL("ALL", 7);

        private final String displayName;
        private final int index;

        private Level(String string2, int n2) {
            this.displayName = string2;
            this.index = n2;
        }
    }
}

