/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.pool;

import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.container.scene.fxd.MutableFXDObjectElement;
import com.sun.javafx.tools.fxd.pool.CreationConnector;
import com.sun.javafx.tools.fxd.pool.DelayedValue;
import com.sun.javafx.tools.fxd.pool.ObjectPostProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DelayedValuePool {
    private static final Map<String, ObjectPostProcessor> s_postProcessors = new HashMap<String, ObjectPostProcessor>();
    protected static final int MAX_THREAD_NUM = ContainerUtils.getPoolThreadCount();
    protected final List<DelayedValueImpl> m_taskQueue = new ArrayList<DelayedValueImpl>();
    protected final List<PoolThread> m_threads = new ArrayList<PoolThread>();
    protected FXDContainer m_containerToClose = null;
    protected final List<CreationConnector> m_connections = new ArrayList<CreationConnector>();

    public static boolean isEnabled() {
        return MAX_THREAD_NUM > 0;
    }

    public static synchronized void registerPostProcessor(String string, ObjectPostProcessor objectPostProcessor) {
        if (DelayedValuePool.isEnabled()) {
            s_postProcessors.put(string, objectPostProcessor);
        }
    }

    public void processValues(FXDContainer fXDContainer, MutableFXDObjectElement mutableFXDObjectElement) {
        ObjectPostProcessor objectPostProcessor = s_postProcessors.get(mutableFXDObjectElement.getTypeName());
        if (objectPostProcessor != null) {
            objectPostProcessor.processValues(this, fXDContainer, mutableFXDObjectElement);
        }
    }

    public synchronized void addConnection(CreationConnector creationConnector) {
        this.m_connections.add(creationConnector);
    }

    public synchronized void waitFor() {
        try {
            while (this.m_threads.size() > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            for (CreationConnector creationConnector : this.m_connections) {
                creationConnector.connect();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void closeContainer(FXDContainer fXDContainer) {
        if (this.m_threads.size() == 0) {
            fXDContainer.close();
        } else {
            this.m_containerToClose = fXDContainer;
        }
    }

    public synchronized void start(DelayedValueImpl delayedValueImpl) {
        this.m_taskQueue.add(delayedValueImpl);
        if (this.m_threads.size() < MAX_THREAD_NUM) {
            PoolThread poolThread = new PoolThread();
            ContainerUtils.setDaemon(poolThread, true);
            ContainerUtils.setName(poolThread, "PoolThread");
            this.m_threads.add(poolThread);
            poolThread.start();
        }
    }

    protected synchronized DelayedValueImpl fetchTask() {
        if (this.m_taskQueue.size() > 0) {
            return this.m_taskQueue.remove(0);
        }
        return null;
    }

    protected synchronized void removeThread(PoolThread poolThread) {
        if (!this.m_threads.remove(poolThread)) {
            System.err.println("Thread " + poolThread + " is not found.");
        }
        if (this.m_threads.size() == 0) {
            if (this.m_containerToClose != null) {
                this.m_containerToClose.close();
                this.m_containerToClose = null;
            }
            this.notifyAll();
        }
    }

    public static abstract class DelayedValueImpl
    implements DelayedValue {
        private volatile boolean m_isReady = false;
        private volatile Object m_result;
        private volatile Throwable m_error;

        public final synchronized boolean isReady() {
            return this.m_isReady;
        }

        public final synchronized Object getValue() throws Throwable {
            if (this.m_isReady) {
                if (this.m_error != null) {
                    throw this.m_error;
                }
                return this.m_result;
            }
            throw new IllegalStateException("The " + this.toString() + " is not ready");
        }

        public abstract Object invoke() throws Exception;

        protected final synchronized void setResult(Object object) {
            this.m_isReady = true;
            this.m_result = object;
        }

        protected final synchronized void setError(Throwable throwable) {
            this.m_isReady = true;
            this.m_error = throwable;
        }
    }

    protected final class PoolThread
    extends Thread {
        protected PoolThread() {
        }

        public void run() {
            DelayedValueImpl delayedValueImpl;
            while ((delayedValueImpl = DelayedValuePool.this.fetchTask()) != null) {
                try {
                    Object object = delayedValueImpl.invoke();
                    delayedValueImpl.setResult(object);
                }
                catch (Throwable throwable) {
                    System.err.println("Invocation failed: " + throwable.getMessage() + " " + throwable.getClass());
                    throwable.printStackTrace();
                    delayedValueImpl.setError(throwable);
                }
            }
            DelayedValuePool.this.removeThread(this);
        }
    }
}

