/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmc;

import com.sun.media.jmc.Media;
import com.sun.media.jmc.MediaCorruptedException;
import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.MediaView;
import com.sun.media.jmc.OperationUnsupportedException;
import com.sun.media.jmc.control.AudioControl;
import com.sun.media.jmc.control.MediaControl;
import com.sun.media.jmc.control.PlayControl;
import com.sun.media.jmc.control.SubtitleControl;
import com.sun.media.jmc.control.TrackControl;
import com.sun.media.jmc.control.VideoControl;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.control.VideoRenderControl;
import com.sun.media.jmc.event.BufferDownloadListener;
import com.sun.media.jmc.event.BufferDownloadedProgressChangedEvent;
import com.sun.media.jmc.event.DurationChangedEvent;
import com.sun.media.jmc.event.MediaDurationListener;
import com.sun.media.jmc.event.MediaEvent;
import com.sun.media.jmc.event.MediaSizeListener;
import com.sun.media.jmc.event.MediaStateEvent;
import com.sun.media.jmc.event.MediaStateListener;
import com.sun.media.jmc.event.MediaTimeEvent;
import com.sun.media.jmc.event.MediaTimeListener;
import com.sun.media.jmc.event.SizeChangedEvent;
import com.sun.media.jmc.event.VideoRendererEvent;
import com.sun.media.jmc.event.VideoRendererListener;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmc.type.ProtocolType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PeerManager;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.Utils;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FilePermission;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaProvider
implements PlayControl {
    private State state = State.PAUSED;
    private State expectedState = null;
    private double rate = 1.0;
    private boolean autoRepeat = false;
    private int playCount = 1;
    private int currentCount = 0;
    private CounterReset resetCounter;
    private URI sourceUri = null;
    private VideoDataBuffer.Format[] formats;
    private List<MediaStateListener> mediaStateListeners = new ArrayList<MediaStateListener>();
    private List<VideoRendererListener> videoUpdateListeners = new ArrayList<VideoRendererListener>();
    private List<BufferDownloadListener> bufferDownloadListeners = new ArrayList<BufferDownloadListener>();
    private List<MediaDurationListener> mediaDurationListeners = new ArrayList<MediaDurationListener>();
    private List<MediaSizeListener> mediaSizeListeners = new ArrayList<MediaSizeListener>();
    private List<Double> notificationTimes = new ArrayList<Double>();
    private HashMap<Double, List<MediaTimeListener>> notificationTimesMap = new HashMap();
    private PlayerPeer player = null;
    private MediaPeer mediaInfo = null;
    private EventQueueThread eventQueueThread = null;
    private AudioControl audioControl = null;
    private VideoControl videoControl = null;
    private SubtitleControl subtitleControl = null;
    private VideoRenderControl videoRenderControl = null;
    private TrackControl trackControl = null;
    private List<MediaControl> controls = new ArrayList<MediaControl>();
    private PropertyChangeSupport propertyChangeSupport;
    private static RuntimePermission mediaAccessPermssion = new RuntimePermission("com.sun.media.jmc.accessMedia");
    private Map<CapabilityKey, Object> capabilities = new HashMap<CapabilityKey, Object>();
    private static final FilePermission readMediaFilePermission = new FilePermission("<<ALL FILES>>", "read");
    double mediaTime = 0.0;
    private Timer mediaTimer = null;
    private MediaTimerTaskCallback mediaTimerTaskCallback = null;
    private boolean mediaTimerTaskPaused = true;
    List views = new LinkedList();

    public MediaProvider() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateCapabilities();
    }

    public MediaProvider(URI uRI) throws MediaUnavailableException, MediaUnsupportedException, MediaCorruptedException {
        this();
        this.setSource(uRI);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static List<ContainerType> getSupportedContainerTypes() {
        return PeerManager.getSupportedContainerTypes();
    }

    public static boolean renderingControlSupported(URI uRI) {
        String string = uRI.toASCIIString();
        return string.toLowerCase().endsWith(".ogg");
    }

    public static List<ProtocolType> getSupportedProtocols(EncodingType encodingType) {
        return null;
    }

    public static List<EncodingType> getSupportedEncodings(ContainerType containerType) {
        return null;
    }

    public <T extends MediaControl> T getControl(Class<T> clazz) {
        MediaControl mediaControl = null;
        if (clazz == AudioControl.class) {
            mediaControl = (MediaControl)clazz.cast(this.audioControl);
        } else if (clazz == VideoControl.class) {
            mediaControl = (MediaControl)clazz.cast(this.videoControl);
        } else if (clazz == VideoRenderControl.class) {
            this.checkRenderAccess();
            mediaControl = (MediaControl)clazz.cast(this.videoRenderControl);
        } else if (clazz == TrackControl.class) {
            mediaControl = (MediaControl)clazz.cast(this.trackControl);
        } else if (clazz == PlayControl.class) {
            mediaControl = (MediaControl)clazz.cast(this);
        }
        return (T)(this.controls.contains(mediaControl) ? mediaControl : null);
    }

    private final void checkRenderAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(mediaAccessPermssion);
        }
    }

    public List<MediaControl> getControls() {
        boolean bl;
        try {
            this.checkRenderAccess();
            bl = true;
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        if (bl) {
            return Collections.unmodifiableList(this.controls);
        }
        ArrayList<MediaControl> arrayList = new ArrayList<MediaControl>();
        for (MediaControl mediaControl : this.controls) {
            if (mediaControl instanceof VideoRenderControl) continue;
            arrayList.add(mediaControl);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private void updateCapabilities() {
        if (this.player == null) {
            this.capabilities.put(CapabilityKey.SUPPORTS_SEEKING, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_RATE, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_NOTIFICATION_TIMES, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_VOLUME, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_BALANCE, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_FADER, Boolean.FALSE);
        } else {
            this.capabilities.put(CapabilityKey.SUPPORTS_SEEKING, this.isSupported(PlayerPeer.Capabilities.supportsSeeking));
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_RATE, this.isSupported(PlayerPeer.Capabilities.supportsRate));
            this.capabilities.put(CapabilityKey.SUPPORTS_NOTIFICATION_TIMES, this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes));
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_VOLUME, this.isSupported(PlayerPeer.Capabilities.supportsVolume));
            this.capabilities.put(CapabilityKey.SUPPORTS_BALANCE, this.isSupported(PlayerPeer.Capabilities.supportsBalance));
            this.capabilities.put(CapabilityKey.SUPPORTS_FADER, this.isSupported(PlayerPeer.Capabilities.supportsFader));
        }
    }

    public Map<CapabilityKey, Object> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public <T> T getCapability(CapabilityKey capabilityKey, Class<T> clazz) {
        return clazz.cast(this.capabilities.get((Object)capabilityKey));
    }

    public <MC extends MediaControl> List<MC> getControls(Class<MC> clazz) {
        if (clazz == VideoRenderControl.class) {
            this.checkRenderAccess();
        }
        LinkedList<MC> linkedList = new LinkedList<MC>();
        for (MediaControl mediaControl : this.controls) {
            if (!clazz.isInstance(mediaControl)) continue;
            try {
                linkedList.add(clazz.cast(mediaControl));
            }
            catch (ClassCastException classCastException) {}
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(URI uRI) throws MediaUnsupportedException, MediaUnavailableException, MediaCorruptedException {
        SecurityManager securityManager;
        if (uRI == null) {
            this.close();
            return;
        }
        uRI.normalize();
        if (this.sourceUri == uRI) {
            return;
        }
        if (uRI.getScheme().equalsIgnoreCase("file") && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(readMediaFilePermission);
        }
        this.sourceUri = uRI;
        try {
            if (this.player != null) {
                boolean bl = true;
                if (PeerManager.isPeerClassForURI(uRI, this.player.getClass(), this.formats)) {
                    try {
                        this.player.setSource(uRI);
                        bl = false;
                    }
                    catch (MediaException mediaException) {
                        // empty catch block
                    }
                }
                if (bl) {
                    this.freePeer();
                }
            }
            if (this.player == null) {
                this.player = PeerManager.getPlayerPeer(uRI, false, this.formats);
            }
            this.setPeer(this.player);
        }
        finally {
            if (this.player == null) {
                this.sourceUri = null;
                this.destroyMediaTimer();
                this.destroyEventQueue();
            }
            this.updateCapabilities();
        }
    }

    public void setPlayerPeerFromMedia(Media media) throws MediaUnsupportedException, MediaUnavailableException, MediaCorruptedException {
        if (media == null) {
            this.close();
            return;
        }
        if (this.player != null) {
            this.player.setSource(null);
        }
        this.formats = media.getRequestedFormats();
        this.player = media.getPlayerPeer();
        if (this.player == null) {
            this.setSource(media.uri);
        } else {
            this.sourceUri = media.uri;
            this.setPeer(this.player);
            this.updateCapabilities();
        }
    }

    public URI getSource() {
        return this.sourceUri;
    }

    @Override
    public void play() {
        this.pauseMediaTimerTaskCallback(false);
        this.expectedState = State.STARTED;
        if (this.player != null) {
            if (this.resetCounter == CounterReset.RESET_ON_PLAY) {
                this.resetCounter = CounterReset.RESET_ON_PLAY;
                this.currentCount = 0;
            }
            if (this.currentCount + 1 < this.playCount) {
                this.player.setAutoRepeat(true);
            } else {
                this.player.setAutoRepeat(false);
            }
            this.player.start();
        }
    }

    @Override
    public void pause() {
        if (this.player != null) {
            this.expectedState = State.PAUSED;
            this.player.pause();
        } else {
            this.state = State.PAUSED;
        }
        this.pauseMediaTimerTaskCallback(true);
    }

    @Override
    public double setMediaTime(double d) throws OperationUnsupportedException {
        if (d < 0.0) {
            d = 0.0;
        }
        if (this.player != null) {
            this.player.setMediaTime(d);
        }
        return this.mediaTime;
    }

    @Override
    public double getMediaTime() {
        double d = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            d = this.player.getMediaTime();
        }
        return d;
    }

    @Override
    public double setStartTime(double d) throws OperationUnsupportedException {
        if (d < 0.0) {
            d = 0.0;
        }
        if (this.player != null) {
            this.player.setStartTime(d);
        }
        return d;
    }

    @Override
    public double getStartTime() {
        double d = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            d = this.player.getStartTime();
        }
        return d;
    }

    @Override
    public double setStopTime(double d) throws OperationUnsupportedException {
        if (this.player != null) {
            this.player.setStopTime(d);
        }
        return d;
    }

    @Override
    public double getStopTime() {
        double d = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            d = this.player.getStopTime();
        }
        return d;
    }

    @Override
    public double getDuration() {
        double d = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            d = this.player.getDuration();
        }
        return d;
    }

    @Override
    public double setRate(double d) {
        double d2 = this.rate;
        this.rate = d;
        if (this.player != null) {
            this.player.setRate(d);
            this.propertyChangeSupport.firePropertyChange("RATE_CHANGED", d2, this.rate);
        }
        return this.rate;
    }

    @Override
    public double getRate() {
        if (this.player != null) {
            this.rate = this.player.getRate();
        }
        return this.rate;
    }

    @Override
    public boolean isPlaying() {
        return this.expectedState == null ? this.state == State.STARTED : this.expectedState == State.STARTED;
    }

    @Override
    public void addNotificationTime(double d, MediaTimeListener mediaTimeListener, boolean bl) throws OperationUnsupportedException {
        if (!bl) {
            this.addNotificationTime(d, mediaTimeListener);
        }
    }

    @Override
    public void addNotificationTime(double d, MediaTimeListener mediaTimeListener) throws OperationUnsupportedException {
        List<MediaTimeListener> list;
        if (!this.notificationTimes.contains(d)) {
            this.notificationTimes.add(new Double(d));
        }
        if ((list = this.notificationTimesMap.get(d)) == null) {
            list = new ArrayList<MediaTimeListener>();
            list.add(mediaTimeListener);
            this.notificationTimesMap.put(d, list);
        } else {
            list.add(mediaTimeListener);
        }
        if (this.player != null) {
            if (this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes)) {
                try {
                    this.player.setNotificationTimes(this.notificationTimes);
                }
                catch (Exception exception) {
                    System.err.println("Unexpected exception setting notification time");
                    throw new OperationUnsupportedException();
                }
            } else {
                throw new OperationUnsupportedException();
            }
        }
    }

    @Override
    public void removeNotificationTime(double d, MediaTimeListener mediaTimeListener) {
        List<MediaTimeListener> list = this.notificationTimesMap.get(d);
        if (list == null) {
            System.err.println("no timer for time: " + d);
        } else {
            int n = list.indexOf(mediaTimeListener);
            if (n == -1) {
                System.err.println("No Listener for timer:" + mediaTimeListener + " at " + d);
            } else {
                list.remove(n);
                if (list.isEmpty()) {
                    this.notificationTimesMap.remove(list);
                    this.notificationTimes.remove(d);
                }
            }
        }
        if (this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes)) {
            try {
                this.player.setNotificationTimes(this.notificationTimes);
            }
            catch (Exception exception) {
                System.err.println("unexpected exception removing NotificationTime" + exception);
            }
        }
    }

    public boolean isNotificationTimeSupported() {
        return this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes);
    }

    @Override
    public void setRepeating(boolean bl) {
        boolean bl2 = this.autoRepeat;
        this.autoRepeat = bl;
        if (this.player != null) {
            this.player.setAutoRepeat(bl);
        }
        this.propertyChangeSupport.firePropertyChange("REPEATING_CHANGED", bl2, bl);
        if (bl) {
            this.setPlayCount(Integer.MAX_VALUE);
        } else {
            this.setPlayCount(1);
        }
    }

    @Override
    public boolean isRepeating() {
        return this.autoRepeat;
    }

    @Override
    public void setPlayCount(int n) {
        int n2 = this.playCount;
        this.playCount = n;
        if (this.player != null) {
            this.player.setAutoRepeat(this.playCount > 1);
            this.autoRepeat = this.playCount > 1;
        }
        this.propertyChangeSupport.firePropertyChange("PLAY_COUNT_CHANGED", n2, n);
    }

    @Override
    public int getPlayCount() {
        return this.playCount;
    }

    @Override
    public void setCurrentPlayCount(int n) {
        if (n >= 0 && n < this.playCount) {
            this.currentCount = n;
        }
    }

    @Override
    public int getCurrentPlayCount() {
        return this.currentCount;
    }

    @Override
    public String getName() {
        return "MediaProvider PlayControl";
    }

    public void addMediaDurationListener(MediaDurationListener mediaDurationListener) {
        this.mediaDurationListeners.add(mediaDurationListener);
    }

    public void removeMediaDurationListener(MediaDurationListener mediaDurationListener) {
        this.mediaDurationListeners.remove(mediaDurationListener);
    }

    public void addBufferDownloadListener(BufferDownloadListener bufferDownloadListener) {
        this.bufferDownloadListeners.add(bufferDownloadListener);
    }

    public void removeBufferDownloadListener(BufferDownloadListener bufferDownloadListener) {
        this.bufferDownloadListeners.remove(bufferDownloadListener);
    }

    public void addMediaStateListener(MediaStateListener mediaStateListener) {
        this.mediaStateListeners.add(mediaStateListener);
    }

    public void removeMediaStateListener(MediaStateListener mediaStateListener) {
        this.mediaStateListeners.remove(mediaStateListener);
    }

    public void addMediaSizeListener(MediaSizeListener mediaSizeListener) {
        this.mediaSizeListeners.add(mediaSizeListener);
    }

    public void removeMediaSizeListener(MediaSizeListener mediaSizeListener) {
        this.mediaSizeListeners.remove(mediaSizeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addMediaTimerTaskCallback(MediaTimerTaskCallback mediaTimerTaskCallback) {
        if (this.mediaTimerTaskCallback == null) {
            this.mediaTimerTaskCallback = mediaTimerTaskCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaTimerTaskCallback() {
        if (this.mediaTimerTaskCallback != null) {
            MediaTimerTaskCallback mediaTimerTaskCallback = this.mediaTimerTaskCallback;
            synchronized (mediaTimerTaskCallback) {
                this.mediaTimerTaskCallback = null;
            }
        }
    }

    public void pauseMediaTimerTaskCallback(boolean bl) {
        this.mediaTimerTaskPaused = bl;
    }

    private void createMediaTimer() {
        if (this.mediaTimer == null) {
            this.mediaTimer = new Timer();
            this.mediaTimer.scheduleAtFixedRate((TimerTask)new MediaTimerTask(), 0L, 100L);
        }
    }

    private void destroyMediaTimer() {
        if (this.mediaTimer != null) {
            this.mediaTimer.cancel();
            this.mediaTimer = null;
        }
    }

    private void createEventQueue() {
        if (this.eventQueueThread == null) {
            this.eventQueueThread = new EventQueueThread();
            this.eventQueueThread.start();
        }
    }

    private void destroyEventQueue() {
        if (this.eventQueueThread != null) {
            this.eventQueueThread.terminateLoop();
            this.eventQueueThread = null;
        }
    }

    private void postEvent(MediaEvent mediaEvent) {
        if (this.eventQueueThread != null) {
            this.eventQueueThread.postEvent(mediaEvent);
        }
    }

    private void setPeer(PlayerPeer playerPeer) {
        this.player = playerPeer;
        this.createEventQueue();
        this.createMediaTimer();
        this.controls.add(this);
        if (this.audioControl == null) {
            this.audioControl = new AudioCtrl();
        }
        this.controls.add(this.audioControl);
        if (this.videoControl == null) {
            this.videoControl = new VideoCtrl();
        }
        this.controls.add(this.videoControl);
        if (this.subtitleControl == null) {
            this.subtitleControl = new SubtitleCtrl();
        }
        this.controls.add(this.subtitleControl);
        if (this.videoRenderControl == null) {
            this.videoRenderControl = new VideoRenderCtrl();
        }
        this.controls.add(this.videoRenderControl);
        if (this.trackControl == null) {
            this.trackControl = new TrackCtrl();
        }
        this.controls.add(this.trackControl);
        this.player.setEventQueue(this.eventQueueThread.getEventQuery());
        this.player.setNotificationTimes(this.notificationTimes);
        this.player.setAutoRepeat(this.autoRepeat);
        for (MediaControl mediaControl : this.controls) {
            if (!(mediaControl instanceof PersistControl)) continue;
            PersistControl persistControl = (PersistControl)((Object)mediaControl);
            persistControl.restoreProperties();
        }
    }

    private void freePeer() {
        if (this.player != null) {
            this.player.setEventQueue(null);
            this.player.dispose();
            this.player = null;
            this.mediaInfo = null;
        }
        this.controls.clear();
    }

    private boolean isSupported(PlayerPeer.Capabilities capabilities) {
        if (this.player != null) {
            return this.player.getCapabilities().contains((Object)capabilities);
        }
        return false;
    }

    private void close() {
        this.pause();
        this.freePeer();
        this.sourceUri = null;
        this.destroyMediaTimer();
        this.destroyEventQueue();
        this.updateCapabilities();
    }

    private void dispose() {
        this.close();
        if (this.mediaStateListeners != null) {
            this.mediaStateListeners.clear();
        }
        if (this.videoUpdateListeners != null) {
            this.videoUpdateListeners.clear();
        }
    }

    void addView(MediaView mediaView) {
        if (this.views.contains(mediaView)) {
            System.err.println("Already have view?");
            return;
        }
        this.views.add(mediaView);
        if (mediaView instanceof VideoRendererListener) {
            this.videoRenderControl.addVideoRendererListener((VideoRendererListener)((Object)mediaView));
        } else {
            System.err.println("View does not support RendererListener");
        }
    }

    void removeView(MediaView mediaView) {
        if (this.views.contains(mediaView)) {
            if (mediaView instanceof VideoRendererListener) {
                this.videoRenderControl.removeVideoRendererListener((VideoRendererListener)((Object)mediaView));
            }
        } else {
            System.err.println("removeView: no such view");
            return;
        }
        this.views.remove(mediaView);
    }

    private class AudioCtrl
    implements AudioControl,
    PersistControl {
        float volume = 1.0f;
        boolean isMuted = false;
        float balance = 0.0f;
        float fader = 0.0f;
        Locale language = null;

        public float setVolume(float f) {
            float f2 = this.volume;
            this.volume = Utils.reduceValue(f, 0.0f, 1.0f);
            if (!this.isMuted && MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                MediaProvider.this.player.setVolume(this.volume);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("VOLUME_CHANGED", Float.valueOf(f2), Float.valueOf(this.volume));
            return this.volume;
        }

        public float getVolume() {
            if (!this.isMuted && MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                this.volume = MediaProvider.this.player.getVolume();
            }
            return this.volume;
        }

        public void setMute(boolean bl) {
            boolean bl2 = this.isMuted;
            this.isMuted = bl;
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                if (this.isMuted) {
                    MediaProvider.this.player.setVolume(0.0f);
                } else {
                    MediaProvider.this.player.setVolume(this.volume);
                }
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("MUTE_CHANGED", bl2, this.isMuted);
        }

        public boolean isMuted() {
            return this.isMuted;
        }

        public float setBalance(float f) {
            float f2 = this.balance;
            this.balance = Utils.reduceValue(f, -1.0f, 1.0f);
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsBalance)) {
                MediaProvider.this.player.setBalance(this.balance);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("BALANCE_CHANGED", Float.valueOf(f2), Float.valueOf(this.balance));
            return this.balance;
        }

        public float getBalance() {
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsBalance)) {
                this.balance = MediaProvider.this.player.getBalance();
            }
            return this.balance;
        }

        public float setFader(float f) {
            float f2 = this.fader;
            this.fader = Utils.reduceValue(f, -1.0f, 1.0f);
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsFader)) {
                MediaProvider.this.player.setFader(this.fader);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("FADER_CHANGED", Float.valueOf(f2), Float.valueOf(this.fader));
            return this.fader;
        }

        public float getFader() {
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsFader)) {
                this.fader = MediaProvider.this.player.getFader();
            }
            return this.fader;
        }

        public void setAudioLanguage(Locale locale) throws OperationUnsupportedException {
            this.language = locale;
        }

        public String getName() {
            return "MediaProvider AudioControl";
        }

        public void restoreProperties() {
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                if (this.isMuted) {
                    MediaProvider.this.player.setVolume(0.0f);
                } else {
                    MediaProvider.this.player.setVolume(this.volume);
                }
            }
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsBalance)) {
                MediaProvider.this.player.setBalance(this.balance);
            }
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsFader)) {
                MediaProvider.this.player.setFader(this.fader);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CapabilityKey {
        SUPPORTS_SEEKING,
        SUPPORTS_SET_RATE,
        SUPPORTS_NOTIFICATION_TIMES,
        SUPPORTS_SET_VOLUME,
        SUPPORTS_BALANCE,
        SUPPORTS_FADER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CounterReset {
        RESET_NONE,
        RESET_AT_EOM,
        RESET_ON_PLAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventQueueThread
    extends Thread {
        private BlockingQueue<MediaEvent> eventQueue = new LinkedBlockingQueue<MediaEvent>();
        volatile boolean stopped = false;

        EventQueueThread() {
            this.setName("JMC MediaProvider EventQueueThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block8: while (!this.stopped) {
                try {
                    Object object4;
                    Iterator iterator;
                    MediaEvent mediaEvent = this.eventQueue.take();
                    if (this.stopped) continue;
                    if (mediaEvent instanceof MediaStateEvent) {
                        iterator = (MediaStateEvent)mediaEvent;
                        object4 = ((MediaStateEvent)((Object)iterator)).getMediaState();
                        switch (1.$SwitchMap$com$sun$media$jmc$event$MediaStateEvent$MediaState[((Enum)object4).ordinal()]) {
                            case 1: {
                                if (!MediaProvider.this.autoRepeat) {
                                    MediaProvider.this.pause();
                                }
                                if (MediaProvider.this.resetCounter == CounterReset.RESET_AT_EOM) {
                                    MediaProvider.this.resetCounter = CounterReset.RESET_ON_PLAY;
                                }
                                for (Object object2 : MediaProvider.this.mediaStateListeners) {
                                    object2.endOfMediaReached((MediaStateEvent)((Object)iterator));
                                }
                                continue block8;
                            }
                            case 2: {
                                if (MediaProvider.this.expectedState == State.STARTED) {
                                    MediaProvider.this.expectedState = null;
                                }
                                if (MediaProvider.this.state == State.STARTED) break;
                                MediaProvider.this.state = State.STARTED;
                                for (Object object2 : MediaProvider.this.mediaStateListeners) {
                                    object2.playerStarted((MediaStateEvent)((Object)iterator));
                                }
                                MediaProvider.this.propertyChangeSupport.firePropertyChange("PAUSED_CHANGED", true, false);
                                break;
                            }
                            case 3: {
                                if (MediaProvider.this.expectedState == State.PAUSED) {
                                    MediaProvider.this.expectedState = null;
                                }
                                if (MediaProvider.this.state == State.PAUSED) break;
                                MediaProvider.this.state = State.PAUSED;
                                for (Object object2 : MediaProvider.this.mediaStateListeners) {
                                    object2.playerStopped((MediaStateEvent)((Object)iterator));
                                }
                                MediaProvider.this.propertyChangeSupport.firePropertyChange("PAUSED_CHANGED", false, true);
                                break;
                            }
                            case 4: {
                                MediaProvider.this.currentCount++;
                                if (MediaProvider.this.playCount != Integer.MAX_VALUE && MediaProvider.this.currentCount + 1 >= MediaProvider.this.playCount) {
                                    MediaProvider.this.player.setAutoRepeat(false);
                                    MediaProvider.this.resetCounter = CounterReset.RESET_AT_EOM;
                                }
                                if (MediaProvider.this.state != State.STARTED) {
                                    // empty if block
                                }
                                for (Object object2 : MediaProvider.this.mediaStateListeners) {
                                    object2.playerRepeated((MediaStateEvent)((Object)iterator));
                                }
                                break;
                            }
                        }
                        continue;
                    }
                    if (mediaEvent instanceof VideoRendererEvent) {
                        iterator = (VideoRendererEvent)mediaEvent;
                        for (Object object3 : MediaProvider.this.videoUpdateListeners) {
                            object3.videoFrameUpdated((VideoRendererEvent)((Object)iterator));
                        }
                        continue;
                    }
                    if (mediaEvent instanceof MediaTimeEvent) {
                        Object object3;
                        Object object2;
                        iterator = (MediaTimeEvent)mediaEvent;
                        object4 = new Double(((MediaTimeEvent)((Object)iterator)).getNotificationTime());
                        object3 = (List)MediaProvider.this.notificationTimesMap.get(object4);
                        if (object3 == null) continue;
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            MediaTimeListener mediaTimeListener = (MediaTimeListener)object2.next();
                            mediaTimeListener.notificationTimeReached((MediaTimeEvent)((Object)iterator));
                        }
                        continue;
                    }
                    if (mediaEvent instanceof BufferDownloadedProgressChangedEvent) {
                        for (Object object4 : MediaProvider.this.bufferDownloadListeners) {
                            object4.mediaDownloadProgressChanged((BufferDownloadedProgressChangedEvent)mediaEvent);
                        }
                        continue;
                    }
                    if (mediaEvent instanceof DurationChangedEvent) {
                        for (Object object4 : MediaProvider.this.mediaDurationListeners) {
                            object4.mediaDurationChanged((DurationChangedEvent)mediaEvent);
                        }
                        continue;
                    }
                    if (!(mediaEvent instanceof SizeChangedEvent)) continue;
                    for (Object object4 : MediaProvider.this.mediaSizeListeners) {
                        object4.mediaSizeChanged((SizeChangedEvent)mediaEvent);
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        public BlockingQueue<MediaEvent> getEventQuery() {
            return this.eventQueue;
        }

        public void postEvent(MediaEvent mediaEvent) {
            if (this.eventQueue != null) {
                this.eventQueue.offer(mediaEvent);
            }
        }

        public void terminateLoop() {
            this.stopped = true;
            this.eventQueue.offer(new MediaEvent(0.0, "dummy event", this));
        }
    }

    private class MediaTimerTask
    extends TimerTask {
        private MediaTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (MediaProvider.this.mediaTimerTaskCallback != null && !MediaProvider.this.mediaTimerTaskPaused) {
                MediaTimerTaskCallback mediaTimerTaskCallback = MediaProvider.this.mediaTimerTaskCallback;
                synchronized (mediaTimerTaskCallback) {
                    MediaProvider.this.mediaTimerTaskCallback.invoke();
                }
            }
        }
    }

    public static interface MediaTimerTaskCallback {
        public void invoke();
    }

    private static interface PersistControl {
        public void restoreProperties();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STARTED,
        PAUSED;

    }

    private class SubtitleCtrl
    implements SubtitleControl,
    PersistControl {
        public boolean containsSubtitles() {
            return false;
        }

        public boolean displaySubtitles(boolean bl) {
            return false;
        }

        public void setSubtitleLanguage(Locale locale) throws OperationUnsupportedException {
        }

        public String getName() {
            return "MediaProvider SubtitleControl";
        }

        public void restoreProperties() {
            if (MediaProvider.this.player != null) {
                // empty if block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TrackCtrl
    implements TrackControl {
        @Override
        public List<MediaTrack> getMediaTracks() {
            return null;
        }

        @Override
        public void enableTrack(MediaTrack mediaTrack) {
        }

        @Override
        public void disableTrack(MediaTrack mediaTrack) {
        }

        @Override
        public boolean isEnabled(MediaTrack mediaTrack) {
            return true;
        }

        @Override
        public String getName() {
            return "MediaProvider TrackControl";
        }
    }

    private class VideoCtrl
    implements VideoControl,
    PersistControl {
        VideoControl.ResizeBehavior resizeBehavior = VideoControl.ResizeBehavior.Preserve;

        public int getFrameWidth() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameWidth();
            }
            return 0;
        }

        public int getFrameHeight() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameHeight();
            }
            return 0;
        }

        public void setResizeBehavior(VideoControl.ResizeBehavior resizeBehavior) {
            VideoControl.ResizeBehavior resizeBehavior2 = this.resizeBehavior;
            this.resizeBehavior = resizeBehavior;
            if (MediaProvider.this.player != null) {
                MediaProvider.this.player.setResizeBehavior(resizeBehavior);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("RESIZE_BEHAVIOR_CHANGED", (Object)resizeBehavior2, (Object)resizeBehavior);
        }

        public void setSourceRegion(Rectangle rectangle) {
        }

        public void setFullScreen(boolean bl) throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Fullscreen mode not supported.");
        }

        public String getName() {
            return "MediaProvider VideoControl";
        }

        public void restoreProperties() {
            if (MediaProvider.this.player != null) {
                MediaProvider.this.player.setResizeBehavior(this.resizeBehavior);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VideoRenderCtrl
    implements VideoRenderControl {
        @Override
        public boolean isRenderable() {
            return false;
        }

        @Override
        public void setDefaultRendering(boolean bl) {
        }

        @Override
        public boolean getDefaultRendering() {
            return true;
        }

        @Override
        public void addVideoRendererListener(VideoRendererListener videoRendererListener) {
            MediaProvider.this.videoUpdateListeners.add(videoRendererListener);
        }

        @Override
        public void removeVideoRendererListener(VideoRendererListener videoRendererListener) {
            MediaProvider.this.videoUpdateListeners.remove(videoRendererListener);
        }

        @Override
        public void getData(VideoDataBuffer videoDataBuffer) {
            MediaProvider.this.player.getFrameData(videoDataBuffer);
        }

        @Override
        public void releaseData(VideoDataBuffer videoDataBuffer) {
            MediaProvider.this.player.releaseFrameData(videoDataBuffer);
        }

        @Override
        public List<VideoDataBuffer.Format> getFormats() {
            return null;
        }

        @Override
        public int getFrameWidth() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameWidth();
            }
            return 0;
        }

        @Override
        public int getFrameHeight() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameHeight();
            }
            return 0;
        }

        @Override
        public String getName() {
            return "MediaProvider VideoRenderControl";
        }
    }
}

