/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.control.VideoControl;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.event.MediaEvent;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import javax.media.CannotRealizeException;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMFPlayerPeer
implements PlayerPeer,
ControllerListener {
    double rate = 1.0;
    Player jmfPlayer;
    boolean looping = true;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Container parentContainer = null;
    Boolean isStarted = true;
    BlockingQueue<MediaEvent> myQueue;
    float volume = 0.5f;
    Boolean isMute;
    private Set<PlayerPeer.Capabilities> caps = EnumSet.allOf(PlayerPeer.Capabilities.class);

    public JMFPlayerPeer(URI uRI) throws IOException, MediaException {
        try {
            this.jmfPlayer = Manager.createRealizedPlayer((URL)uRI.toURL());
        }
        catch (IOException iOException) {
            System.out.println("Got (JMF) IOE" + iOException);
            throw iOException;
        }
        catch (NoPlayerException noPlayerException) {
            System.out.println("Got (JMF) NoPlayer Exception" + (Object)((Object)noPlayerException));
            throw new MediaUnsupportedException("JMF thrown NoPlayerException", noPlayerException);
        }
        catch (CannotRealizeException cannotRealizeException) {
            System.out.println("Got (JMF) CnRE" + (Object)((Object)cannotRealizeException));
            throw new MediaException("Cannot realize", cannotRealizeException);
        }
        this.jmfPlayer.addControllerListener((ControllerListener)this);
    }

    @Override
    public int getFrameWidth() {
        return 0;
    }

    @Override
    public int getFrameHeight() {
        return 0;
    }

    public void XsetVideoDestination(Component component) {
        if (!(component instanceof Container)) {
            throw new MediaException("Video Destination is not a container");
        }
        this.parentContainer = (Container)component;
        this.parentContainer.setLayout(new BorderLayout());
        Component component2 = this.jmfPlayer.getVisualComponent();
        this.parentContainer.add(component2, "Center");
        Component component3 = this.jmfPlayer.getControlPanelComponent();
        this.parentContainer.add(component3, "South");
        this.parentContainer.validate();
        Dimension dimension = component2.getPreferredSize();
        System.out.println("vcd=" + dimension);
        Dimension dimension2 = component3.getPreferredSize();
        System.out.println("cpcD=" + dimension2);
        this.parentContainer.setSize(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
    }

    @Override
    public void pause() {
    }

    @Override
    public MediaPeer getMediaPeer() {
        return null;
    }

    @Override
    public void start() {
        this.jmfPlayer.start();
        this.isStarted = true;
    }

    @Override
    public void setSource(URI uRI) throws MediaException {
        Player player;
        try {
            player = Manager.createRealizedPlayer((URL)uRI.toURL());
        }
        catch (Exception exception) {
            throw new MediaException("Cannot Create Player for URI:" + uRI, exception);
        }
        System.out.println("NewPlayer...");
        if (this.jmfPlayer != null) {
            this.jmfPlayer.stop();
            this.jmfPlayer.removeControllerListener((ControllerListener)this);
            this.jmfPlayer.close();
        }
        this.jmfPlayer = player;
        this.jmfPlayer.addControllerListener((ControllerListener)this);
        if (this.isStarted.booleanValue()) {
            this.jmfPlayer.start();
        }
    }

    @Override
    public double getDuration() {
        Time time = this.jmfPlayer.getDuration();
        if (time == Time.TIME_UNKNOWN) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)time.getNanoseconds() / 1.0E8;
    }

    @Override
    public void setStartTime(double d) {
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public void setStopTime(double d) {
    }

    @Override
    public double getStopTime() {
        return 0.0;
    }

    @Override
    public void setMediaTime(double d) {
        Time time = new Time(d);
        this.jmfPlayer.setMediaTime(time);
    }

    @Override
    public double getMediaTime() {
        Time time = this.jmfPlayer.getMediaTime();
        return time.getSeconds();
    }

    @Override
    public void setRate(double d) {
        boolean bl;
        if (this.jmfPlayer.getState() == 600) {
            bl = true;
            this.jmfPlayer.stop();
        } else {
            bl = false;
        }
        this.rate = d;
        float f = this.jmfPlayer.setRate((float)d);
        System.out.println("JMF Set Rate to " + d + "got " + f);
        if (bl) {
            this.jmfPlayer.start();
        }
    }

    @Override
    public void setAutoRepeat(boolean bl) {
        this.looping = bl;
    }

    @Override
    public void setResizeBehavior(VideoControl.ResizeBehavior resizeBehavior) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ConfigureCompleteEvent || controllerEvent instanceof RealizeCompleteEvent || controllerEvent instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            this.jmfPlayer.setMediaTime(new Time(0L));
            if (this.looping) {
                this.jmfPlayer.start();
            }
        } else if (controllerEvent instanceof SizeChangeEvent) {
            // empty if block
        }
    }

    public float play(float f) {
        if ((double)f == 0.0) {
            this.jmfPlayer.stop();
            return 0.0f;
        }
        this.setRate(f);
        this.jmfPlayer.setRate(f);
        this.jmfPlayer.start();
        return 1.0f;
    }

    public boolean setMute(boolean bl) {
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            gainControl.setMute(bl);
            this.isMute = gainControl.getMute();
        } else {
            this.isMute = bl;
        }
        return this.isMute;
    }

    public boolean getMute() {
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            this.isMute = gainControl.getMute();
        }
        return this.isMute;
    }

    @Override
    public void setVolume(float f) {
        this.volume = f;
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            gainControl.setLevel(f);
            f = gainControl.getLevel();
        }
    }

    @Override
    public float getVolume() {
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            this.volume = gainControl.getLevel();
        }
        return this.volume;
    }

    @Override
    public void setBalance(float f) {
    }

    @Override
    public float getBalance() {
        return 0.0f;
    }

    @Override
    public void setFader(float f) {
    }

    @Override
    public float getFader() {
        return 0.0f;
    }

    @Override
    public void stop() {
        this.isStarted = false;
        this.jmfPlayer.stop();
    }

    @Override
    public double getRate() {
        return this.jmfPlayer.getRate();
    }

    @Override
    public void setEventQueue(BlockingQueue<MediaEvent> blockingQueue) {
        this.myQueue = blockingQueue;
    }

    @Override
    public void setNotificationTimes(List<Double> list) {
    }

    @Override
    public Set<PlayerPeer.Capabilities> getCapabilities() {
        return this.caps;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void getFrameData(VideoDataBuffer videoDataBuffer) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public void releaseFrameData(VideoDataBuffer videoDataBuffer) {
    }
}

