/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmc.Media;
import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaPeerImpl
implements MediaPeer {
    private Media media;
    private boolean isSeekable;

    protected MediaPeerImpl(Media media, boolean bl) {
        if (media == null) {
            throw new MediaException("Cannot create MediaPeerImpl.", new IllegalArgumentException("media == null!"));
        }
        this.media = media;
        this.isSeekable = bl;
    }

    @Override
    public List<MediaTrack> getMediaTracks() {
        return this.media.getMediaTracks();
    }

    @Override
    public double getDuration() {
        return this.media.getDuration();
    }

    @Override
    public ContainerType getContainerType() {
        return this.media.getContainerType();
    }

    public <T> T getMetadata(String string, Class<T> clazz) {
        return this.media.getMetadata(string, clazz);
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.media.getMetadata();
    }

    public boolean isSeekable() {
        return this.isSeekable;
    }

    @Override
    public int getFrameWidth() {
        int n = 0;
        for (MediaTrack mediaTrack : this.getMediaTracks()) {
            if (mediaTrack instanceof VideoTrack && (n = ((VideoTrack)mediaTrack).getFrameWidth()) > 0) break;
        }
        return n;
    }

    @Override
    public int getFrameHeight() {
        int n = 0;
        for (MediaTrack mediaTrack : this.getMediaTracks()) {
            if (mediaTrack instanceof VideoTrack && (n = ((VideoTrack)mediaTrack).getFrameHeight()) > 0) break;
        }
        return n;
    }

    @Override
    public PlayerPeer getPlayerPeer() {
        return null;
    }
}

