/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.spi;

import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderRegistry<T> {
    public final Class<T> providerClass;
    private List<T> list = null;
    private long lastRefreshTime = 0L;
    private final int AUTOREFRESH_DEFAULT = 60000;
    private long autoRefreshPeriod = 60000L;
    public final int AUTOREFRESH_NEVER = -1;
    public final int AUTOREFRESH_ALWAYS = 0;

    private <E> List<E> lookupProviders(final Class<E> clazz) throws NullPointerException {
        PrivilegedAction privilegedAction = new PrivilegedAction<List<E>>(){

            @Override
            public List<E> run() {
                LinkedList linkedList = new LinkedList();
                Iterator iterator = Service.providers((Class)clazz);
                try {
                    while (iterator.hasNext()) {
                        try {
                            linkedList.add(iterator.next());
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return linkedList;
            }
        };
        return (List)AccessController.doPrivileged(privilegedAction);
    }

    public ProviderRegistry(Class<T> clazz) throws NullPointerException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.providerClass = clazz;
    }

    private void doRefresh() {
        this.list = this.lookupProviders(this.providerClass);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    private void autoRefresh() {
        if (this.list != null) {
            if (this.autoRefreshPeriod < 0L) {
                return;
            }
            if (this.autoRefreshPeriod > 0L && System.currentTimeMillis() - this.lastRefreshTime < this.autoRefreshPeriod) {
                return;
            }
        }
        this.doRefresh();
    }

    public synchronized void refresh() {
        this.doRefresh();
    }

    public void setAutoRefreshPeriod(int n) {
        this.autoRefreshPeriod = (long)n * 1000L;
    }

    public synchronized Iterator<T> getProviders() {
        this.autoRefresh();
        return Collections.unmodifiableList(this.list).iterator();
    }

    public synchronized T[] getProviderArray() {
        this.autoRefresh();
        Object[] objectArray = (Object[])Array.newInstance(this.providerClass, this.list.size());
        Iterator<T> iterator = this.list.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }
}

