/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.scenario.animation.Animation;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AnimationList<T extends Animation, N extends AnimationList<T, N>>
implements Iterable<N> {
    protected long t;
    protected T v;
    N next;

    AnimationList() {
    }

    protected AnimationList(T t, long l) {
        this.v = t;
        this.t = l;
    }

    protected abstract N makeEntry(T var1, long var2);

    public final long getTime() {
        return this.t;
    }

    public final T getAnimation() {
        return this.v;
    }

    final boolean isEmpty() {
        return this.next == null;
    }

    final void clear() {
        this.next = null;
    }

    final void insert(T t, long l) {
        this.insert(this.makeEntry(t, l));
    }

    final void insert(N n) {
        N n2;
        AnimationList<T, N> animationList = this;
        while ((n2 = animationList.next) != null && ((AnimationList)n).t >= ((AnimationList)n2).t) {
            animationList = n2;
        }
        ((AnimationList)n).next = n2;
        animationList.next = n;
    }

    final void append(T t, long l) {
        this.append(this.makeEntry(t, l));
    }

    final void append(N n) {
        N n2;
        AnimationList<T, N> animationList = this;
        while ((n2 = animationList.next) != null) {
            animationList = n2;
        }
        animationList.next = n;
    }

    final void prepend(N n) {
        ((AnimationList)n).next = this.next;
        this.next = n;
    }

    final N find(T t) {
        N n = this.next;
        while (n != null) {
            if (((AnimationList)n).v == t) {
                return n;
            }
            n = ((AnimationList)n).next;
        }
        return null;
    }

    final N remove(T t) {
        N n;
        AnimationList<T, N> animationList = this;
        while ((n = animationList.next) != null) {
            if (((AnimationList)n).v == t) {
                animationList.next = ((AnimationList)n).next;
                ((AnimationList)n).next = null;
                return n;
            }
            animationList = n;
        }
        return null;
    }

    @Override
    public final Iterator<N> iterator() {
        return this.iterator(null);
    }

    final Iterator<N> iterator(Animation animation) {
        return new LinkIter(this, animation);
    }

    final Iterable<T> animations(final Animation animation) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AnimIter(AnimationList.this, animation);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AnimIter<TT extends Animation, NN extends AnimationList<TT, NN>>
    extends BaseIter<NN>
    implements Iterator<TT> {
        public AnimIter(AnimationList<?, NN> animationList, Animation animation) {
            super(animationList, animation);
        }

        @Override
        public TT next() {
            return (TT)((AnimationList)super.nextLink()).getAnimation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseIter<NN extends AnimationList<?, NN>> {
        AnimationList<?, NN> prev;
        AnimationList<?, NN> cur;
        Animation runCheck;

        public BaseIter(AnimationList<?, NN> animationList, Animation animation) {
            this.cur = animationList;
            this.runCheck = animation;
        }

        public boolean hasNext() {
            return this.cur.next != null;
        }

        public NN nextLink() {
            this.prev = this.cur;
            Object n = this.cur.next;
            this.cur = n;
            return (NN)n;
        }

        public void remove() {
            if (this.prev == null) {
                throw new IllegalStateException("no element to remove");
            }
            if (this.runCheck != null && this.runCheck.isRunning()) {
                throw new UnsupportedOperationException("cannot call remove while animation is running");
            }
            this.prev.next = this.cur.next;
            this.cur.next = null;
            this.cur = this.prev;
            this.prev = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LinkIter<NN extends AnimationList<?, NN>>
    extends BaseIter<NN>
    implements Iterator<NN> {
        public LinkIter(AnimationList<?, NN> animationList, Animation animation) {
            super(animationList, animation);
        }

        @Override
        public NN next() {
            return super.nextLink();
        }
    }
}

